/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.CdsCommunicationException;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.connector.CdsDataStoreConnectorBuilder;
import com.sap.cds.impl.AbstractDataStoreConnector;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.DbContextFactoryRegister;
import com.sap.cds.impl.JDBCClient;
import com.sap.cds.impl.SystemPropertyDataStoreConfiguration;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.sql.DataSource;

public class JDBCDataStoreConnector
extends AbstractDataStoreConnector {
    private final TransactionManager transactionManager;
    private Supplier<Connection> ds;

    private JDBCDataStoreConnector(CdsModel cdsModel, Supplier<Connection> ds, TransactionManager transactionManager, DataStoreConfiguration dataStoreConfiguration) {
        super(cdsModel, (Context ctx) -> new JDBCClient(ctx, ds, transactionManager), DbContextFactoryRegister.context(dataStoreConfiguration, ds), dataStoreConfiguration);
        this.transactionManager = transactionManager;
        this.ds = ds;
    }

    public static Builder create(CdsModel model, TransactionManager transactionManager) {
        return new Builder(model, transactionManager);
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public Connection getConnection() {
        return this.ds.get();
    }

    public static class Builder
    implements CdsDataStoreConnectorBuilder {
        private final CdsModel model;
        private final TransactionManager transactionManager;
        private Supplier<Connection> connectionSupplier;
        private DataStoreConfiguration dataStoreConfiguration = new SystemPropertyDataStoreConfiguration();

        private Builder(CdsModel model, TransactionManager transactionManager) {
            this.model = model;
            this.transactionManager = transactionManager;
        }

        public CdsDataStoreConnectorBuilder datasource(DataSource datasource) {
            this.connectionSupplier = () -> {
                try {
                    return datasource.getConnection();
                }
                catch (SQLException e) {
                    throw new CdsCommunicationException("Cannot obtain connection to DB", (Throwable)e);
                }
            };
            return this;
        }

        public CdsDataStoreConnectorBuilder connection(Supplier<Connection> connectionSupplier) {
            this.connectionSupplier = connectionSupplier;
            return this;
        }

        public CdsDataStoreConnectorBuilder config(DataStoreConfiguration dataStoreConfiguration) {
            this.dataStoreConfiguration = dataStoreConfiguration;
            return this;
        }

        public JDBCDataStoreConnector build() {
            return new JDBCDataStoreConnector(this.model, this.connectionSupplier, this.transactionManager, this.dataStoreConfiguration);
        }
    }
}

