/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class GenericFunctionMapper
implements FunctionMapper {
    private static final String TOLOWER = "tolower";
    protected static final CqnPlain LIKE = CqnPlainImpl.plain((String)"LIKE");
    protected static final CqnPlain ILIKE = CqnPlainImpl.plain((String)"ILIKE");
    protected static final CqnPlain ESCAPE = CqnPlainImpl.plain((String)"ESCAPE");
    protected static final String UNICODE_WHITESPACE_SQL = SQLHelper.literal("\t\n\u000b\f\r \u0085\u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u2028\u2029\u202f\u205f\u3000");

    public String toSql(String cqnFunc, List<String> args) {
        String func;
        return switch (func = cqnFunc.toLowerCase(Locale.US)) {
            case "average" -> "AVG(" + args.get(0) + ")";
            case "countdistinct" -> "COUNT(DISTINCT " + args.get(0) + ")";
            case TOLOWER -> this.genericFuncToSql("LOWER", args);
            case "toupper" -> this.genericFuncToSql("UPPER", args);
            case "current_date" -> "current_date";
            case "current_time" -> "current_time";
            case "current_timestamp" -> "current_timestamp";
            case "count" -> {
                if (args.isEmpty()) {
                    yield "COUNT(*)";
                }
                yield this.genericFuncToSql(cqnFunc, args);
            }
            case "matchespattern" -> this.genericFuncToSql("LIKE_REGEX", args);
            case "indexof" -> this.genericFuncToSql("instr", args) + " - 1";
            case "trim" -> "TRIM(BOTH " + UNICODE_WHITESPACE_SQL + " FROM " + args.get(0) + ")";
            default -> this.genericFuncToSql(cqnFunc, args);
        };
    }

    protected String genericFuncToSql(String func, List<String> args) {
        return func.toUpperCase(Locale.US) + args.stream().collect(Collectors.joining(", ", "(", ")"));
    }

    public Predicate like(CqnValue value, CqnValue pattern, String esc, boolean caseInsensitive) {
        if (caseInsensitive) {
            value = CQL.func((String)TOLOWER, (CqnValue[])new CqnValue[]{value});
            pattern = CQL.func((String)TOLOWER, (CqnValue[])new CqnValue[]{pattern});
        }
        return ExpressionBuilder.create((CqnToken[])new CqnToken[]{value, LIKE, pattern, ESCAPE, CQL.constant((Object)esc)}).predicate();
    }

    protected Predicate ilike(CqnValue value, CqnValue pattern, String esc, boolean caseInsensitive) {
        CqnPlain operator = caseInsensitive ? ILIKE : LIKE;
        return ExpressionBuilder.create((CqnToken[])new CqnToken[]{value, operator, pattern, ESCAPE, CQL.constant((Object)esc)}).predicate();
    }
}

