/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana;

import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.CqnTableFunction;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.Context;
import com.sap.cds.jdbc.generic.GenericDbContext;
import com.sap.cds.jdbc.hana.HanaBinder;
import com.sap.cds.jdbc.hana.HanaExceptionAnalyzer;
import com.sap.cds.jdbc.hana.HanaFunctionMapper;
import com.sap.cds.jdbc.hana.HanaPredicateMapper;
import com.sap.cds.jdbc.hana.HanaScalarValueResolver;
import com.sap.cds.jdbc.hana.HanaSessionVariableSetter;
import com.sap.cds.jdbc.hana.HanaSqlMapping;
import com.sap.cds.jdbc.hana.HanaStatementResolver;
import com.sap.cds.jdbc.hana.hierarchies.HierarchyFunctionMapper;
import com.sap.cds.jdbc.hana.json.HanaDocStoreDbContext;
import com.sap.cds.jdbc.hana.search.HanaSearchResolver;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.PredicateMapper;
import com.sap.cds.jdbc.spi.ScalarValueResolver;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.TableFunctionMapper;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.ql.hana.CqnHierarchy;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class HanaDbContext
extends GenericDbContext {
    public static final String USE_HEX_PLAN = "hana.USE_HEX_PLAN";
    public static final String NO_USE_HEX_PLAN = "hdb.NO_USE_HEX_PLAN";
    private final int majorVersion;
    private boolean enforceLegacyEngine;

    public HanaDbContext(DataStoreConfiguration dataStoreConfiguration, int majorVersion) {
        super(dataStoreConfiguration);
        this.majorVersion = majorVersion;
        this.enforceLegacyEngine = majorVersion < 4 || "legacy".equals(this.config.getProperty("cds.sql.hana.compatibilityMode"));
    }

    @Override
    public SearchResolver createSearchResolver(CdsModel model, Locale locale, Map<String, Object> hints) {
        if (hints.get(USE_HEX_PLAN) == Boolean.TRUE) {
            return HanaSearchResolver.forHexEngine(this.config, model, locale);
        }
        if (this.enforceLegacyEngine || hints.get(NO_USE_HEX_PLAN) == Boolean.TRUE) {
            return HanaSearchResolver.forLegacyEngine(this.config, model, locale);
        }
        return HanaSearchResolver.forHexEngine(this.config, model, locale);
    }

    @Override
    public StatementResolver getStatementResolver() {
        return new HanaStatementResolver(this.config, this.majorVersion, !this.enforceLegacyEngine);
    }

    @Override
    public PredicateMapper getPredicateMapper() {
        return new HanaPredicateMapper();
    }

    @Override
    public ExceptionAnalyzer getExceptionAnalyzer() {
        return new HanaExceptionAnalyzer();
    }

    @Override
    public CdsDataStoreConnector.Capabilities getCapabilities() {
        return CdsDataStoreConnector.Capabilities.ALL;
    }

    @Override
    public ValueBinder getBinder(TimeZone timeZone) {
        return new HanaBinder(timeZone);
    }

    @Override
    public SessionVariableSetter getSessionVariableSetter() {
        return new HanaSessionVariableSetter();
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        return new HanaFunctionMapper();
    }

    public DbContext subDialect(String name) {
        if ("JsonDocStore".equalsIgnoreCase(name)) {
            return new HanaDocStoreDbContext(this);
        }
        return this;
    }

    @Override
    public ScalarValueResolver getScalarValueResolver() {
        return HanaScalarValueResolver.INSTANCE;
    }

    public TableFunctionMapper getTableFunctionMapper(Object context, List params, CqnTableFunction tableFunction) {
        if (tableFunction instanceof CqnHierarchy) {
            CqnHierarchy hierarchy = (CqnHierarchy)tableFunction;
            return HierarchyFunctionMapper.create((Context)context, params, hierarchy);
        }
        return super.getTableFunctionMapper(context, params, tableFunction);
    }

    @Override
    public SqlMapping getSqlMapping(CdsStructuredType rowType) {
        return new HanaSqlMapping(rowType, this.casing());
    }
}

