/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.search;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.builder.model.ListValue;
import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.jdbc.hana.search.HanaSearchResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CdsSearchUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HanaSearchResolverUsingScore
extends HanaSearchResolver {
    private static final String FUZZINESS_THRESHOLD_ANNOTATION = "@Search.fuzzinessThreshold";
    private static final String RANKING_ANNOTATION = "@Search.ranking";
    private static final String EXACT = "EXACT";
    private static final String FUZZY_MIN_SCORE = "FUZZY MINIMAL SCORE";
    private static final String WEIGHT = "WEIGHT";
    private static final String SCM_SEARCH = "SIMILARITY CALCULATION MODE 'search'";
    private static final String SCM_TYPE_AHEAD = "SIMILARITY CALCULATION MODE 'type ahead'";

    public HanaSearchResolverUsingScore(DataStoreConfiguration config, CdsModel cdsModel, Locale locale) {
        super(config, cdsModel, locale);
    }

    public CqnPredicate resolve(CqnPredicate searchExpression, CdsStructuredType rowType, boolean exactSearch) {
        Map<CqnElementRef, CdsElement> searchElements = CdsSearchUtils.searchableElementRefs((CdsStructuredType)rowType).stream().collect(Collectors.toMap(ref -> ref, ref -> CdsModelUtils.element((CdsStructuredType)rowType, (CqnElementRef)ref)));
        return this.scorePredicate(searchElements, searchExpression, exactSearch);
    }

    @Override
    protected CqnPredicate searchToHana(Map<CqnElementRef, CdsElement> scoreRefs, CqnPredicate expression) {
        return this.scorePredicate(scoreRefs, expression, false);
    }

    private CqnPredicate scorePredicate(Map<CqnElementRef, CdsElement> scoreRefs, CqnPredicate expression, boolean exactSearch) {
        boolean fuzzy = !exactSearch && this.fuzzySearch();
        HanaSearchResolver.SearchString searchString = HanaSearchResolverUsingScore.toSearchString(expression, fuzzy);
        ExpressionBuilder scoreBuilder = ExpressionBuilder.create((CqnToken[])new CqnToken[0]).plain("SCORE(").val((Object)searchString.searchString()).plain("IN");
        if (fuzzy && !searchString.containsWildcards()) {
            BigDecimal minScore = this.fuzzinessThreshold();
            HanaSearchResolverUsingScore.addScoreElements(scoreBuilder, scoreRefs, minScore);
        } else {
            scoreBuilder.add((CqnToken)ListValue.of(scoreRefs.keySet()));
            scoreBuilder.plain(EXACT);
        }
        scoreBuilder.plain(")");
        return CQL.comparison((CqnValue)scoreBuilder.value(), (CqnComparisonPredicate.Operator)CqnComparisonPredicate.Operator.GT, (CqnValue)CQL.constant((Object)0));
    }

    private static void addScoreElements(ExpressionBuilder score, Map<CqnElementRef, CdsElement> scoreRefs, BigDecimal minScore) {
        score.plain("(");
        boolean sameScoringType = true;
        boolean sameWeight = true;
        ScoringType firstScoringType = null;
        HashMap<CqnElementRef, ScoringType> scoringTypes = new HashMap<CqnElementRef, ScoringType>(scoreRefs.size());
        for (Map.Entry<CqnElementRef, CdsElement> e : scoreRefs.entrySet()) {
            ScoringType scoringType = ScoringType.create(e.getValue(), minScore);
            scoringTypes.put(e.getKey(), scoringType);
            if (firstScoringType == null) {
                firstScoringType = scoringType;
                continue;
            }
            if (scoringType.equals(firstScoringType)) continue;
            sameScoringType = false;
            if (scoringType.weight() == firstScoringType.weight()) continue;
            sameWeight = false;
        }
        int i = 0;
        int size = scoreRefs.size();
        for (CqnElementRef ref : scoreRefs.keySet()) {
            score.add((CqnToken)ref);
            if (!sameScoringType) {
                HanaSearchResolverUsingScore.scoringType(score, (ScoringType)scoringTypes.get(ref), !sameWeight);
            }
            if (++i >= size) continue;
            score.plain(",");
        }
        score.plain(")");
        if (sameScoringType) {
            HanaSearchResolverUsingScore.scoringType(score, firstScoringType, false);
        }
    }

    private static void scoringType(ExpressionBuilder score, ScoringType scoringType, boolean addWeight) {
        float weight;
        if (scoringType.fuzzy()) {
            score.plain(FUZZY_MIN_SCORE);
            score.constant((Object)scoringType.minScore());
            String scm = scoringType.scm();
            if (scm != null) {
                score.plain(scm);
            }
        } else {
            score.plain(EXACT);
        }
        if (addWeight && (weight = scoringType.weight()) < 1.0f) {
            score.plain(WEIGHT);
            score.constant((Object)Float.valueOf(weight));
        }
    }

    @Override
    protected boolean needsPushToSubquery(CdsElement element) {
        return false;
    }

    @Override
    protected boolean handleLocalizedElement(CdsStructuredType targetType, Set<CqnElementRef> like, Map<CqnElementRef, CdsElement> score, boolean languageGiven, CqnElementRef ref, CdsElement element) {
        if (languageGiven && HanaSearchResolverUsingScore.isReachableViaLocalizedAssoc(element) && !this.searchLocalizedView(targetType)) {
            score.put(ref, element);
            score.put(this.localizedRef(ref), element);
            return true;
        }
        score.put(ref, element);
        return false;
    }

    private boolean searchLocalizedView(CdsStructuredType targetType) {
        String searchMode = (String)targetType.getAnnotationValue("@cds.sql.search.mode", (Object)this.configuredSearchMode());
        return "localized-view".equalsIgnoreCase(searchMode);
    }

    @Override
    protected void handleRegularElement(CdsStructuredType targetType, Set<CqnElementRef> like, Map<CqnElementRef, CdsElement> score, CqnElementRef ref, CdsElement element) {
        score.put(ref, element);
    }

    @Override
    protected void handleLargeStringElement(Set<CqnElementRef> like, Map<CqnElementRef, CdsElement> score, CdsStructuredType targetType, CqnElementRef ref, CdsElement element) {
        score.put(ref, element);
    }

    @Override
    protected void handleToManyElements(CdsStructuredType targetType, Set<CqnElementRef> like, Map<CqnElementRef, CdsElement> score, boolean languageGiven, CqnElementRef ref, CdsElement element) {
        score.put(ref, element);
    }

    @Override
    protected String defaultSearchMode() {
        return "localized-association";
    }

    private record ScoringType(boolean fuzzy, BigDecimal minScore, String scm, float weight) {
        private static ScoringType create(CdsElement element, BigDecimal minScore) {
            boolean fuzzy = (minScore = ScoringType.minScore(element, minScore)).compareTo(BigDecimal.ONE) < 0;
            float weight = ScoringType.weight(element);
            String scm = null;
            if (fuzzy) {
                CdsType type = element.getType();
                if (ScoringType.fuzzySearchMode(type)) {
                    scm = HanaSearchResolverUsingScore.SCM_SEARCH;
                } else if (type.isSimpleType(CdsBaseType.UUID)) {
                    scm = HanaSearchResolverUsingScore.SCM_TYPE_AHEAD;
                }
            }
            return new ScoringType(fuzzy, minScore, scm, weight);
        }

        private static boolean fuzzySearchMode(CdsType type) {
            return type.isSimpleType(CdsBaseType.STRING) || type.isSimpleType(CdsBaseType.LARGE_STRING);
        }

        private static float weight(CdsElement element) {
            Object ranking = element.getAnnotationValue(HanaSearchResolverUsingScore.RANKING_ANNOTATION, null);
            if (ranking instanceof Map) {
                String rank;
                Map m = (Map)ranking;
                return switch (rank = (String)m.get("=")) {
                    case "HIGH" -> 1.0f;
                    case "MEDIUM" -> 0.7f;
                    case "LOW" -> 0.5f;
                    default -> throw new IllegalArgumentException("Invalid ranking: " + rank);
                };
            }
            return element.isKey() ? 1.0f : 0.7f;
        }

        private static BigDecimal minScore(CdsElement element, BigDecimal minScore) {
            Number fuzziness = (Number)element.getAnnotationValue(HanaSearchResolverUsingScore.FUZZINESS_THRESHOLD_ANNOTATION, (Object)minScore);
            if (fuzziness instanceof BigDecimal) {
                BigDecimal d = (BigDecimal)fuzziness;
                return d;
            }
            if (fuzziness instanceof Integer) {
                Integer i = (Integer)fuzziness;
                return BigDecimal.valueOf(i.intValue());
            }
            throw new IllegalArgumentException("Invalid fuzziness threshold: " + fuzziness);
        }
    }
}

