/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.qat;

import com.sap.cds.CqnTableFunction;
import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.CqnValidatorImpl;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.impl.qat.QatAssociation;
import com.sap.cds.impl.qat.QatAssociationNode;
import com.sap.cds.impl.qat.QatElementNode;
import com.sap.cds.impl.qat.QatEntityRootNode;
import com.sap.cds.impl.qat.QatNode;
import com.sap.cds.impl.qat.QatSelectRootNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.qat.QatStructuredElementNode;
import com.sap.cds.impl.qat.QatStructuredNode;
import com.sap.cds.impl.qat.QatTableFunctionRootNode;
import com.sap.cds.impl.qat.QatTraverser;
import com.sap.cds.impl.qat.QatVisitor;
import com.sap.cds.impl.util.Stack;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExistsSubquery;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.List;
import java.util.Optional;

public class QatBuilder {
    private static final int T = 84;
    public static final String ROOT_ALIAS = QatBuilder.alias(0, 0);
    private final CqnSelect select;
    private final int queryDepth;
    private final QatSelectableNode root;

    public QatBuilder(Context context, CqnSelect select, int queryDepth) {
        this.select = select;
        this.queryDepth = queryDepth;
        CqnSource source = select.from();
        if (source.isRef()) {
            CqnReference.Segment rootSegment = source.asRef().rootSegment();
            CdsEntity rootEntity = context.getCdsModel().getEntity(rootSegment.id());
            this.root = new QatEntityRootNode(rootEntity, rootSegment.filter());
        } else if (source.isSelect()) {
            CqnSelect subquery = source.asSelect();
            CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)context.getCdsModel(), (CqnSelect)subquery);
            this.root = new QatSelectRootNode(subquery, rowType);
        } else if (source.isTableFunction()) {
            CqnTableFunction tableFunction = source.asTableFunction();
            CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)context.getCdsModel(), (CqnSource)tableFunction);
            this.root = new QatTableFunctionRootNode(tableFunction, rowType);
        } else {
            throw new UnsupportedOperationException("Joins are not supported");
        }
    }

    public QatSelectableNode create() {
        this.collectRefs();
        this.assignTableAliases();
        return this.root;
    }

    private void assignTableAliases() {
        QatVisitor assignAlias = new QatVisitor(){
            int i = 0;

            @Override
            public void visit(QatSelectableNode root) {
                this.assignAlias(root);
            }

            @Override
            public void visit(QatAssociationNode association) {
                this.assignAlias(association);
            }

            private void assignAlias(QatSelectableNode node) {
                node.setAlias(QatBuilder.alias(QatBuilder.this.queryDepth, this.i++));
            }
        };
        QatTraverser.take(assignAlias).traverse(this.root);
    }

    private static String alias(int i, int j) {
        return String.valueOf((char)(84 + i)) + j;
    }

    private void collectRefs() {
        CollectRefsVisitor visitor = new CollectRefsVisitor(this.root);
        this.select.accept((CqnVisitor)visitor);
    }

    private static List<? extends CqnReference.Segment> skipFirst(CqnReference ref) {
        List segments = ref.segments();
        return segments.subList(1, segments.size());
    }

    class CollectRefsVisitor
    implements CqnVisitor {
        private final AssociationAnalyzer associationAnalyzer = new AssociationAnalyzer();
        private final String rootEntity;
        private final Stack<QatNode> base = new Stack();

        private CollectRefsVisitor(QatSelectableNode root) {
            this.base.push((Object)root);
            this.rootEntity = root.rowType().getQualifiedName();
        }

        public void visit(CqnStructuredTypeRef ref) {
            ref.rootSegment().filter().ifPresent(f -> f.accept((CqnVisitor)this));
            QatNode root = this.followRef((QatNode)this.base.pop(), QatBuilder.skipFirst((CqnReference)ref), true);
            this.base.push((Object)root);
        }

        public void visit(CqnElementRef ref) {
            if (!ref.firstSegment().equals("$outer") && !CdsModelUtils.isContextElementRef((CqnElementRef)ref)) {
                List<? extends CqnReference.Segment> segments = ref.segments();
                if (segments.size() > 1 && ref.firstSegment().equals(this.rootEntity)) {
                    segments = QatBuilder.skipFirst((CqnReference)ref);
                }
                this.followRef((QatNode)this.base.peek(), segments, false);
            }
        }

        public void visit(CqnExistsSubquery exists) {
            final QatNode outer = (QatNode)this.base.peek();
            ((ExistsSubquery)exists).setOuter((Object)outer);
            CqnVisitor v = new CqnVisitor(){

                public void visit(CqnElementRef ref) {
                    if (ref.firstSegment().equals("$outer")) {
                        CollectRefsVisitor.this.followRef(outer, QatBuilder.skipFirst((CqnReference)ref), false);
                    }
                }
            };
            exists.subquery().accept(v);
        }

        public void visit(CqnContainmentTest test) {
            test.args().forEach(a -> a.accept((CqnVisitor)this));
        }

        private QatNode followRef(QatNode current, List<? extends CqnReference.Segment> segments, boolean inSource) {
            for (CqnReference.Segment segment : segments) {
                current = this.addChild(current, segment, inSource);
                this.traverseFilter(current, segment);
            }
            return current;
        }

        private QatNode addChild(QatNode node, CqnReference.Segment seg, boolean inSource) {
            QatNode child;
            String id = seg.id();
            Optional filter = seg.filter();
            CdsStructuredType rowType = ((QatStructuredNode)node).rowType();
            CdsElement element = rowType.getElement(id);
            if (element.isVirtual()) {
                throw CqnValidatorImpl.virtualElementException(element.getName());
            }
            CdsType type = element.getType();
            if (type.isAssociation()) {
                QatAssociation assoc = this.handleAssociation(element);
                child = new QatAssociationNode(node, assoc, (Optional<CqnPredicate>)filter, inSource);
            } else {
                child = type.isStructured() ? new QatStructuredElementNode(node, element) : new QatElementNode(node, element);
            }
            return node.addChild(child, filter);
        }

        private void traverseFilter(QatNode node, CqnReference.Segment seg) {
            seg.filter().ifPresent(f -> {
                this.base.push((Object)node);
                f.accept((CqnVisitor)this);
                this.base.pop();
            });
        }

        private QatAssociation handleAssociation(CdsElement association) {
            CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
            CqnPredicate on = this.associationAnalyzer.getOnCondition(association);
            return new QatAssociation(target, association.getName(), on);
        }
    }
}

