/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SpaceSeparatedCollector;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public class DeleteStatementBuilder
implements SQLStatementBuilder {
    private final CqnDelete delete;
    private final TokenToSQLTransformer toSQL;
    private final SqlMapping sqlMapping;
    private final String tableName;
    private final CdsEntity entity;
    private final List<PreparedCqnStmt.Parameter> params = new ArrayList<PreparedCqnStmt.Parameter>();

    public DeleteStatementBuilder(Context context, CqnDelete delete) {
        this.delete = delete;
        this.entity = context.getCdsModel().getEntity(delete.ref().firstSegment());
        this.sqlMapping = context.getDbContext().getSqlMapping((CdsStructuredType)this.entity);
        this.tableName = this.sqlMapping.tableName();
        Function<CqnElementRef, String> aliasResolver = SQLStatementBuilder.aliasResolver(context, this.entity);
        this.toSQL = TokenToSQLTransformer.notCollating(context, aliasResolver, this.entity, this.tableName, this.params);
    }

    @Override
    public SQLStatementBuilder.SQLStatement build() {
        Stream.Builder<String> builder = Stream.builder();
        builder.add("DELETE FROM");
        builder.add(this.tableName);
        this.delete.where().map(w -> this.toSQL.toSQL((CdsStructuredType)this.entity, (CqnPredicate)w)).ifPresent(s -> {
            builder.add("WHERE");
            builder.add((String)s);
        });
        String sql = builder.build().collect(SpaceSeparatedCollector.joining());
        return new SQLStatementBuilder.SQLStatement(sql, this.params);
    }
}

