/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class GenericFunctionMapper
implements FunctionMapper {
    private static final String TOLOWER = "tolower";
    protected static final CqnPlain LIKE = CqnPlainImpl.plain((String)"LIKE");
    protected static final CqnPlain ILIKE = CqnPlainImpl.plain((String)"ILIKE");
    protected static final CqnPlain ESCAPE = CqnPlainImpl.plain((String)"ESCAPE");

    public String toSql(String cqnFunc, List<String> args) {
        String func;
        switch (func = cqnFunc.toLowerCase(Locale.US)) {
            case "countdistinct": {
                return "COUNT(DISTINCT " + args.get(0) + ")";
            }
            case "tolower": {
                return this.genericFuncToSql("LOWER", args);
            }
            case "toupper": {
                return this.genericFuncToSql("UPPER", args);
            }
            case "current_date": {
                return "current_date";
            }
            case "current_time": {
                return "current_time";
            }
            case "current_timestamp": {
                return "current_timestamp";
            }
            case "singlevalue": {
                String col = args.get(0);
                return MessageFormat.format("(case when min({0}) = max({0}) then min ({0}) end)", col);
            }
            case "count": {
                if (!args.isEmpty()) break;
                return "COUNT(*)";
            }
            case "matchespattern": {
                return this.genericFuncToSql("LIKE_REGEX", args);
            }
        }
        return this.genericFuncToSql(cqnFunc, args);
    }

    protected String genericFuncToSql(String func, List<String> args) {
        return func.toUpperCase(Locale.US) + args.stream().collect(Collectors.joining(", ", "(", ")"));
    }

    public Predicate like(CqnValue value, CqnValue pattern, String esc, boolean caseInsensitive) {
        if (caseInsensitive) {
            value = CQL.func((String)TOLOWER, (CqnValue[])new CqnValue[]{value});
            pattern = CQL.func((String)TOLOWER, (CqnValue[])new CqnValue[]{pattern});
        }
        return ExpressionBuilder.create((CqnToken[])new CqnToken[]{value, LIKE, pattern, ESCAPE, CQL.constant((Object)esc)}).predicate();
    }

    protected Predicate ilike(CqnValue value, CqnValue pattern, String esc, boolean caseInsensitive) {
        CqnPlain operator = caseInsensitive ? ILIKE : LIKE;
        return ExpressionBuilder.create((CqnToken[])new CqnToken[]{value, operator, pattern, ESCAPE, CQL.constant((Object)esc)}).predicate();
    }
}

