/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.hierarchies;

import com.sap.cds.impl.builder.model.InSubquery;
import com.sap.cds.ql.BooleanValue;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.Source;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.transformation.CqnAncestorsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnDescendantsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnFilterTransformation;
import com.sap.cds.ql.cqn.transformation.CqnHierarchySubsetTransformation;
import com.sap.cds.ql.cqn.transformation.CqnSearchTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTopLevelsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.ql.hana.HANA;
import com.sap.cds.ql.hana.Hierarchy;
import com.sap.cds.ql.hana.HierarchySubset;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.util.CaseBuilder;
import com.sap.cds.util.transformations.TransformationToSelect;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Function;

public class HanaHierarchyResolver
extends TransformationToSelect {
    private static final Literal<Number> ZERO = CQL.constant((Object)0);
    private static final Literal<Number> ONE = CQL.constant((Object)1);
    private static final String PARENT_ID = "parent_id";
    private static final String NODE_ID = "node_id";
    private static final String HIERARCHY_TREE_SIZE = "hierarchy_tree_size";
    private static final String HIERARCHY_LEVEL = "hierarchy_level";
    private static final String HIERARCHY_RANK = "hierarchy_rank";
    private static final String DISTANCE_FROM_ROOT = "DistanceFromRoot";
    private static final String LIMITED_DESCENDANT_COUNT = "LimitedDescendantCount";
    private static final String DESCENDANT_COUNT = "DescendantCount";
    private static final String DRILL_STATE = "DrillState";
    private boolean isHierarchicalSelect;
    private static final Literal<String> COLLAPSED = CQL.constant((Object)"collapsed");
    private static final Literal<String> EXPANDED = CQL.constant((Object)"expanded");
    private static final Literal<String> LEAF = CQL.constant((Object)"leaf");
    private Hierarchy sourceHierarchy;
    private List<CqnTransformation> transformations;
    private List<CqnSelectListItem> originalItems;

    public HanaHierarchyResolver(Select<?> select) {
        super(select);
    }

    protected void before(CqnSelect original) {
        this.originalItems = original.items();
        this.isHierarchicalSelect = original.transformations().stream().anyMatch(HanaHierarchyResolver::isHierarchical);
        if (this.isHierarchicalSelect) {
            this.transformations = original.transformations();
            Select hierarchySource = this.select;
            this.sourceHierarchy = HANA.hierarchy((Source)hierarchySource);
            this.select = SelectBuilder.from((CqnSource)this.sourceHierarchy).columns(new Selectable[]{CQL.star(), HanaHierarchyResolver.descendantCount(), HanaHierarchyResolver.distanceFromRoot()}).excluding(new String[]{HIERARCHY_TREE_SIZE, HIERARCHY_LEVEL, HIERARCHY_RANK});
        }
    }

    protected void after() {
        if (this.isHierarchicalSelect) {
            ListIterator<CqnTransformation> iter = this.transformations.listIterator(this.transformations.size());
            while (iter.hasPrevious()) {
                CqnTransformation t = iter.previous();
                if (t.kind() != CqnTransformation.Kind.DESCENDANTS) continue;
                HanaHierarchyResolver.addDescendantsDrillState((SelectBuilder)this.select, t);
                break;
            }
        }
    }

    protected void copySelectList(List<CqnSelectListItem> slis) {
        if (!this.isHierarchicalSelect) {
            super.copySelectList(slis);
        }
    }

    private static boolean isHierarchical(CqnTransformation t) {
        return switch (t.kind()) {
            case CqnTransformation.Kind.TOPLEVELS, CqnTransformation.Kind.ANCESTORS, CqnTransformation.Kind.DESCENDANTS -> true;
            default -> false;
        };
    }

    protected void applyTopLevels(CqnTopLevelsTransformation topLevels) {
        this.wrapUnless((CqnTransformation)topLevels, new CqnTransformation.Kind[]{CqnTransformation.Kind.IDENTITY, CqnTransformation.Kind.ORDERBY});
        this.previous = CqnTransformation.IDENTITY;
        BooleanValue filter = CQL.TRUE;
        long levels = topLevels.levels();
        if (levels > 0L) {
            filter = this.select.from().isSelect() ? filter.and((CqnPredicate)CQL.get((String)DISTANCE_FROM_ROOT).lt((Object)levels), new CqnPredicate[0]) : filter.and((CqnPredicate)CQL.get((String)HIERARCHY_LEVEL).le((Object)levels), new CqnPredicate[0]);
        }
        Predicate f = filter.or((CqnPredicate)HanaHierarchyResolver.expandFilter(topLevels.expandLevels().keySet()), new CqnPredicate[0]);
        this.applyFilter(() -> HanaHierarchyResolver.lambda$applyTopLevels$0((CqnPredicate)f));
        List<Object> siblingOrderBy = new ArrayList(this.select.orderBy());
        if (siblingOrderBy.isEmpty()) {
            siblingOrderBy = List.of(CQL.get((String)NODE_ID).asc());
        }
        this.select.orderBy(List.of());
        Hierarchy hierarchy = HANA.hierarchy((Source)this.select).orderBy(siblingOrderBy);
        this.select = SelectBuilder.from((CqnSource)hierarchy).columns(HanaHierarchyResolver.computeVirtual(this.originalItems));
    }

    private static List<CqnSelectListItem> computeVirtual(List<CqnSelectListItem> slis) {
        if (slis.isEmpty()) {
            ArrayList<CqnSelectListItem> selectList = new ArrayList<CqnSelectListItem>(3);
            selectList.add((CqnSelectListItem)CQL.star());
            selectList.add((CqnSelectListItem)HanaHierarchyResolver.limitedDescendantCount());
            selectList.add(HanaHierarchyResolver.drillState());
            return selectList;
        }
        return slis.stream().map(HanaHierarchyResolver::computeVirtual).toList();
    }

    private static CqnSelectListItem computeVirtual(CqnSelectListItem sli) {
        if (sli.isRef()) {
            String path = sli.asRef().path();
            if (LIMITED_DESCENDANT_COUNT.equals(path)) {
                return HanaHierarchyResolver.limitedDescendantCount();
            }
            if (DRILL_STATE.equals(path)) {
                return HanaHierarchyResolver.drillState();
            }
        }
        return sli;
    }

    private static CqnSelectListValue distanceFromRoot() {
        return CQL.get((String)HIERARCHY_LEVEL).minus(ONE).as(DISTANCE_FROM_ROOT);
    }

    private static CqnSelectListValue descendantCount() {
        return CQL.get((String)HIERARCHY_TREE_SIZE).minus(ONE).as(DESCENDANT_COUNT);
    }

    private static CqnSelectListValue limitedDescendantCount() {
        return CQL.get((String)HIERARCHY_TREE_SIZE).minus(ONE).as(LIMITED_DESCENDANT_COUNT);
    }

    private static CqnSelectListItem drillState() {
        Predicate hasDescendants = CQL.get((String)DESCENDANT_COUNT).gt(ZERO);
        ElementRef treeSize = CQL.get((String)HIERARCHY_TREE_SIZE);
        return CaseBuilder.cases().when((CqnPredicate)hasDescendants.and((CqnPredicate)treeSize.eq(ONE), new CqnPredicate[0])).then(COLLAPSED).when((CqnPredicate)hasDescendants.and((CqnPredicate)treeSize.gt(ONE), new CqnPredicate[0])).then(EXPANDED).orElse(LEAF).end().type(CdsBaseType.STRING).as(DRILL_STATE);
    }

    private static void addDescendantsDrillState(SelectBuilder<?> select, CqnTransformation t) {
        CqnDescendantsTransformation d = (CqnDescendantsTransformation)t;
        int v = d.distanceFromStart();
        if (v > 1 || d.keepStart()) {
            return;
        }
        CqnSelectListValue drillState = CaseBuilder.cases().when((CqnPredicate)CQL.get((String)HIERARCHY_TREE_SIZE).gt(ONE)).then(COLLAPSED).orElse(LEAF).end().type(CdsBaseType.STRING).as(DRILL_STATE);
        select.addItem((Selectable)drillState);
    }

    private static Predicate expandFilter(Set<Object> ids) {
        List expandIds = ids.stream().toList();
        return CQL.get((String)PARENT_ID).in(expandIds).or((CqnPredicate)CQL.get((String)NODE_ID).in(expandIds), new CqnPredicate[0]);
    }

    protected void applyAncestors(CqnAncestorsTransformation transformation) {
        this.subSet((CqnHierarchySubsetTransformation)transformation, HANA::ancestors);
    }

    protected void applyDescendants(CqnDescendantsTransformation transformation) {
        this.subSet((CqnHierarchySubsetTransformation)transformation, HANA::descendants);
    }

    private void subSet(CqnHierarchySubsetTransformation subsetTrafo, Function<Hierarchy, HierarchySubset> factory) {
        HierarchySubset subset = factory.apply(this.sourceHierarchy);
        subset.distance(subsetTrafo.distanceFromStart(), subsetTrafo.keepStart());
        BooleanValue startWhere = CQL.TRUE;
        for (CqnTransformation nested : subsetTrafo.transformations()) {
            if (nested instanceof CqnFilterTransformation) {
                CqnFilterTransformation filter = (CqnFilterTransformation)nested;
                startWhere = CQL.and((CqnPredicate)startWhere, (CqnPredicate)filter.filter());
                continue;
            }
            if (!(nested instanceof CqnSearchTransformation)) continue;
            CqnSearchTransformation search = (CqnSearchTransformation)nested;
            startWhere = CQL.and((CqnPredicate)startWhere, (CqnPredicate)search.search());
        }
        subset.startWhere((CqnPredicate)startWhere);
        SelectBuilder subquery = SelectBuilder.from((CqnSource)subset).columns(new String[]{NODE_ID}).distinct();
        this.applyFilter(() -> HanaHierarchyResolver.lambda$subSet$1((CqnSelect)subquery));
    }

    private static /* synthetic */ CqnPredicate lambda$subSet$1(CqnSelect subquery) {
        return InSubquery.in((CqnValue)CQL.get((String)NODE_ID), (CqnSelect)subquery);
    }

    private static /* synthetic */ CqnPredicate lambda$applyTopLevels$0(CqnPredicate f) {
        return f;
    }
}

