package com.sap.cds.jdbc.h2;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.Map;
import java.util.stream.Collectors;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.util.CdsTypeUtils;

public class H2SessionVariableSetter implements SessionVariableSetter {

	@Override
	public void set(Connection conn, Map<String, Object> contextVariables) throws SQLException {
		String sql = contextVariables.entrySet().stream().map(e -> sql(e.getKey(), e.getValue()))
				.collect(Collectors.joining("; "));

		try (Statement stmt = conn.createStatement()) {
			stmt.executeUpdate(sql);
		}
	}

	private static String sql(String key, Object value) {
		StringBuilder builder = new StringBuilder("SET @");
		String name = switch (key) {
			case VALID_FROM -> "valid_from";
			case VALID_TO -> "valid_to";
			case APPLICATIONUSER -> "applicationuser";
			case LOCALE -> "locale";
			case TENANT -> "tenant";
			default -> key;
		};
		builder.append(name);
		if (value == null) {
			builder.append(" = NULL");
		} else {
			builder.append(" = ");
			switch (key) {
				case VALID_FROM, VALID_TO:
					builder.append("TIMESTAMP WITH TIME ZONE");
					builder.append(SQLHelper.literal(value.toString()));
					break;
				default:
					builder.append(SQLHelper.literal(value.toString()));
			}
		}

		return builder.toString();
	}

}
