/************************************************************************
 * © 2020-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.postgresql;

import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.jdbc.spi.PredicateMapper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate.Operator;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;

public class PostgreSqlPredicateMapper implements PredicateMapper {

	private static final CqnPlain IS_NOT_DISTINCT_FROM = CqnPlainImpl.plain("is not distinct from");
	private static final CqnPlain IS_DISTINCT_FROM = CqnPlainImpl.plain("is distinct from");

	@Override
	public CqnPredicate apply(CqnPredicate pred) {
		Modifier m = new Modifier() {

			@Override
			public CqnPredicate comparison(Value<?> lhs, Operator op, Value<?> rhs) {
				if (!rhs.isNullValue()) {
					if (op == Operator.IS) {
						return ExpressionBuilder.create(lhs, IS_NOT_DISTINCT_FROM, rhs).predicate();
					}
					if (op == Operator.IS_NOT) {
						return ExpressionBuilder.create(lhs, IS_DISTINCT_FROM, rhs).predicate();
					}
				}
				return CQL.comparison(lhs, op, rhs);
			}

		};

		return ExpressionVisitor.copy(pred, m);
	}

}
