/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsType;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SQLHelper {
    private static final char DQ = '\"';
    private static final char SQ = '\'';

    private SQLHelper() {
    }

    public static String commaSeparated(Stream<String> stream) {
        return stream.collect(Collectors.joining(", ", "(", ")"));
    }

    public static PreparedCqnStmt.DataParam param(String path, CdsElement element) {
        CdsType type = element.getType();
        CdsBaseType baseType = type.isSimple() ? ((CdsSimpleType)type.as(CdsSimpleType.class)).getType() : null;
        return new PreparedCqnStmt.DataParam(path, baseType);
    }

    public static String delimited(String undelimited) {
        return "\"" + SQLHelper.prefix(undelimited, '\"', '\"') + "\"";
    }

    public static String literal(String text) {
        return text == null ? "NULL" : "'" + SQLHelper.prefix(text, '\'', '\'') + "'";
    }

    public static String escapeLikePattern(char escapeChar, String text) {
        text = SQLHelper.prefix(text, escapeChar, '_');
        text = SQLHelper.prefix(text, escapeChar, '%');
        return text;
    }

    private static String prefix(String text, char escapeChar, char toBeEscaped) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != toBeEscaped) continue;
            return SQLHelper.prefixFrom(text, i, escapeChar, text.length(), toBeEscaped);
        }
        return text;
    }

    private static String prefixFrom(String text, int from, char escapeChar, int length, char toBeEscaped) {
        char[] buffer = new char[length * 2];
        text.getChars(0, from, buffer, 0);
        int j = from;
        for (int i = from; i < length; ++i) {
            char c = text.charAt(i);
            if (c == toBeEscaped) {
                buffer[j++] = escapeChar;
            }
            buffer[j++] = c;
        }
        return String.copyValueOf(buffer, 0, j);
    }
}

