/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsDataStoreException;
import com.sap.cds.CdsException;
import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.impl.LazyResultImpl;
import com.sap.cds.impl.LazyRowImpl;
import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.impl.builder.model.ExpressionImpl;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.impl.qat.QatBuilder;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefBuilder;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.impl.ExpandProcessor;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssociationLoader {
    private static final Logger logger = LoggerFactory.getLogger(AssociationLoader.class);
    private static final String PK_PREFIX = "@@";
    private final CdsDataStore dataStore;
    private final CdsStructuredType root;
    private final List<String> keyNames;
    private final Map<String, String> pk2Element = new HashMap<String, String>();
    private final SqlMapping sqlMapping;

    public AssociationLoader(CdsDataStore dataStore, DbContext dbCtx, CdsStructuredType root) {
        this.dataStore = dataStore;
        this.root = root;
        this.keyNames = new ArrayList<String>(CdsModelUtils.concreteKeyNames((CdsStructuredType)root));
        this.sqlMapping = dbCtx.getSqlMapping(root);
    }

    public void expand(ExpandProcessor expandProcessor, List<Map<String, Object>> rows) {
        ExpandBuilder<?> expand = expandProcessor.getExpand();
        if (this.dataStore == null || rows.isEmpty()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Expand {} using parent-keys", (Object)expand.ref());
        }
        boolean lazy = expand.lazy();
        boolean addCount = expand.hasInlineCount() && !expand.hasLimit();
        StructuredTypeRef ref = expand.ref();
        Map<String, String> mappingAliases = expandProcessor.getMappingAliases();
        if (lazy) {
            this.expandLazy((CqnExpand)expand, (CqnStructuredTypeRef)ref, mappingAliases, rows, expandProcessor.getQueryHints());
        } else {
            this.expandEager((CqnExpand)expand, (CqnStructuredTypeRef)ref, mappingAliases, addCount, rows, expandProcessor.isLoadSingle(), expandProcessor.getQueryHints());
        }
    }

    private void expandEager(CqnExpand expand, CqnStructuredTypeRef ref, Map<String, String> mappingAliases, boolean addCount, List<Map<String, Object>> rows, boolean enforceLoadSingle, Map<String, Object> queryHints) {
        boolean singleValued = this.singleValued((CdsEntity)this.root, expand.ref());
        CqnSelect query = this.queryByParams(ref, expand.items(), expand.orderBy(), expand.top(), expand.skip(), mappingAliases, queryHints);
        String path = expand.alias().orElse(ref.lastSegment());
        if (rows.size() == 1 || enforceLoadSingle) {
            rows.forEach(row -> this.loadSingle((Map<String, Object>)row, query, path, singleValued, addCount));
        } else if (singleValued) {
            this.loadBulk(rows, query, mappingAliases, (row, list) -> this.putOne(row, path, list));
        } else if (!expand.hasLimit()) {
            this.loadBulk(rows, query, mappingAliases, (row, list) -> this.putMany(row, path, list, addCount));
        } else {
            rows.forEach(row -> this.loadSingle((Map<String, Object>)row, query, path, singleValued, addCount));
        }
    }

    private void loadSingle(Map<String, Object> row, CqnSelect query, String path, boolean singleValued, boolean addCount) {
        Result result = this.dataStore.execute(query, row);
        if (singleValued) {
            Row map;
            DataUtils.putPath(row, (String)path, (Object)map, ((map = (Row)result.first().orElse(null)) != null ? 1 : 0) != 0);
        } else {
            List list = result.list();
            this.putMany(row, path, list, addCount);
        }
    }

    private void loadBulk(List<Map<String, Object>> rows, CqnSelect query, Map<String, String> mappingAliases, Mapper mapper) {
        Map<List<Object>, List<Row>> keyToData = this.execAndGroupByParentKeys(rows, query);
        for (Map<String, Object> row : rows) {
            List<Object> key = this.keyValuesInResultData(row, mappingAliases);
            List<Row> list = keyToData.getOrDefault(key, Collections.emptyList());
            list.forEach(r -> AssociationLoader.clean((Map<String, Object>)r));
            mapper.map(row, list);
        }
    }

    private void putOne(Map<String, Object> row, String path, List<Row> list) {
        Map<String, Object> map = switch (list.size()) {
            case 0 -> null;
            case 1 -> AssociationLoader.clean((Map)list.get(0));
            default -> throw new CdsDataStoreException("Failed to map result of expand " + path);
        };
        DataUtils.putPath(row, (String)path, map, (map != null ? 1 : 0) != 0);
    }

    private void putMany(Map<String, Object> row, String path, List<? extends Map<String, Object>> list, boolean addCount) {
        DataUtils.putPath(row, (String)path, list, (!list.isEmpty() ? 1 : 0) != 0);
        if (addCount) {
            DataUtils.putPath(row, (String)DataUtils.countName((String)path), (Object)list.size());
        }
    }

    private Map<List<Object>, List<Row>> execAndGroupByParentKeys(List<Map<String, Object>> rows, CqnSelect query) {
        this.keyNames.forEach(k -> {
            String el = this.pk2Element.get(k);
            String columnName = this.sqlMapping.columnName(el);
            CqnSelectListValue slv = CQL.plain((String)(QatBuilder.ROOT_ALIAS + "." + columnName)).as(AssociationLoader.pkAlias(k));
            ((SelectBuilder)query).addItem((Selectable)slv);
        });
        int maxBatchSize = query.orderBy().isEmpty() ? 100 : rows.size();
        Result result = this.dataStore.execute(query, rows, maxBatchSize);
        return result.stream().collect(Collectors.groupingBy(this::keyValuesInResultRow));
    }

    private static String pkAlias(String k) {
        return PK_PREFIX + k;
    }

    private List<Object> keyValuesInResultRow(Map<String, Object> row) {
        return this.keyNames.stream().map(k -> row.get(AssociationLoader.pkAlias(k))).toList();
    }

    private List<Object> keyValuesInResultData(Map<String, Object> row, Map<String, String> aliases) {
        return this.keyNames.stream().map(k -> row.get(aliases.getOrDefault(k, (String)k))).toList();
    }

    private static Map<String, Object> clean(Map<String, Object> r) {
        r.keySet().removeIf(k -> k.startsWith(PK_PREFIX));
        return r;
    }

    private void expandLazy(CqnExpand expand, CqnStructuredTypeRef ref, Map<String, String> mappingAliases, List<Map<String, Object>> rows, Map<String, Object> queryHints) {
        for (Map<String, Object> row : rows) {
            this.injector(row, mappingAliases, queryHints).injectInto(row, ref, expand.items(), expand.orderBy(), expand.top(), expand.skip(), expand.alias());
        }
    }

    private LazyAssociationLoaderInjector injector(Map<String, Object> row, Map<String, String> mappingAliases, Map<String, Object> queryHints) {
        HashMap<String, Object> pkValues = new HashMap<String, Object>();
        this.root.keyElements().forEach(k -> {
            String keyName = k.getName();
            String displayName = mappingAliases.getOrDefault(keyName, keyName);
            pkValues.put(keyName, row.get(displayName));
        });
        return new LazyAssociationLoaderInjector((CdsEntity)this.root, pkValues, queryHints);
    }

    private boolean singleValued(CdsEntity entity, CqnStructuredTypeRef path) {
        CdsEntity e = entity;
        CdsElement association = null;
        for (CqnReference.Segment seg : path.segments()) {
            String assocName = seg.id();
            association = e.getAssociation(assocName);
            e = (CdsEntity)e.getTargetOf(assocName);
        }
        if (association == null) {
            throw new CdsException("Missing association for Entity " + e.getName() + ", under Path " + path.toJson() + ".");
        }
        return CdsModelUtils.isSingleValued((CdsType)association.getType());
    }

    private CqnSelect queryByParams(CqnStructuredTypeRef path, List<CqnSelectListItem> items, List<CqnSortSpecification> orderBy, long top, long skip, Map<String, String> aliases, Map<String, Object> queryHints) {
        CqnStructuredTypeRef target = this.fkMapping(path).map(m -> this.filteredTarget((Map<String, String>)m, path, aliases)).orElseGet(() -> this.pathFromRoot(path, aliases));
        return (CqnSelect)Select.from((CqnStructuredTypeRef)target).columns(items).orderBy(orderBy).limit(top, skip).hints(queryHints);
    }

    private Optional<Map<String, String>> fkMapping(CqnStructuredTypeRef path) {
        Map fkMapping;
        if (path.size() != 1) {
            return Optional.empty();
        }
        CdsElement assoc = CdsModelUtils.element((CdsStructuredType)this.root, (List)path.segments());
        if (!CdsModelUtils.isReverseAssociation((CdsElement)assoc)) {
            return Optional.empty();
        }
        OnConditionAnalyzer analyzer = new OnConditionAnalyzer(assoc, true);
        try {
            fkMapping = analyzer.getFkMapping();
        }
        catch (UnsupportedOperationException ex) {
            return Optional.empty();
        }
        HashMap fk2Pk = new HashMap(fkMapping.size());
        HashSet referencedPks = new HashSet();
        fkMapping.forEach((fk, pkVal) -> {
            if (pkVal.isRef() && pkVal.asRef().size() == 1) {
                String pk = pkVal.asRef().firstSegment();
                fk2Pk.put(fk, pk);
                referencedPks.add(pk);
            }
        });
        if (referencedPks.size() != this.keyNames.size()) {
            return Optional.empty();
        }
        if (this.keyNames.stream().anyMatch(k -> !referencedPks.contains(k))) {
            return Optional.empty();
        }
        return Optional.of(fk2Pk);
    }

    private CqnStructuredTypeRef pathFromRoot(CqnStructuredTypeRef path, Map<String, String> aliases) {
        ArrayList<RefBuilder.RefSegment> segments = new ArrayList<RefBuilder.RefSegment>(path.segments().size() + 1);
        this.pk2Element.clear();
        this.keyNames.forEach(k -> this.pk2Element.put((String)k, (String)k));
        segments.add(RefSegmentImpl.refSegment((String)this.root.getQualifiedName(), (CqnPredicate)this.pkFilter(aliases)));
        segments.addAll(path.segments());
        return StructuredTypeRefImpl.typeRef(segments);
    }

    private CqnStructuredTypeRef filteredTarget(Map<String, String> fkMapping, CqnStructuredTypeRef ref, Map<String, String> aliases) {
        HashMap<String, String> fkAliases = new HashMap<String, String>();
        this.pk2Element.clear();
        fkMapping.forEach((fk, pk) -> {
            String paramName = (String)aliases.get(pk);
            fkAliases.put((String)fk, paramName);
            this.pk2Element.put((String)pk, (String)fk);
        });
        CdsStructuredType targetEntity = CdsModelUtils.target((CdsStructuredType)this.root, (List)ref.segments());
        Predicate filter = CQL.and((CqnPredicate)this.pkFilter(fkAliases), (CqnPredicate)((CqnPredicate)ref.rootSegment().filter().orElse(CQL.TRUE)));
        return StructuredTypeRefImpl.typeRef((CqnReference.Segment)RefSegmentImpl.refSegment((String)targetEntity.getQualifiedName(), (CqnPredicate)filter));
    }

    private CqnPredicate pkFilter(Map<String, String> aliases) {
        return switch (this.keyNames.size()) {
            case 0 -> CQL.TRUE;
            case 1 -> this.pkFilterSingle(aliases);
            default -> this.pkFilterList(aliases);
        };
    }

    private CqnPredicate pkFilterSingle(Map<String, String> pkAliases) {
        String pk = this.keyNames.get(0);
        String el = this.pk2Element.get(pk);
        return CQL.comparison((CqnValue)CQL.get((String)el), (CqnComparisonPredicate.Operator)CqnComparisonPredicate.Operator.EQ, (CqnValue)CQL.param((String)pkAliases.getOrDefault(el, el)));
    }

    private CqnPredicate pkFilterList(Map<String, String> aliases) {
        int n = this.keyNames.size();
        ArrayList fkRefs = new ArrayList(n);
        ArrayList pkParams = new ArrayList(n);
        this.keyNames.forEach(pk -> {
            String el = this.pk2Element.get(pk);
            fkRefs.add(CQL.get((String)el));
            pkParams.add(CQL.param((String)aliases.getOrDefault(el, el)));
        });
        return CQL.comparison((CqnValue)CQL.list(fkRefs), (CqnComparisonPredicate.Operator)CqnComparisonPredicate.Operator.EQ, (CqnValue)CQL.list(pkParams));
    }

    private static interface Mapper {
        public void map(Map<String, Object> var1, List<Row> var2);
    }

    private class LazyAssociationLoaderInjector {
        private CdsEntity entity;
        private Map<String, Object> keyValues;
        private Map<String, Object> queryHints;

        LazyAssociationLoaderInjector(CdsEntity entity, Map<String, Object> keyValues, Map<String, Object> queryHints) {
            this.entity = entity;
            this.keyValues = keyValues;
            this.queryHints = queryHints;
        }

        private void injectInto(Map<String, Object> row, CqnStructuredTypeRef path, List<CqnSelectListItem> slis, List<CqnSortSpecification> orderBy, long top, long skip, Optional<String> alias) {
            CqnSelect query = this.queryByValues(path, slis, orderBy, top, skip, this.keyValues);
            LazyResultImpl loader = AssociationLoader.this.singleValued(this.entity, path) ? LazyRowImpl.lazyRow((CdsDataStore)AssociationLoader.this.dataStore, (CqnSelect)query) : new LazyResultImpl(AssociationLoader.this.dataStore, query);
            String displayName = alias.orElse(path.lastSegment());
            DataUtils.putPath(row, (String)displayName, (Object)((Object)loader));
        }

        private CqnSelect queryByValues(CqnStructuredTypeRef path, List<CqnSelectListItem> slis, List<CqnSortSpecification> orderBy, long top, long skip, Map<String, Object> keyValues) {
            if (!keyValues.keySet().containsAll(CdsModelUtils.concreteKeyNames((CdsStructuredType)AssociationLoader.this.root))) {
                throw new CdsException("Missing key values for entity " + AssociationLoader.this.root.getQualifiedName() + ". Please add all keys to the projection.");
            }
            ArrayList<RefBuilder.RefSegment> segments = new ArrayList<RefBuilder.RefSegment>();
            segments.add(RefSegmentImpl.refSegment((String)AssociationLoader.this.root.getQualifiedName(), (CqnPredicate)ExpressionImpl.matching(keyValues)));
            segments.addAll(path.segments());
            return (CqnSelect)SelectBuilder.from((CqnStructuredTypeRef)StructuredTypeRefImpl.typeRef(segments, null)).columns(slis).orderBy(orderBy).limit(top, skip).hints(this.queryHints);
        }
    }
}

