/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.h2;

import com.sap.cds.CdsDataStoreException;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.impl.sql.SqlMappingImpl;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class H2SqlMapping
extends SqlMappingImpl {
    private static final Pattern PATTERN = Pattern.compile("([^\\.\\|\\[\\]]+)|(\\[(\\d+)\\])");

    public H2SqlMapping(CdsStructuredType rowType, Function<String, String> casing) {
        super(rowType, casing);
    }

    @Override
    public String jsonQuery(String contextItem, String jsonPath) {
        if (!jsonPath.startsWith("$.")) {
            throw new CdsDataStoreException("Unsupported JSON path: '" + jsonPath + "' must start with '$.'");
        }
        jsonPath = jsonPath.substring(2);
        Matcher matcher = PATTERN.matcher(jsonPath);
        StringBuilder sb = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            sb.append(jsonPath, lastEnd, matcher.start());
            if (matcher.group(1) != null) {
                sb.append(SQLHelper.delimited(matcher.group(1)));
            } else if (matcher.group(2) != null) {
                sb.append(Integer.parseInt(matcher.group(2)) + 1);
            }
            lastEnd = matcher.end();
        }
        sb.append(jsonPath, lastEnd, jsonPath.length());
        return "(" + contextItem + ")." + sb.toString();
    }

    @Override
    public String jsonValue(String contextItem, String jsonPath, CdsBaseType type) {
        String jsonValue = this.jsonQuery(contextItem, jsonPath);
        if (type == null) {
            return jsonValue;
        }
        return switch (type) {
            case CdsBaseType.STRING -> H2SqlMapping.cast(jsonValue, "VARCHAR");
            case CdsBaseType.BOOLEAN -> H2SqlMapping.cast(jsonValue, "BOOLEAN");
            case CdsBaseType.DATE -> H2SqlMapping.cast(jsonValue, "DATE");
            case CdsBaseType.TIME -> H2SqlMapping.cast(jsonValue, "TIME WITHOUT TIME ZONE");
            case CdsBaseType.DATETIME -> H2SqlMapping.cast(jsonValue, "TIMESTAMP(0) WITH TIME ZONE");
            case CdsBaseType.TIMESTAMP -> H2SqlMapping.cast(jsonValue, "TIMESTAMP(7) WITH TIME ZONE");
            default -> jsonValue;
        };
    }

    private static String cast(String jsonValue, String type) {
        return "CAST(TRIM(BOTH '\"' FROM " + jsonValue + ") AS " + type + ")";
    }
}

