/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.hierarchies;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SelectStatementBuilder;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.TableFunctionMapper;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.hana.CqnHierarchy;
import com.sap.cds.ql.hana.CqnHierarchyGenerator;
import com.sap.cds.ql.hana.CqnHierarchySubset;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class HierarchyFunctionMapper<T extends CqnHierarchy>
implements TableFunctionMapper {
    private static final String SOURCE = "SOURCE";
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    protected final Context context;
    protected final T hierarchy;
    protected final List<PreparedCqnStmt.Parameter> params;
    protected final TokenToSQLTransformer toSQL;
    protected final CdsModel model;

    private HierarchyFunctionMapper(Context context, List<PreparedCqnStmt.Parameter> params, T hierarchy) {
        this.context = context;
        this.model = context.getCdsModel();
        this.hierarchy = hierarchy;
        this.params = params;
        this.toSQL = HierarchyFunctionMapper.toSQL(context, params, hierarchy.source());
    }

    private static TokenToSQLTransformer toSQL(Context context, List<PreparedCqnStmt.Parameter> params, CqnSource source) {
        if (source.isRef()) {
            CqnStructuredTypeRef ref = source.asRef();
            CdsEntity entity = CdsModelUtils.entity((CdsModel)context.getCdsModel(), (CqnStructuredTypeRef)ref);
            SqlMapping sqlMapping = context.getDbContext().getSqlMapping((CdsStructuredType)entity);
            String tableName = sqlMapping.tableName();
            return TokenToSQLTransformer.notCollating(context, (clause, r) -> sqlMapping.columnName(r), entity, tableName, params);
        }
        if (source.isSelect()) {
            CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)context.getCdsModel(), (CqnSelect)source.asSelect());
            SqlMapping sqlMapping = context.getDbContext().getSqlMapping(rowType);
            return TokenToSQLTransformer.notCollating(context, (clause, r) -> sqlMapping.columnName(r), source.asSelect(), rowType, params);
        }
        if (source.isTableFunction()) {
            return HierarchyFunctionMapper.toSQL(context, params, source.asTableFunction().source());
        }
        throw new IllegalStateException();
    }

    public String toSQL() {
        StringBuilder sql = new StringBuilder(this.hierarchy.name());
        sql.append(LPAREN);
        sql.append(SOURCE);
        sql.append(" ");
        CqnSource source = this.hierarchy.source();
        if (source.isRef()) {
            CqnStructuredTypeRef ref = source.asRef();
            TableNameResolver resolver = this.context.getTableNameResolver();
            CdsEntity entity = CdsModelUtils.entity((CdsModel)this.context.getCdsModel(), (CqnStructuredTypeRef)ref);
            sql.append(resolver.tableName(entity));
        } else if (source.isSelect()) {
            sql.append(LPAREN);
            CqnSelect subquery = source.asSelect();
            SQLStatementBuilder.SQLStatement stmt = new SelectStatementBuilder(this.context, this.params, subquery, new ArrayDeque<QatSelectableNode>(), true, true).build();
            sql.append(stmt.sql());
            sql.append(RPAREN);
        } else if (source instanceof CqnHierarchy) {
            CqnHierarchy inner = (CqnHierarchy)source;
            String innerSQL = HierarchyFunctionMapper.create(this.context, this.params, inner).toSQL();
            sql.append(innerSQL);
        } else {
            throw new IllegalStateException();
        }
        this.appendClauses(sql);
        sql.append(RPAREN);
        return new SQLStatementBuilder.SQLStatement(sql.toString(), List.of()).sql();
    }

    protected CdsStructuredType rowType() {
        return CqnStatementUtils.rowType((CdsModel)this.model, this.hierarchy);
    }

    abstract void appendClauses(StringBuilder var1);

    public static <T extends CqnHierarchy> HierarchyFunctionMapper<T> create(Context context, List<PreparedCqnStmt.Parameter> params, T hierarchy) {
        if (hierarchy.isGenerator()) {
            return new Generator(context, params, hierarchy.asGenerator());
        }
        if (hierarchy.isHierarchySubset()) {
            return new HierarchySubset(context, params, hierarchy.asHierarchySubset());
        }
        throw new IllegalStateException();
    }

    private static class Generator
    extends HierarchyFunctionMapper<CqnHierarchyGenerator> {
        private static final String SIBL_ORDER_BY = "SIBLING ORDER BY";
        private static final String DEPTH = "DEPTH";

        public Generator(Context context, List<PreparedCqnStmt.Parameter> params, CqnHierarchyGenerator hierarchy) {
            super(context, params, hierarchy);
        }

        @Override
        void appendClauses(StringBuilder sql) {
            List siblingOrderBy = ((CqnHierarchyGenerator)this.hierarchy).orderBy();
            if (!siblingOrderBy.isEmpty()) {
                this.appendSiblingOrderBy(sql, siblingOrderBy);
            }
            if (((CqnHierarchyGenerator)this.hierarchy).depth() != null) {
                sql.append(" ").append(DEPTH).append(" ").append(((CqnHierarchyGenerator)this.hierarchy).depth());
            }
            ((CqnHierarchyGenerator)this.hierarchy).startWhere().map(w -> this.toSQL.toSQL(this.rowType(), (CqnPredicate)w)).ifPresent(s -> sql.append(" START WHERE ").append((String)s));
            sql.append(" NO CACHE");
        }

        private void appendSiblingOrderBy(StringBuilder sql, List<CqnSortSpecification> siblingOrderBy) {
            sql.append(" ").append(SIBL_ORDER_BY).append(" ");
            sql.append(siblingOrderBy.stream().map(o -> this.sort((CqnSortSpecification)o)).collect(Collectors.joining(", ")));
        }

        private String sort(CqnSortSpecification o) {
            StringBuilder sort = new StringBuilder(this.toSQL.apply((CqnToken)o.value()));
            sort.append(" " + SelectStatementBuilder.sortOrderToSql(o));
            return sort.toString();
        }
    }

    private static class HierarchySubset
    extends HierarchyFunctionMapper<CqnHierarchySubset> {
        public HierarchySubset(Context context, List<PreparedCqnStmt.Parameter> params, CqnHierarchySubset hierarchyNavigation) {
            super(context, params, hierarchyNavigation);
        }

        @Override
        void appendClauses(StringBuilder sql) {
            Optional startWhere = ((CqnHierarchySubset)this.hierarchy).startWhere();
            startWhere.map(w -> this.toSQL.toSQL(this.rowType(), (CqnPredicate)w)).ifPresent(s -> sql.append(" START WHERE ").append((String)s));
            sql.append(" DISTANCE").append(this.optional(" FROM ", ((CqnHierarchySubset)this.hierarchy).from())).append(this.optional(" TO ", ((CqnHierarchySubset)this.hierarchy).to()));
        }

        String optional(String s, int i) {
            if (Integer.MAX_VALUE == i || Integer.MIN_VALUE == i) {
                return "";
            }
            return s + i;
        }
    }
}

