/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.google.common.base.Joiner;
import com.sap.cds.CdsDataStore;
import com.sap.cds.Result;
import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.impl.builder.model.InPredicate;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import com.sap.cds.util.PathExpressionResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ExpandProcessor.class);
    private static final String EXPAND_USING_PARENT_KEYS = "parent-keys";
    private static final String EXPAND_USING_LOAD_SINGLE = "load-single";
    private static final String EXPAND_USING_JOIN = "join";
    private static final String EXPAND_USING_SUBQUERY = "subquery";
    private static final String FK_PREFIX = "@cds4j:fk:";
    private final CdsModel model;
    private final CqnStructuredTypeRef parentRef;
    private final CqnStructuredTypeRef expandRef;
    private final ExpandBuilder<?> expand;
    private final long queryTop;
    private final long querySkip;
    private final Map<String, Object> queryHints;
    private final Map<String, String> mappingAliases;
    private Map<String, String> elementMapping;
    private String expandMethod;

    private ExpandProcessor(CdsModel model, CqnStructuredTypeRef parentRef, Map<String, String> mappingAliases, CqnExpand expand, String expandMethod, long queryTop, long querySkip, Map<String, Object> queryHints) {
        this.model = model;
        this.expand = (ExpandBuilder)expand;
        this.expandRef = expand.ref();
        this.parentRef = parentRef;
        this.mappingAliases = mappingAliases;
        this.expandMethod = expandMethod;
        this.queryTop = queryTop;
        this.querySkip = querySkip;
        this.queryHints = queryHints;
    }

    public static ExpandProcessor create(CqnSelect query, CdsModel model, CqnStructuredTypeRef parentRef, CdsStructuredType parentType, Map<String, String> parentKeyAliases, CqnExpand expand, boolean pathExpand) {
        boolean toOne = CqnStatementUtils.isToOnePath((CdsStructuredType)parentType, (List)expand.ref().segments());
        CdsElement assoc = CdsModelUtils.element((CdsStructuredType)parentType, (List)expand.ref().segments());
        String expandMethod = ExpandProcessor.determinExpandMethod(parentRef, parentType, expand, assoc, toOne || !pathExpand);
        ExpandProcessor expandProcessor = new ExpandProcessor(model, parentRef, parentKeyAliases, expand, expandMethod, query.top(), query.skip(), query.hints());
        expandProcessor.computeElementMapping(assoc);
        return expandProcessor;
    }

    public Map<String, String> getMappingAliases() {
        return this.mappingAliases;
    }

    private static String determinExpandMethod(CqnStructuredTypeRef parentRef, CdsStructuredType type, CqnExpand expand, CdsElement assoc, boolean parentKeys) {
        if (parentKeys || expand.hasLimit() || ((ExpandBuilder)expand).lazy() || CqnStatementUtils.hasWhereExistsFilter((CqnReference)parentRef)) {
            return EXPAND_USING_PARENT_KEYS;
        }
        return (String)assoc.findAnnotation("@cds.java.expand.using").map(CdsAnnotation::getValue).orElseGet(() -> ExpandProcessor.pathExpandMethod(type, expand));
    }

    private static String pathExpandMethod(CdsStructuredType type, CqnExpand expand) {
        if (CqnStatementUtils.isOneToManyPath((CdsStructuredType)type, (List)expand.ref().segments())) {
            return EXPAND_USING_JOIN;
        }
        return EXPAND_USING_SUBQUERY;
    }

    private void computeElementMapping(CdsElement assoc) {
        try {
            this.elementMapping = ExpandProcessor.fkMapping(this.expandRef, assoc);
        }
        catch (Exception e) {
            this.expandMethod = EXPAND_USING_PARENT_KEYS;
            if (this.isPathExpand()) {
                logger.debug("Cannot optimize to-many " + assoc.getQualifiedName() + " expand due to on condition", (Throwable)e);
            }
            this.elementMapping = Collections.emptyMap();
        }
    }

    private static Map<String, String> fkMapping(CqnStructuredTypeRef ref, CdsElement toManyAssoc) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        new OnConditionAnalyzer(toManyAssoc, true).getFkMapping().forEach((k, val) -> {
            List segments = ref.stream().map(CqnReference.Segment::id).collect(Collectors.toList());
            if (val.isRef() && !CdsModelUtils.isContextElementRef((CqnElementRef)val.asRef())) {
                segments.set(segments.size() - 1, val.asRef().lastSegment());
                mapping.put((String)k, Joiner.on((char)'.').join(segments));
            }
        });
        return mapping;
    }

    public boolean isPathExpand() {
        return switch (this.expandMethod) {
            case EXPAND_USING_JOIN, EXPAND_USING_SUBQUERY -> true;
            default -> false;
        };
    }

    public boolean isLoadSingle() {
        return EXPAND_USING_LOAD_SINGLE.equals(this.expandMethod);
    }

    public ExpandBuilder<?> getExpand() {
        return this.expand;
    }

    public boolean hasCountAndLimit() {
        return this.expand.hasInlineCount() && this.expand.hasLimit();
    }

    public void addMappingKeys(CqnSelect select) {
        List<String> missing;
        if (!this.elementMapping.isEmpty() && !(missing = this.elementMapping.values().stream().filter(e -> !this.mappingAliases.containsKey(e)).toList()).isEmpty()) {
            boolean addMissing = !select.isDistinct() && CqnStatementUtils.isNoAggregation((CqnSelect)select);
            this.mappingAliases.putAll(CqnStatementUtils.selected(missing, (CqnSelect)select, (boolean)addMissing));
        }
    }

    public void expand(List<Map<String, Object>> rows, CdsDataStore dataStore, Map<String, Object> paramValues) {
        if (logger.isDebugEnabled()) {
            logger.debug("Expand to-many {} using {}", (Object)this.expand.ref(), (Object)this.expandMethod);
        }
        CqnSelect query = this.pathExpandQuery(rows);
        List expResult = dataStore.execute(query, paramValues).list();
        boolean addCount = this.expand.hasInlineCount() && !this.expand.hasLimit();
        Map<String, String> mapping = this.aliasedMapping();
        DataUtils.merge(rows, (List)expResult, (String)this.expand.displayName(), mapping, (String)"@cds4j:", (boolean)addCount);
    }

    public void inlineCount(List<Map<String, Object>> rows, CdsDataStore dataStore, Map<String, Object> paramValues) {
        CqnSelect countQuery = this.countQuery();
        Result counts = dataStore.execute(countQuery, paramValues);
        Map<String, String> mapping = this.aliasedMapping();
        DataUtils.addCounts(rows, (List)counts.list(), (String)this.expand.displayName(), mapping);
    }

    private Map<String, String> aliasedMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>(this.elementMapping.size());
        this.elementMapping.forEach((k, v) -> mapping.put(this.mappingAliases.getOrDefault(k, (String)k), this.mappingAliases.getOrDefault(v, (String)v)));
        return mapping;
    }

    private CqnSelect pathExpandQuery(List<Map<String, Object>> rows) {
        List<CqnSelectListItem> expItems = this.addFks(this.expand.items());
        StructuredType<?> target = ExpandProcessor.to((CqnReference)this.parentRef, (CqnReference)this.expand.ref());
        CqnSelect expQuery = (CqnSelect)Select.from(target).columns(expItems).orderBy(this.expand.orderBy()).hints(this.queryHints);
        if (this.querySkip > 0L || (long)rows.size() == this.queryTop) {
            ((Select)expQuery).where(this.fkFilter(rows));
        }
        if (EXPAND_USING_SUBQUERY.equals(this.expandMethod)) {
            expQuery = PathExpressionResolver.resolvePath((CdsModel)this.model, (CqnSelect)expQuery);
        }
        return expQuery;
    }

    private CqnPredicate fkFilter(List<Map<String, Object>> rows) {
        ArrayList<String> refList = new ArrayList<String>(this.elementMapping.keySet());
        if (refList.isEmpty()) {
            return CQL.TRUE;
        }
        List<String> parentKeys = refList.stream().map(fk -> this.mappingAliases.get(this.elementMapping.get(fk))).toList();
        return InPredicate.in(refList, rows, parentKeys);
    }

    private CqnSelect countQuery() {
        List<CqnSelectListItem> items = this.addFks(new ArrayList<CqnSelectListItem>());
        List groupingColumns = items.stream().map(v -> v.asValue().value()).collect(Collectors.toList());
        items.add((CqnSelectListItem)CQL.count().as("count"));
        return Select.from(ExpandProcessor.to((CqnReference)this.parentRef, (CqnReference)this.expand.ref())).columns(items).groupBy(groupingColumns);
    }

    private List<CqnSelectListItem> addFks(List<CqnSelectListItem> expItems) {
        ArrayList<CqnSelectListItem> items = new ArrayList<CqnSelectListItem>(expItems);
        this.elementMapping.keySet().forEach(fk -> {
            String alias = this.mappingAliases.computeIfAbsent((String)fk, v -> FK_PREFIX + v);
            items.add((CqnSelectListItem)CQL.get((String)fk).as(alias));
        });
        return items;
    }

    private static StructuredType<?> to(CqnReference ref1, CqnReference ref2) {
        ArrayList segments = new ArrayList(ref1.segments().size() + ref2.size());
        segments.addAll(ref1.segments());
        segments.addAll(ref2.segments());
        return CQL.to(segments);
    }

    public Map<String, Object> getQueryHints() {
        return this.queryHints;
    }
}

