/*******************************************************************
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.h2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.time.Instant;
import java.util.TimeZone;

import com.sap.cds.jdbc.generic.GenericBinder;

class H2Binder extends GenericBinder {

	H2Binder(TimeZone timeZone) {
		super(7, timeZone);
	}

	@Override
	protected Instant getInstant(ResultSet result, int i) throws SQLException {
		return result.getObject(i, Instant.class);
	}

	@Override
	protected void setInstant(PreparedStatement pstmt, int i, Instant instant) throws SQLException {
		pstmt.setObject(i, instant, Types.TIMESTAMP);
	}

}
