/*******************************************************************
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.hana;

import java.util.function.Function;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.impl.sql.SqlMappingImpl;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsStructuredType;

public class HanaSqlMapping extends SqlMappingImpl {

	public HanaSqlMapping(CdsStructuredType rowType, Function<String, String> casing) {
		super(rowType, casing);
	}

	@Override
	public String jsonQuery(String contextItem, String jsonPath) {
		return "JSON_QUERY(" + contextItem + ", " + SQLHelper.literal(jsonPath) + ")";
	}

	@Override
	public String jsonValue(String contextItem, String jsonPath, CdsBaseType type) {
		String jsonValue = "JSON_VALUE(" + contextItem + ", " + SQLHelper.literal(jsonPath) + returnType(type) + ")";
		if (type == CdsBaseType.TIMESTAMP || type == CdsBaseType.DATETIME) {
			jsonValue = "TO_TIMESTAMP(" + jsonValue + ")";
		}
		return jsonValue;
	}

	private static String returnType(CdsBaseType type) {
		if (type == null) {
			return "";
		}
		String t = switch (type) {
			case INTEGER, INT32, INT16 -> "INTEGER";
			case INTEGER64, INT64 -> "BIGINT";
			case DECIMAL -> "DECIMAL";
			case BOOLEAN -> "BOOLEAN";
			default -> null;
		};
		return t == null ? "" : " RETURNING " + t;
	}

}
