/*******************************************************************
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.hana.json;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.DbContextFactory;

public final class HanaDocStoreDbContextFactory implements DbContextFactory {
	@Override
	public boolean supports(String productName) {
		return "HanaJsonDocStore".equals(productName);
	}

	@Override
	public DbContext create(DataStoreConfiguration config, int majorVersion) {
		return new HanaDocStoreDbContext(config, majorVersion);
	}
};
