/*******************************************************************
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.postgresql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.TimeZone;

import com.sap.cds.CdsDataStoreException;
import com.sap.cds.jdbc.generic.GenericBinder;

class PostgreSqlBinder extends GenericBinder {

	PostgreSqlBinder(TimeZone timeZone) {
		super(PostgreSqlDbContext.TIMESTAMP_PRECISION, timeZone);
	}

	@Override
	protected void setJson(PreparedStatement pstmt, int i, Object value) throws SQLException {
		if (value == null) {
			pstmt.setNull(i, java.sql.Types.OTHER);
		} else if (value instanceof byte[] bytes) {
			pstmt.setObject(i, new String(bytes), java.sql.Types.OTHER);
		} else if (value instanceof String str) {
			pstmt.setObject(i, str, java.sql.Types.OTHER);
		} else {
			throw new CdsDataStoreException("Unsupported data format for PostgreSQL JSONB column: " + value.getClass());
		}
	}

}
