/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.draft;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.ql.impl.transformations.AbstractHierarchySubsetTrafo;
import com.sap.cds.ql.impl.transformations.FilterTrafo;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DraftUtils {
    private static final String DRAFT_ANNOTATION = "odata.draft.enabled";
    private static final String DRAFT_PREPARE_ANNOTATION = "Common.DraftNode.PreparationAction";
    private static final String DRAFT = "_drafts";

    public static boolean isDraftEnabled(CdsStructuredType targetType) {
        return (Boolean)targetType.getAnnotationValue(DRAFT_ANNOTATION, (Object)false) != false || targetType.findAnnotation(DRAFT_PREPARE_ANNOTATION).isPresent();
    }

    public static boolean isDraftView(CdsStructuredType type) {
        return type.getQualifiedName().endsWith(DRAFT);
    }

    public static boolean isActive(CdsStructuredType type) {
        return DraftUtils.isDraftEnabled(type) && !DraftUtils.isDraftView(type);
    }

    public static String activeEntity(Context context, TableNameResolver tableResolver, CdsEntity cdsEntity, Set<Element> draftElements) {
        String table = tableResolver.tableName(cdsEntity);
        if (draftElements.isEmpty()) {
            return table;
        }
        StringBuilder subquery = new StringBuilder("(SELECT ACTIVE.*");
        if (draftElements.contains((Object)Element.IS_ACTIVE)) {
            subquery.append(", true as IsActiveEntity");
        }
        if (draftElements.contains((Object)Element.HAS_ACTIVE)) {
            subquery.append(", false as HasActiveEntity");
        }
        boolean joinInactive = false;
        if (draftElements.contains((Object)Element.HAS_DRAFT)) {
            subquery.append(", COALESCE(DRAFT.HasActiveEntity, false) as HasDraftEntity");
            joinInactive = true;
        }
        if (draftElements.contains((Object)Element.DRAFT_UUID)) {
            subquery.append(", DRAFT.DraftAdministrativeData_DraftUUID as DraftAdministrativeData_DraftUUID");
            joinInactive = true;
        }
        subquery.append(" from ");
        subquery.append(table);
        subquery.append(" ACTIVE");
        if (joinInactive) {
            String draftEntityName = cdsEntity.getQualifiedName() + DRAFT;
            String draftTable = tableResolver.tableName(context.getCdsModel().getEntity(draftEntityName));
            subquery.append(" left outer join ");
            subquery.append(draftTable);
            subquery.append(" DRAFT on ");
            subquery.append(DraftUtils.on(context, cdsEntity));
        }
        subquery.append(")");
        return subquery.toString();
    }

    private static String on(Context context, CdsEntity cdsEntity) {
        return CdsModelUtils.concreteKeyNames((CdsStructuredType)cdsEntity).stream().sorted().map(e -> cdsEntity.getElement(e)).map(e -> context.getDbContext().getSqlMapping((CdsStructuredType)cdsEntity).columnName(e)).map(n -> "ACTIVE." + n + " = DRAFT." + n).collect(Collectors.joining(" AND "));
    }

    public static Optional<Element> draftElement(CdsElement element) {
        return DraftUtils.draftElement(element.getName());
    }

    public static Optional<Element> draftElement(String name) {
        for (Element e : Element.values()) {
            if (!e.name.equals(name)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    private static boolean isActive(CdsModel model, CqnSource source) {
        if (source.isRef()) {
            return DraftUtils.isActive((CdsStructuredType)CdsModelUtils.entity((CdsModel)model, (CqnStructuredTypeRef)source.asRef()));
        }
        if (source.isSelect()) {
            return DraftUtils.isActive(model, source.asSelect().from());
        }
        if (source.isTableFunction()) {
            return DraftUtils.isActive(model, source.asTableFunction().source());
        }
        throw new IllegalStateException("Unsupported source");
    }

    public static CqnSelect resolveConstantElements(CdsModel model, CdsStructuredType target, CqnSelect select) {
        if (!DraftUtils.isActive(model, select.from())) {
            return select;
        }
        ReplaceIsActiveModifier modifier = new ReplaceIsActiveModifier(model);
        SelectBuilder copy = SelectBuilder.copy((CqnSelect)select, (Modifier)modifier);
        TrafoModifier tm = new TrafoModifier(modifier);
        copy.transformations(tm.replaceIsActive(copy.transformations()));
        return copy;
    }

    public static enum Element {
        IS_ACTIVE("IsActiveEntity"),
        HAS_ACTIVE("HasActiveEntity"),
        HAS_DRAFT("HasDraftEntity"),
        DRAFT_UUID("DraftAdministrativeData_DraftUUID");

        private final String name;

        private Element(String name) {
            this.name = name;
        }
    }

    private static final class ReplaceIsActiveModifier
    implements Modifier {
        private final CdsModel model;

        public ReplaceIsActiveModifier(CdsModel model) {
            this.model = model;
        }

        public CqnStructuredTypeRef ref(CqnStructuredTypeRef ref) {
            CdsEntity type = this.model.getEntity(ref.firstSegment());
            List original = ref.segments();
            ArrayList<CqnReference.Segment> copy = new ArrayList<CqnReference.Segment>(original.size());
            boolean changed = false;
            Iterator iter = original.iterator();
            CqnReference.Segment seg = (CqnReference.Segment)iter.next();
            while (true) {
                CqnReference.Segment s = seg;
                if (DraftUtils.isActive((CdsStructuredType)type) && seg.filter().isPresent()) {
                    Predicate filter = CQL.copy((CqnPredicate)((CqnPredicate)seg.filter().get()), (Modifier)new ReplaceIsActiveModifier(this.model));
                    s = RefSegmentImpl.refSegment((String)seg.id(), (CqnPredicate)filter);
                    changed = true;
                }
                copy.add(s);
                if (!iter.hasNext()) break;
                seg = (CqnReference.Segment)iter.next();
                type = type.getTargetOf(seg.id());
            }
            return changed ? CQL.to(copy).asRef() : ref;
        }

        public CqnValue ref(CqnElementRef ref) {
            return switch (ref.path()) {
                case "IsActiveEntity" -> CqnBoolLiteral.TRUE;
                case "HasActiveEntity" -> CqnBoolLiteral.FALSE;
                default -> ref;
            };
        }
    }

    private static class TrafoModifier {
        private final Modifier modifier;

        TrafoModifier(Modifier modifier) {
            this.modifier = modifier;
        }

        List<CqnTransformation> replaceIsActive(List<CqnTransformation> trafos) {
            return trafos.stream().map(this::replaceIsActive).toList();
        }

        private CqnTransformation replaceIsActive(CqnTransformation t) {
            if (t instanceof FilterTrafo) {
                FilterTrafo filter = (FilterTrafo)t;
                t = FilterTrafo.filter((CqnPredicate)CQL.copy((CqnPredicate)filter.filter(), (Modifier)this.modifier));
            } else if (t instanceof AbstractHierarchySubsetTrafo) {
                AbstractHierarchySubsetTrafo subset = (AbstractHierarchySubsetTrafo)t;
                List<CqnTransformation> filters = this.replaceIsActive(subset.transformations());
                subset.transformations(filters);
            }
            return t;
        }
    }
}

