/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.impl.sql.SqlMappingImpl;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.function.Function;

public class HanaSqlMapping
extends SqlMappingImpl {
    public HanaSqlMapping(CdsStructuredType rowType, Function<String, String> casing) {
        super(rowType, casing);
    }

    @Override
    public String jsonQuery(String contextItem, String jsonPath) {
        return "JSON_QUERY(" + contextItem + ", " + SQLHelper.literal(jsonPath) + ")";
    }

    @Override
    public String jsonValue(String contextItem, String jsonPath, CdsBaseType type) {
        String jsonValue = "JSON_VALUE(" + contextItem + ", " + SQLHelper.literal(jsonPath) + HanaSqlMapping.returnType(type) + ")";
        if (type == CdsBaseType.TIMESTAMP || type == CdsBaseType.DATETIME) {
            jsonValue = "TO_TIMESTAMP(" + jsonValue + ")";
        }
        return jsonValue;
    }

    private static String returnType(CdsBaseType type) {
        if (type == null) {
            return "";
        }
        String t = switch (type) {
            case CdsBaseType.INTEGER, CdsBaseType.INT32, CdsBaseType.INT16 -> "INTEGER";
            case CdsBaseType.INTEGER64, CdsBaseType.INT64 -> "BIGINT";
            case CdsBaseType.DECIMAL -> "DECIMAL";
            case CdsBaseType.BOOLEAN -> "BOOLEAN";
            default -> null;
        };
        return t == null ? "" : " RETURNING " + t;
    }
}

