/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.collect.ForwardingList;
import com.google.common.collect.Lists;
import com.sap.cds.CdsDataStore;
import com.sap.cds.JSONizable;
import com.sap.cds.Row;
import com.sap.cds.impl.Lazy;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.cqn.CqnSelect;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class LazyResultImpl
extends ForwardingList<Row>
implements Lazy,
JSONizable {
    private final AtomicBoolean loaded = new AtomicBoolean();
    private final CdsDataStore dataStore;
    private final CqnSelect query;
    private List<Row> rows;

    public LazyResultImpl(CdsDataStore dataStore, CqnSelect query) {
        this.dataStore = dataStore;
        this.query = query;
    }

    protected List<Row> delegate() {
        this.load();
        return this.rows;
    }

    public void load() {
        if (this.loaded.compareAndSet(false, true)) {
            this.rows = this.dataStore.execute(this.query, new Object[0]).list();
        }
    }

    public boolean isLoaded() {
        return this.loaded.get();
    }

    public Object loadData() {
        return Lists.newArrayList((Iterable)this.delegate());
    }

    public String toJson() {
        return this.isLoaded() ? Jsonizer.json(this.rows) : null;
    }

    public String toString() {
        return this.toJson();
    }
}

