/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.qat;

import com.google.common.base.Strings;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.qat.QatAssociation;
import com.sap.cds.impl.qat.QatAssociationNode;
import com.sap.cds.impl.qat.QatElementNode;
import com.sap.cds.impl.qat.QatNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.qat.QatStructuredElementNode;
import com.sap.cds.impl.qat.Ref2Column;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Ref2QualifiedColumn
implements Ref2Column {
    private final QatSelectableNode root;
    private final QatSelectableNode outer;
    private final String rootName;
    private final SqlMapping sqlMapping;
    private final LocaleUtils localeUtils;
    private String collateClause = null;

    public Ref2QualifiedColumn(Function<CdsStructuredType, SqlMapping> mapping, Deque<QatSelectableNode> outer, LocaleUtils localeUtils) {
        Iterator<QatSelectableNode> reverse = outer.descendingIterator();
        this.root = Ref2QualifiedColumn.qatRoot(reverse.next());
        this.rootName = this.root.rowType().getQualifiedName();
        this.outer = reverse.hasNext() ? reverse.next() : null;
        this.sqlMapping = mapping.apply(this.root.rowType());
        this.localeUtils = localeUtils;
    }

    public void startCollate(String collateClause) {
        if (Strings.emptyToNull((String)collateClause) != null) {
            this.collateClause = " " + collateClause;
        } else {
            this.stopCollate();
        }
    }

    public void stopCollate() {
        this.collateClause = null;
    }

    public Stream<String> apply(CqnElementRef ref) {
        return this.apply(Ref2Column.Clause.WHERE, ref);
    }

    @Override
    public Stream<String> apply(Ref2Column.Clause clause, CqnElementRef ref) {
        List segments = ref.segments();
        CdsBaseType refType = ref.type().map(CdsBaseType::cdsType).orElse(null);
        if (ref.firstSegment().equals("$outer")) {
            return this.qualifiedColumnName(clause, segments.subList(1, segments.size()), this.outer, refType);
        }
        return this.qualifiedColumnName(clause, segments, this.root, refType);
    }

    private Stream<String> qualifiedColumnName(Ref2Column.Clause clause, List<? extends CqnReference.Segment> segments, QatNode node, CdsBaseType type) {
        boolean firstSegment = segments.size() > 1;
        ArrayList<String> columnNames = new ArrayList<String>(2);
        String jsonPath = null;
        for (int i = 0; i < segments.size(); ++i) {
            QatElementNode en;
            CqnReference.Segment s = segments.get(i);
            if (firstSegment && s.id().equals(this.rootName)) continue;
            if (node instanceof QatElementNode && (en = (QatElementNode)node).isJson()) {
                jsonPath = segments.stream().skip(i).map(CqnReference.Segment::id).collect(Collectors.joining(".", "$.", ""));
                break;
            }
            node = node.child(s.id(), s.filter());
            Ref2QualifiedColumn.assertNotNull(segments, node);
            firstSegment = false;
        }
        if (node instanceof QatElementNode) {
            QatElementNode en = (QatElementNode)node;
            columnNames.add(this.columnName(en));
        } else if (node instanceof QatAssociationNode) {
            QatAssociationNode an = (QatAssociationNode)node;
            QatAssociation association = an.association();
            if (CdsModelUtils.isReverseAssociation((CdsElement)this.root.rowType().getAssociation(association.name()))) {
                throw new CqnValidationException("The association '" + node.name() + "' is mapped via an inverse FK and therefore not supported on the select list");
            }
            new OnConditionAnalyzer(association.name(), association.on(), false).getFkMapping().keySet().stream().map(arg_0 -> ((SqlMapping)this.sqlMapping).columnName(arg_0)).forEach(columnNames::add);
        } else {
            throw new CqnValidationException(node.name() + " does not refer to an element");
        }
        while ((node = node.parent()) != null && !(node instanceof QatSelectableNode)) {
        }
        Ref2QualifiedColumn.assertNotNull(segments, node);
        String tableAlias = ((QatSelectableNode)node).alias();
        Stream<String> columns = columnNames.stream().map(c -> Ref2QualifiedColumn.column(tableAlias, c));
        if (!Strings.isNullOrEmpty((String)jsonPath)) {
            String jsPath = jsonPath;
            columns = type != null && type != CdsBaseType.MAP ? columns.map(col -> this.sqlMapping.jsonValue(col, jsPath, type)) : columns.map(col -> switch (clause) {
                default -> throw new IncompatibleClassChangeError();
                case Ref2Column.Clause.WHERE, Ref2Column.Clause.ORDERBY -> this.sqlMapping.jsonValue(col, jsPath, type);
                case Ref2Column.Clause.SELECT -> this.sqlMapping.jsonQuery(col, jsPath);
            });
        }
        return columns;
    }

    private static String column(String alias, String col) {
        return alias + "." + col;
    }

    private static QatSelectableNode qatRoot(QatNode root) {
        Optional<QatNode> next;
        while ((next = Ref2QualifiedColumn.childInSource(root)).isPresent()) {
            root = next.get();
        }
        return (QatSelectableNode)root;
    }

    private static Optional<QatNode> childInSource(QatNode root) {
        return root.children().stream().filter(QatNode::inSource).findFirst();
    }

    private String columnName(QatElementNode elementNode) {
        CdsElement cdsElement = elementNode.element();
        Object columnName = this.sqlMapping.columnName(cdsElement);
        if (elementNode.parent() instanceof QatStructuredElementNode) {
            if (DocStoreUtils.targetsDocStore((CdsStructuredType)cdsElement.getDeclaringType())) {
                return columnName;
            }
            if (cdsElement.findAnnotation("cds.persistence.name").isEmpty()) {
                columnName = this.structuredColumnName(elementNode);
            }
        }
        if (this.collateClause != null && this.localeUtils.requiresCollate(cdsElement)) {
            columnName = (String)columnName + this.collateClause;
        }
        return columnName;
    }

    private String structuredColumnName(QatNode node) {
        ArrayList<String> elementName = new ArrayList<String>();
        elementName.add(((QatElementNode)node).element().getName());
        QatNode parent = node.parent();
        while (parent instanceof QatStructuredElementNode) {
            QatStructuredElementNode structNode = (QatStructuredElementNode)parent;
            elementName.add(structNode.element().getName());
            parent = structNode.parent();
        }
        Collections.reverse(elementName);
        return this.sqlMapping.delimitedCasing(String.join((CharSequence)"_", elementName));
    }

    private static void assertNotNull(List<? extends CqnReference.Segment> segments, QatNode node) {
        if (node == null) {
            ElementRef ref = ElementRefImpl.elementRef(segments, null, null);
            throw new CqnValidationException("Unresolvable path expression: " + ref.toJson());
        }
    }

    public String rootAlias() {
        return this.root.alias();
    }
}

