/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.hierarchies;

import com.sap.cds.CqnTableFunction;
import com.sap.cds.impl.builder.model.InSubquery;
import com.sap.cds.ql.BooleanValue;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.Source;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.transformation.CqnAncestorsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnDescendantsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnFilterTransformation;
import com.sap.cds.ql.cqn.transformation.CqnHierarchySubsetTransformation;
import com.sap.cds.ql.cqn.transformation.CqnSearchTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTopLevelsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.ql.hana.HANA;
import com.sap.cds.ql.hana.Hierarchy;
import com.sap.cds.ql.hana.HierarchySubset;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.transformations.HierarchyUtils;
import com.sap.cds.util.transformations.TransformationToSelect;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class HanaHierarchyResolver
extends TransformationToSelect {
    private static final long LEVELS_ALL = -1L;
    private static final Literal<Number> ZERO = CQL.constant((Object)0);
    private static final Literal<Number> ONE = CQL.constant((Object)1);
    private static final String PARENT_ID = "parent_id";
    private static final String NODE_ID = "node_id";
    private static final String HIERARCHY_TREE_SIZE = "hierarchy_tree_size";
    private static final String HIERARCHY_LEVEL = "hierarchy_level";
    private static final String HIERARCHY_RANK = "hierarchy_rank";
    private static final String DISTANCE_FROM_ROOT = "DistanceFromRoot";
    private static final String LIMITED_DESCENDANT_COUNT = "LimitedDescendantCount";
    private static final String DESCENDANT_COUNT = "DescendantCount";
    private static final ElementRef<Number> DESCENDANT_COUNT_REF = CQL.get((String)"DescendantCount");
    private static final String DRILL_STATE = "DrillState";
    private static final String RANK = "Rank";
    private static final String LIMITED_RANK = "LimitedRank";
    private boolean isHierarchicalSelect;
    private static final Literal<String> COLLAPSED = CQL.constant((Object)"collapsed");
    private static final Literal<String> EXPANDED = CQL.constant((Object)"expanded");
    private static final Literal<String> LEAF = CQL.constant((Object)"leaf");
    private final CdsModel model;
    private Hierarchy sourceHierarchy;
    private List<CqnTransformation> transformations;
    private List<CqnSelectListItem> originalItems;
    private String nodeId;
    private String parentId;

    public HanaHierarchyResolver(CdsModel model, Select<?> select) {
        super(select);
        this.model = model;
    }

    protected void before(CqnSelect original) {
        this.originalItems = original.items();
        this.isHierarchicalSelect = original.transformations().stream().anyMatch(HierarchyUtils::isHierarchical);
        if (this.isHierarchicalSelect) {
            this.transformations = original.transformations();
            Select hierarchySource = HierarchyUtils.addNodeAndParentElements((CdsModel)this.model, (Select)this.select, this.transformations);
            this.sourceHierarchy = HANA.hierarchy((Source)hierarchySource);
            this.select = (Select)Select.from((CqnTableFunction)this.sourceHierarchy).columns(new Selectable[]{CQL.star(), HanaHierarchyResolver.descendantCount(), HanaHierarchyResolver.distanceFromRoot(), HanaHierarchyResolver.rank()}).excluding(new String[]{HIERARCHY_TREE_SIZE, HIERARCHY_LEVEL, HIERARCHY_RANK}).hints(original.hints());
            CdsStructuredType sourceRowType = CqnStatementUtils.rowType((CdsModel)this.model, (CqnSelect)hierarchySource);
            this.nodeId = HanaHierarchyResolver.findCaseInsensitive(sourceRowType, NODE_ID);
            this.parentId = HanaHierarchyResolver.findCaseInsensitive(sourceRowType, PARENT_ID);
            CdsEntity targetEntity = (CdsEntity)CqnStatementUtils.rowType((CdsModel)this.model, (CqnSource)original.from());
            this.applyDefaultOrder(targetEntity);
        }
    }

    private void applyDefaultOrder(CdsEntity target) {
        this.applyOrderBy(() -> List.of(CQL.get((String)this.nodeId).asc()));
        target.query().ifPresent(q -> this.applyOrderBy(() -> q.orderBy()));
    }

    private static String findCaseInsensitive(CdsStructuredType type, String name) {
        return type.elements().map(CdsElementDefinition::getName).filter(name::equalsIgnoreCase).findFirst().orElse(name);
    }

    protected void after() {
        if (this.isHierarchicalSelect) {
            ListIterator<CqnTransformation> iter = this.transformations.listIterator(this.transformations.size());
            while (iter.hasPrevious()) {
                CqnTransformation t = iter.previous();
                if (t.kind() != CqnTransformation.Kind.DESCENDANTS) continue;
                HanaHierarchyResolver.addDescendantsDrillState((SelectBuilder)this.select, t);
                break;
            }
        }
    }

    protected void copySelectList(List<CqnSelectListItem> slis) {
        if (!this.isHierarchicalSelect) {
            super.copySelectList(slis);
        }
    }

    protected void applyTopLevels(CqnTopLevelsTransformation topLevels) {
        this.wrapIfHas(new TransformationToSelect.Sql[]{TransformationToSelect.Sql.WHERE, TransformationToSelect.Sql.GROUPBY, TransformationToSelect.Sql.AGGREGATE, TransformationToSelect.Sql.HAVING, TransformationToSelect.Sql.SKIP, TransformationToSelect.Sql.TOP});
        BooleanValue filter = CQL.TRUE;
        long levels = topLevels.levels();
        if (levels > 0L) {
            filter = this.select.from().isSelect() ? filter.and((CqnPredicate)CQL.get((String)DISTANCE_FROM_ROOT).lt((Object)levels), new CqnPredicate[0]) : filter.and((CqnPredicate)CQL.get((String)HIERARCHY_LEVEL).le((Object)levels), new CqnPredicate[0]);
        }
        Predicate f = filter.or((CqnPredicate)this.expandFilter(topLevels.expandLevels()), new CqnPredicate[0]);
        List<CqnSortSpecification> siblingOrderBy = this.stashOrderBy();
        this.applyFilter(() -> HanaHierarchyResolver.lambda$applyTopLevels$3((CqnPredicate)f));
        Hierarchy hierarchy = HANA.hierarchy((Source)this.select).orderBy(siblingOrderBy);
        this.select = Select.from((CqnTableFunction)hierarchy).columns(this.computeVirtual(this.originalItems));
    }

    private List<CqnSelectListItem> computeVirtual(List<CqnSelectListItem> slis) {
        if (slis.isEmpty()) {
            ArrayList<CqnSelectListItem> selectList = new ArrayList<CqnSelectListItem>(3);
            selectList.add((CqnSelectListItem)CQL.star());
            selectList.add((CqnSelectListItem)HanaHierarchyResolver.limitedDescendantCount());
            selectList.add(this.drillState());
            return selectList;
        }
        return slis.stream().map(this::computeVirtual).toList();
    }

    private CqnSelectListItem computeVirtual(CqnSelectListItem sli) {
        if (sli.isRef()) {
            String path;
            return switch (path = sli.asRef().path()) {
                case LIMITED_DESCENDANT_COUNT -> HanaHierarchyResolver.limitedDescendantCount();
                case LIMITED_RANK -> HanaHierarchyResolver.limitedRank();
                case DRILL_STATE -> this.drillState();
                default -> sli;
            };
        }
        return sli;
    }

    private static CqnSelectListValue distanceFromRoot() {
        return CQL.get((String)HIERARCHY_LEVEL).minus(ONE).as(DISTANCE_FROM_ROOT);
    }

    private static CqnSelectListValue descendantCount() {
        return CQL.get((String)HIERARCHY_TREE_SIZE).minus(ONE).as(DESCENDANT_COUNT);
    }

    private static CqnSelectListValue limitedDescendantCount() {
        return HanaHierarchyResolver.limitedDescendantCountVal().as(LIMITED_DESCENDANT_COUNT);
    }

    private static Value<Number> limitedDescendantCountVal() {
        return CQL.get((String)HIERARCHY_TREE_SIZE).minus(ONE);
    }

    private static CqnSelectListValue rank() {
        return CQL.get((String)HIERARCHY_RANK).minus(ONE).as(RANK);
    }

    private static CqnSelectListValue limitedRank() {
        return CQL.get((String)HIERARCHY_RANK).minus(ONE).as(LIMITED_RANK);
    }

    private CqnSelectListItem drillState() {
        Predicate noDescUnlimited = DESCENDANT_COUNT_REF.eq(ZERO);
        Predicate noDescLimited = HanaHierarchyResolver.limitedDescendantCountVal().eq(ZERO);
        Value drillState = CQL.when((CqnPredicate)noDescUnlimited).then(LEAF).when((CqnPredicate)noDescLimited).then(COLLAPSED).orElse(EXPANDED);
        return drillState.type(CdsBaseType.STRING).as(DRILL_STATE);
    }

    private static void addDescendantsDrillState(SelectBuilder<?> select, CqnTransformation t) {
        CqnDescendantsTransformation d = (CqnDescendantsTransformation)t;
        int v = d.distanceFromStart();
        if (v > 1 || d.keepStart()) {
            return;
        }
        CqnSelectListValue drillState = CQL.when((CqnPredicate)CQL.get((String)HIERARCHY_TREE_SIZE).gt(ONE)).then(COLLAPSED).orElse(LEAF).type(CdsBaseType.STRING).as(DRILL_STATE);
        select.addItem((Selectable)drillState);
    }

    private Predicate expandFilter(Map<Object, Long> ids) {
        List<Object> expandIdsOfLevelZero = this.getExpandIdsOfLevel(ids, 0L);
        List<Object> expandIdsOfLevelOne = this.getExpandIdsOfLevel(ids, 1L);
        List<Object> expandIdsOfLevelAll = this.getExpandIdsOfLevel(ids, -1L);
        List<Object> nodesAndDirectChildrenIds = Stream.concat(expandIdsOfLevelZero.stream(), expandIdsOfLevelOne.stream()).toList();
        Predicate expandNodesFilter = this.filterNodesOf(nodesAndDirectChildrenIds);
        Predicate expandOneLevelFilter = this.filterDirectDescendantsOf(expandIdsOfLevelOne);
        Predicate expandAllLevelsFilter = this.filterDeepDescendantsOf(expandIdsOfLevelAll);
        return CQL.or((CqnPredicate)expandNodesFilter, (CqnPredicate)CQL.or((CqnPredicate)expandOneLevelFilter, (CqnPredicate)expandAllLevelsFilter));
    }

    private List<Object> getExpandIdsOfLevel(Map<Object, Long> ids, long level) {
        return ids.entrySet().stream().filter(id -> (Long)id.getValue() == level).map(id -> id.getKey()).toList();
    }

    private Predicate filterDeepDescendantsOf(List<Object> ids) {
        if (ids.isEmpty()) {
            return CQL.FALSE;
        }
        HierarchySubset descendants = HANA.descendants((Hierarchy)this.sourceHierarchy).startWhere((CqnPredicate)CQL.get((String)this.nodeId).in(ids)).distance(Integer.MAX_VALUE, true);
        return CQL.get((String)this.nodeId).in((CqnSelect)Select.from((CqnTableFunction)descendants).columns(new String[]{this.nodeId}));
    }

    private Predicate filterDirectDescendantsOf(List<Object> expandIds) {
        return CQL.get((String)this.parentId).in(expandIds);
    }

    private Predicate filterNodesOf(List<Object> expandIds) {
        return CQL.get((String)this.nodeId).in(expandIds);
    }

    protected void applyAncestors(CqnAncestorsTransformation transformation) {
        this.subSet((CqnHierarchySubsetTransformation)transformation, HANA::ancestors);
    }

    protected void applyDescendants(CqnDescendantsTransformation transformation) {
        this.subSet((CqnHierarchySubsetTransformation)transformation, HANA::descendants);
    }

    private List<CqnSortSpecification> stashOrderBy() {
        List<CqnSortSpecification> sob = List.copyOf(this.select.orderBy());
        this.select.orderBy(List.of());
        return sob;
    }

    private void subSet(CqnHierarchySubsetTransformation subsetTrafo, Function<Hierarchy, HierarchySubset> factory) {
        BooleanValue startWhere = CQL.TRUE;
        for (CqnTransformation nested : subsetTrafo.transformations()) {
            if (nested instanceof CqnFilterTransformation) {
                CqnFilterTransformation filter = (CqnFilterTransformation)nested;
                startWhere = CQL.and((CqnPredicate)startWhere, (CqnPredicate)filter.filter());
                continue;
            }
            if (!(nested instanceof CqnSearchTransformation)) continue;
            CqnSearchTransformation search = (CqnSearchTransformation)nested;
            startWhere = CQL.and((CqnPredicate)startWhere, (CqnPredicate)search.search());
        }
        if (subsetTrafo.keepStart() && startWhere == CQL.TRUE) {
            return;
        }
        HierarchySubset subset = factory.apply(this.sourceHierarchy);
        subset.distance(subsetTrafo.distanceFromStart(), subsetTrafo.keepStart());
        subset.startWhere((CqnPredicate)startWhere);
        CqnSelect subquery = (CqnSelect)Select.from((CqnTableFunction)subset).columns(new String[]{this.nodeId}).distinct().hints(this.select.hints());
        List<CqnSortSpecification> sob = this.stashOrderBy();
        this.applyFilter(() -> InSubquery.in((CqnValue)CQL.get((String)this.nodeId), (CqnSelect)subquery));
        if (subset.isAncestors() && startWhere != CQL.TRUE) {
            Hierarchy hierarchy = HANA.hierarchy((Source)this.select.excluding(new String[]{HIERARCHY_TREE_SIZE, HIERARCHY_LEVEL, HIERARCHY_RANK, DESCENDANT_COUNT}));
            hierarchy.orderBy(sob);
            this.select = Select.from((CqnTableFunction)hierarchy).columns(new Selectable[]{CQL.star(), HanaHierarchyResolver.descendantCount()}).excluding(new String[]{HIERARCHY_TREE_SIZE, HIERARCHY_LEVEL, HIERARCHY_RANK});
        }
        if (subset.isDescendants()) {
            this.select.orderBy(sob);
        }
    }

    private static /* synthetic */ CqnPredicate lambda$applyTopLevels$3(CqnPredicate f) {
        return f;
    }
}

