/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.json;

import com.sap.cds.jdbc.generic.GenericScalarValueResolver;
import com.sap.cds.jdbc.spi.ScalarValueResolver;
import com.sap.cds.ql.cqn.CqnBooleanLiteral;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnParameter;
import com.sap.cds.reflect.CdsBaseType;

public class HanaDocStoreScalarValueResolver
extends GenericScalarValueResolver {
    private static final String JSON_TRUE = "TO_JSON_BOOLEAN(TRUE)";
    private static final String JSON_FALSE = "TO_JSON_BOOLEAN(FALSE)";
    public static final ScalarValueResolver INSTANCE = new HanaDocStoreScalarValueResolver();

    private HanaDocStoreScalarValueResolver() {
    }

    @Override
    public String literal(CqnBooleanLiteral bool) {
        return Boolean.TRUE.equals(bool.value()) ? JSON_TRUE : JSON_FALSE;
    }

    public String literal(CqnLiteral<?> val) {
        return val.type().map(cdsType -> HanaDocStoreScalarValueResolver.cast(HanaDocStoreScalarValueResolver.toDocStoreType(cdsType))).orElse("?");
    }

    public String parameter(CqnParameter param) {
        return param.type().map(cdsType -> HanaDocStoreScalarValueResolver.cast(HanaDocStoreScalarValueResolver.toDocStoreType(cdsType))).orElse("?");
    }

    public String parameter(CdsBaseType baseType) {
        return HanaDocStoreScalarValueResolver.cast(HanaDocStoreScalarValueResolver.toDocStoreType(baseType));
    }

    private static String cast(String docStoreType) {
        return "CAST(? AS %s)".formatted(docStoreType);
    }

    private static String toDocStoreType(String cdsType) {
        return HanaDocStoreScalarValueResolver.toDocStoreType(CdsBaseType.cdsType((String)cdsType));
    }

    private static String toDocStoreType(CdsBaseType baseType) {
        return switch (baseType) {
            case CdsBaseType.INTEGER, CdsBaseType.INTEGER64 -> "BIGINT";
            case CdsBaseType.DECIMAL, CdsBaseType.DOUBLE -> "DOUBLE";
            case CdsBaseType.BOOLEAN -> "BOOLEAN";
            default -> "NVARCHAR";
        };
    }
}

