/************************************************************************
 * © 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.impl;

import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.reflect.CdsEntity;

public interface CqnValidator {

	static CqnValidator create(Context context, Capabilities capabilities) {
		return new CqnValidatorImpl(context.getCdsModel(), capabilities);
	}

	void validate(CqnSelect select, CdsEntity entity);

	void validate(CqnInsert insert, CdsEntity entity);

	void validate(CqnUpdate update, CdsEntity entity);

	void validate(CqnUpsert upsert, CdsEntity entity);

	void validate(CqnDelete delete, CdsEntity entity);
}
