/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.impl.qat;

import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsEntity;

public final class QatAssociation {
	private final CdsEntity targetEntity;
	private final String elementName;
	private final CqnPredicate on;

	QatAssociation(CdsEntity targetEntity, String elementName, CqnPredicate on) {
		this.targetEntity = targetEntity;
		this.elementName = elementName;
		this.on = on;
	}

	public CdsEntity targetEntity() {
		return targetEntity;
	}

	public CqnPredicate on() {
		return on;
	}

	public String name() {
		return elementName;
	}

}
