/************************************************************************
 * © 2020-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.h2;

import java.util.TimeZone;

import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.generic.GenericDbContext;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.reflect.CdsStructuredType;

public final class H2DbContext extends GenericDbContext {

	public H2DbContext(DataStoreConfiguration dataStoreConfiguration) {
		super(dataStoreConfiguration);
	}

	@Override
	public FunctionMapper getFunctionMapper() {
		return new H2FunctionMapper();
	}

	@Override
	public StatementResolver getStatementResolver() {
		return new H2StatementResolver();
	}

	@Override
	public ExceptionAnalyzer getExceptionAnalyzer() {
		return new H2ExceptionAnalyzer();
	}

	@Override
	public Capabilities getCapabilities() {
		return new Capabilities() {
		};
	}

	@Override
	public SessionVariableSetter getSessionVariableSetter() {
		return new H2SessionVariableSetter();
	}

	@Override
	public SqlMapping getSqlMapping(CdsStructuredType rowType) {
		return new H2SqlMapping(rowType, casing());
	}

	@Override
	public ValueBinder getBinder(TimeZone timeZone) {
		return new H2Binder(timeZone);
	}

}
