/*******************************************************************
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.hana.json;

import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;

import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.hana.HanaDbContext;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.PredicateMapper;
import com.sap.cds.jdbc.spi.ScalarValueResolver;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;

public class HanaDocStoreDbContext implements DbContext {

	private final DbContext other;

	public HanaDocStoreDbContext(DbContext other) {
		this.other = other;
	}

	public HanaDocStoreDbContext(DataStoreConfiguration config, int majorVersion) {
		this(new HanaDbContext(config, majorVersion));
	}

	@Override
	public TableNameResolver createTableNameResolver(Locale locale) {
		return other.createTableNameResolver(locale);
	}

	@Override
	public SearchResolver createSearchResolver(CdsModel model, Locale locale, Map<String, Object> hints) {
		return other.createSearchResolver(model, locale, hints);
	}

	@Override
	public FunctionMapper getFunctionMapper() {
		return other.getFunctionMapper();
	}

	@Override
	public StatementResolver getStatementResolver() {
		return other.getStatementResolver();
	}

	@Override
	public ExceptionAnalyzer getExceptionAnalyzer() {
		return other.getExceptionAnalyzer();
	}

	@Override
	public Capabilities getCapabilities() {
		return other.getCapabilities();
	}

	@Override
	public PredicateMapper getPredicateMapper() {
		return other.getPredicateMapper();
	}

	@Override
	public ValueBinder getBinder(TimeZone timeZone) {
		return other.getBinder(timeZone);
	}

	@Override
	public SessionVariableSetter getSessionVariableSetter() {
		return other.getSessionVariableSetter();
	}

	@Override
	public Function<String, String> casing() {
		return other.casing();
	}

	@Override
	public SqlMapping getSqlMapping(CdsStructuredType rowType) {
		return new HanaDocStoreSqlMapping(rowType, casing());
	}

	@Override
	public ScalarValueResolver getScalarValueResolver() {
		return HanaDocStoreScalarValueResolver.INSTANCE;
	}

}
