/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.docstore;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.docstore.DocStoreStatementBuilder;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SpaceSeparatedCollector;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class DocStoreSelectStatementBuilder
implements DocStoreStatementBuilder {
    private final CqnSelect select;
    private final TokenToSQLTransformer toSql;
    private final SqlMapping sqlMapping;
    private final String tableName;
    private final CdsEntity entity;
    private final List<PreparedCqnStmt.Parameter> params = new ArrayList<PreparedCqnStmt.Parameter>();

    public DocStoreSelectStatementBuilder(Context context, CqnSelect select) {
        this.entity = context.getCdsModel().getEntity(select.ref().firstSegment());
        this.select = select;
        this.sqlMapping = context.getDbContext().getSqlMapping((CdsStructuredType)this.entity);
        this.tableName = this.sqlMapping.tableName();
        this.toSql = TokenToSQLTransformer.notCollating(context, (clause, ref) -> Stream.of(this.sqlMapping.columnName(ref)), this.entity, this.tableName, this.params);
    }

    @Override
    public SQLStatementBuilder.SQLStatement build() {
        Stream.Builder<String> builder = Stream.builder();
        builder.add("SELECT * FROM");
        builder.add(this.tableName);
        this.select.where().map(this.toSql::toSQL).ifPresent(whereSql -> {
            builder.add("WHERE");
            builder.add((String)whereSql);
        });
        List orderBy = this.select.orderBy();
        if (!orderBy.isEmpty()) {
            builder.add("ORDER BY");
            SQLStatementBuilder.commaSeparated(orderBy.stream(), this::sort).forEach(builder);
        }
        String sql = builder.build().collect(SpaceSeparatedCollector.joining());
        return new SQLStatementBuilder.SQLStatement(sql, this.params);
    }

    private String sort(CqnSortSpecification o) {
        StringBuilder sort = new StringBuilder(this.toSql.apply((CqnToken)o.value()));
        switch (o.order()) {
            case DESC: 
            case DESC_NULLS_FIRST: {
                sort.append(" DESC");
                break;
            }
        }
        return sort.toString();
    }
}

