/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.hierarchies;

import com.sap.cds.JSONizable;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Source;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.hana.CqnHierarchyGenerator;
import com.sap.cds.ql.hana.Hierarchy;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsElementBuilder;
import com.sap.cds.reflect.impl.CdsSimpleTypeBuilder;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class HierarchyGeneratorBuilder
implements CqnHierarchyGenerator,
Hierarchy {
    private static final CdsType BIGINT = CdsSimpleTypeBuilder.simpleType((CdsBaseType)CdsBaseType.INT64);
    private static final CdsType INTEGER = CdsSimpleTypeBuilder.simpleType((CdsBaseType)CdsBaseType.INT32);
    private static final CdsElementDefinition RANK = CdsElementBuilder.element((String)"hierarchy_rank").type(BIGINT).isNotNull(true).build();
    private static final CdsElementDefinition LEVEL = CdsElementBuilder.element((String)"hierarchy_level").type(INTEGER).isNotNull(true).build();
    private static final CdsElementDefinition TREE_SIZE = CdsElementBuilder.element((String)"hierarchy_tree_size").type(BIGINT).isNotNull(true).build();
    private final List<CqnSortSpecification> siblingOrderBy;
    private final Source<?> source;
    private Integer depth;
    private CqnPredicate startWhere;

    private HierarchyGeneratorBuilder(Source<?> source) {
        this.source = source;
        this.siblingOrderBy = new ArrayList<CqnSortSpecification>();
    }

    public static HierarchyGeneratorBuilder create(Source<?> source) {
        return new HierarchyGeneratorBuilder(source);
    }

    public static HierarchyGeneratorBuilder create(CqnSelect source) {
        return new HierarchyGeneratorBuilder((Source)source);
    }

    public void accept(CqnVisitor visitor) {
    }

    public String toJson() {
        Jsonizer cqn = Jsonizer.object((String)"source", this.source);
        if (this.depth != null) {
            cqn.put("depth", (Object)this.depth);
        }
        if (this.startWhere != null) {
            cqn.put("startWhere", (Object)this.startWhere);
        }
        if (!this.siblingOrderBy.isEmpty()) {
            cqn.put("siblingOrderBy", this.siblingOrderBy);
        }
        return Jsonizer.object((String)"hierarchy", (JSONizable)cqn).toJson();
    }

    public StructuredType<?> getType() {
        return this.source.getType();
    }

    public CqnSource source() {
        return this.source;
    }

    public List<CqnSortSpecification> orderBy() {
        return this.siblingOrderBy;
    }

    public Integer depth() {
        return this.depth;
    }

    public Optional<CqnPredicate> startWhere() {
        return Optional.ofNullable(this.startWhere);
    }

    public HierarchyGeneratorBuilder orderBy(CqnSortSpecification ... siblingOrderBy) {
        return this.orderBy((List)List.of(siblingOrderBy));
    }

    public HierarchyGeneratorBuilder orderBy(List<CqnSortSpecification> siblingOrderBy) {
        this.siblingOrderBy.clear();
        this.siblingOrderBy.addAll(siblingOrderBy);
        return this;
    }

    public HierarchyGeneratorBuilder orderBy(String ... siblingOrderBy) {
        this.siblingOrderBy.clear();
        this.siblingOrderBy.addAll(Arrays.stream(siblingOrderBy).map(o -> CQL.get((String)o).asc()).toList());
        return this;
    }

    public HierarchyGeneratorBuilder depth(Integer depth) {
        this.depth = depth;
        return this;
    }

    public HierarchyGeneratorBuilder startWhere(CqnPredicate startWhere) {
        this.startWhere = startWhere;
        return this;
    }

    public HierarchyGeneratorBuilder copy(Source<?> source) {
        return HierarchyGeneratorBuilder.create(source).depth(this.depth).orderBy((List)this.siblingOrderBy).startWhere(this.startWhere);
    }

    public CdsStructuredType rowType(CdsStructuredType sourceRowType) {
        return CqnStatementUtils.addElementsTo((CdsStructuredType)sourceRowType, (CdsElementDefinition[])new CdsElementDefinition[]{RANK, LEVEL, TREE_SIZE});
    }

    public String name() {
        return "HIERARCHY";
    }
}

