/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.sap.cds.CdsDataStore;
import com.sap.cds.Result;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExpressionImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.OccUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EntityCascader {
    private final CdsDataStore dataStore;
    private final CdsEntity rootEntity;
    private final Map<String, Object> paramValues = new HashMap<String, Object>();
    private final Set<EntityKeys> visited = new HashSet<EntityKeys>();
    private CqnPredicate rootFilter;

    private EntityCascader(CdsDataStore dataStore, CdsEntity rootEntity) {
        this.dataStore = dataStore;
        this.rootEntity = rootEntity;
    }

    public static EntityCascader from(CdsDataStore dataStore, CdsEntity entity) {
        return new EntityCascader(dataStore, entity);
    }

    public EntityCascader where(Optional<CqnPredicate> pred) {
        return this.where((CqnPredicate)pred.orElse(null));
    }

    public EntityCascader where(CqnPredicate pred) {
        this.rootFilter = pred;
        return this;
    }

    public EntityCascader with(Map<String, Object> paramValues) {
        this.paramValues.clear();
        this.paramValues.putAll(paramValues);
        return this;
    }

    public Set<EntityKeys> cascade(CdsModelUtils.CascadeType cascadeType) {
        return this.cascade(cascadeType, null);
    }

    public Set<EntityKeys> cascade(CdsModelUtils.CascadeType cascadeType, String path) {
        this.cascadeRoot(path, (d, a) -> CdsModelUtils.isCascading((CdsModelUtils.CascadeType)cascadeType, (CdsElement)a), Collections.emptyMap());
        return Collections.unmodifiableSet(this.visited);
    }

    @VisibleForTesting
    public Set<EntityKeys> cascade(Predicate<CdsAssociationType> assocFilter) {
        this.cascadeRoot(null, (d, a) -> assocFilter.test((CdsAssociationType)a.getType()), Collections.emptyMap());
        return Collections.unmodifiableSet(this.visited);
    }

    public static Stream<EntityOperation> cascadeDelete(CdsDataStore dataStore, EntityKeys targetEntity, String path) {
        return EntityCascader.from(dataStore, targetEntity.entity).where((CqnPredicate)ExpressionImpl.matching((Map)((Object)targetEntity))).cascade(CdsModelUtils.CascadeType.DELETE, path).stream().map(k -> EntityOperation.delete(k, null, dataStore.getSessionContext()));
    }

    private void cascadeRoot(String path, BiPredicate<Map<String, Object>, CdsElement> assocFilter, Map<String, Object> data) {
        this.cascade(this.rootEntity, this.rootFilter, this.paramValues, path, assocFilter, data);
    }

    private void cascade(CdsEntity entity, CqnPredicate filter, Map<String, Object> paramValues, String path, BiPredicate<Map<String, Object>, CdsElement> assocFilter, Map<String, Object> data) {
        if (path != null) {
            CdsElement assoc2 = entity.getAssociation(path);
            this.cascade(entity, filter, paramValues, assocFilter, assoc2, data);
        } else {
            entity.associations().filter(a -> assocFilter.test(data, (CdsElement)a)).forEach(assoc -> this.cascade(entity, filter, paramValues, assocFilter, (CdsElement)assoc, data));
        }
    }

    private void cascade(CdsEntity entity, CqnPredicate filter, Map<String, Object> paramValues, BiPredicate<Map<String, Object>, CdsElement> assocFilter, CdsElement association, Map<String, Object> data) {
        String assocName = association.getName();
        CdsAssociationType assocType = (CdsAssociationType)association.getType();
        StructuredType path = CQL.entity((String)entity.getQualifiedName()).filter(filter).to(assocName);
        CdsEntity targetEntity = assocType.getTarget();
        if (CdsModelUtils.isSingleValued((CdsType)assocType)) {
            this.cascadeToOne(path, targetEntity, association, paramValues, assocFilter, data);
        } else {
            this.cascadeToMany(path, targetEntity, association, paramValues, assocFilter);
        }
    }

    private static Map<String, Object> getMap(Map<String, Object> data, String key) {
        return data.getOrDefault(key, Collections.emptyMap());
    }

    private void cascadeToOne(StructuredType<?> path, CdsEntity target, CdsElement association, Map<String, Object> paramValues, BiPredicate<Map<String, Object>, CdsElement> assocFilter, Map<String, Object> parentData) {
        Select<?> selectTargetKeys = this.selectTargetKeys(association, path);
        Result targetData = this.dataStore.execute(selectTargetKeys, paramValues);
        ArrayList targetKeys = new ArrayList();
        Map<String, Object> newData = EntityCascader.getMap(parentData, association.getName());
        EntityKeys.Factory keysFactory = EntityKeys.of(target);
        targetData.stream().map(keysFactory::keys).forEach(targetKeys::add);
        targetKeys.stream().filter(this::notVisited).forEach(keys -> this.cascade(target, (CqnPredicate)ExpressionImpl.matching((Map)((Object)keys)), Collections.emptyMap(), null, assocFilter, newData));
    }

    private void cascadeToMany(StructuredType<?> path, CdsEntity target, CdsElement association, Map<String, Object> paramValues, BiPredicate<Map<String, Object>, CdsElement> assocFilter) {
        Select<?> selectTargetKeys = this.selectTargetKeys(association, path);
        EntityKeys.Factory keysFactory = EntityKeys.of(target);
        Set targetKeys = this.dataStore.execute(selectTargetKeys, paramValues).stream().map(keysFactory::keys).collect(Collectors.toSet());
        targetKeys.stream().filter(this::notVisited).forEach(k -> this.cascade(target, (CqnPredicate)ExpressionImpl.matching((Map)((Object)k)), Collections.emptyMap(), null, assocFilter, Collections.emptyMap()));
    }

    private Select<?> selectTargetKeys(CdsElement association, StructuredType<?> path) {
        CdsAssociationType assoc = (CdsAssociationType)association.getType();
        return Select.from(path).columns(assoc.getTarget().keyElements().flatMap(k -> EntityCascader.slis(k, k.getName(), new String[0])));
    }

    private static Stream<CqnSelectListItem> slis(CdsElement keyElement, String alias, String ... association) {
        String[] path = Arrays.copyOf(association, association.length + 1);
        path[path.length - 1] = alias;
        if (keyElement.getType().isAssociation()) {
            return AssociationAnalyzer.mappingElements((CdsElement)keyElement).flatMap(k -> EntityCascader.slis(k.element(), k.alias(), path));
        }
        return Stream.of(EntityCascader.sli(path));
    }

    private static CqnSelectListItem sli(String ... path) {
        ElementRef element = ElementRefImpl.elementRef((String[])path);
        if (path.length > 1) {
            String alias = Arrays.stream(path).collect(Collectors.joining("."));
            element = element.as(alias);
        }
        return element;
    }

    private boolean notVisited(EntityKeys keys) {
        return this.visited.add(keys);
    }

    public static class EntityKeys
    extends ForwardingMap<String, Object> {
        private final CdsEntity entity;
        private final Map<String, Object> keys;

        private EntityKeys(CdsEntity entity, Map<String, Object> keys) {
            this.entity = entity;
            this.keys = keys;
        }

        public static Factory of(CdsEntity entity) {
            return new Factory(entity);
        }

        public static EntityKeys keys(CdsEntity entity, EntityData data) {
            return EntityKeys.of(entity).keys(data.withFKs());
        }

        public static EntityKeys keys(CdsEntity entity, Map<String, Object> data) {
            return EntityKeys.of(entity).keys(data);
        }

        public Map<String, Object> keys() {
            return Collections.unmodifiableMap(this.keys);
        }

        public CdsEntity entity() {
            return this.entity;
        }

        protected Map<String, Object> delegate() {
            return this.keys;
        }

        public int hashCode() {
            return Objects.hash(this.entity.getQualifiedName(), this.keys);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            EntityKeys other = (EntityKeys)((Object)obj);
            if (!this.entity.getQualifiedName().equals(other.entity.getQualifiedName())) {
                return false;
            }
            return this.keys.equals(other.keys);
        }

        public String toString() {
            return this.entity.getQualifiedName() + "[" + this.keys.toString() + "]";
        }

        public static class Factory {
            private final CdsEntity entity;
            private final Set<String> keyNames;

            private Factory(CdsEntity entity) {
                this.entity = entity;
                this.keyNames = CdsModelUtils.concreteKeyNames((CdsStructuredType)entity);
            }

            public EntityKeys keys(EntityData data) {
                return this.keys(data.withFKs());
            }

            public EntityKeys keys(Map<String, Object> data) {
                Map keyValues;
                try {
                    keyValues = DataUtils.keyValues(this.keyNames, data, (boolean)true);
                }
                catch (NullPointerException e) {
                    throw new CdsDataException("Key values of entity " + this.entity + " must not be null", (Throwable)e);
                }
                return new EntityKeys(this.entity, keyValues);
            }
        }
    }

    public static class EntityOperation
    extends ForwardingMap<String, Object> {
        private final EntityKeys targetKeys;
        private final Map<String, Object> data = new HashMap<String, Object>();
        private final Set<String> updated = new HashSet<String>();
        private final boolean root;
        private final String path;
        private EntityData updateData;
        private SessionContext sessionContext;
        private long updateCount = 0L;
        private Operation operation;

        private EntityOperation(EntityKeys targetKeys, String path, Operation operation, SessionContext sessionContext, boolean root) {
            this.targetKeys = targetKeys;
            this.path = path;
            this.data.putAll((Map<String, Object>)((Object)targetKeys));
            this.operation = operation;
            this.sessionContext = sessionContext;
            this.root = root;
        }

        public static EntityOperation root(EntityKeys entity, SessionContext sessionContext) {
            return EntityOperation.root(entity, Operation.UPDATE, sessionContext);
        }

        public static EntityOperation root(EntityKeys entity, Operation op, SessionContext sessionContext) {
            return new EntityOperation(entity, null, op, sessionContext, true);
        }

        public static EntityOperation nop(EntityKeys entity, String path, SessionContext sessionContext) {
            return new EntityOperation(entity, path, Operation.NOP, sessionContext, false);
        }

        public static EntityOperation nop(EntityKeys entity, String path, Map<String, Object> data, SessionContext sessionContext) {
            return EntityOperation.nop(entity, path, sessionContext).data(EntityData.of(data));
        }

        public static EntityOperation upsert(EntityKeys entity, EntityData data, SessionContext sessionContext) {
            return new EntityOperation(entity, null, Operation.UPSERT, sessionContext, false).update(data);
        }

        public static EntityOperation updateOrInsert(EntityKeys entity, EntityData data, SessionContext sessionContext) {
            return new EntityOperation(entity, null, Operation.UPDATE_OR_INSERT, sessionContext, false).update(data);
        }

        public static EntityOperation insert(EntityKeys entity, EntityData data, SessionContext sessionContext) {
            return new EntityOperation(entity, null, Operation.INSERT, sessionContext, false).data(data);
        }

        public static EntityOperation delete(EntityKeys targetKeys, String path, SessionContext sessionContext) {
            return new EntityOperation(targetKeys, path, Operation.DELETE, sessionContext, false);
        }

        public CdsEntity targetEntity() {
            return this.targetKeys.entity;
        }

        public String path() {
            return this.path;
        }

        public Operation operation() {
            return this.operation;
        }

        public boolean isRootOp() {
            return this.root;
        }

        public long updateCount() {
            return this.updateCount;
        }

        public EntityOperation data(EntityData data) {
            this.updateData = data;
            this.data.putAll(this.flattenData(this.targetKeys.entity, (Map<String, Object>)((Object)data)));
            this.data.putAll(data.foreignKeys());
            return this;
        }

        public boolean inserted(Map<String, Object> data) {
            if (!data.isEmpty()) {
                this.updateData.putAll(Maps.filterKeys(data, k -> !this.data.keySet().contains(k)));
                this.updateCount = 1L;
                return true;
            }
            return false;
        }

        public boolean updated(Map<String, Object> data, long updateCount) {
            this.updateCount = updateCount;
            if (!data.isEmpty()) {
                this.updateData.putAll(Maps.filterKeys(data, k -> !this.data.keySet().contains(k)));
                this.updateVersion(data);
                return true;
            }
            return false;
        }

        private void updateVersion(Map<String, Object> data) {
            if (this.isRootOp()) {
                OccUtils.getVersionElement((CdsStructuredType)this.targetKeys.entity()).ifPresent(vers -> this.updateData.computeIfPresent(vers.getName(), (k, v) -> data.get(k)));
            }
        }

        public EntityOperation deleted() {
            return this;
        }

        public EntityOperation updateToNull(Set<String> keys) {
            for (String key : keys) {
                this.data.put(key, null);
                this.updated.add(key);
                this.operation = Operation.UPDATE;
            }
            return this;
        }

        public EntityOperation update(EntityData updateData) {
            return this.update((Map<String, Object>)((Object)updateData), updateData.foreignKeys());
        }

        public EntityOperation update(Map<String, Object> updateData, Map<String, Object> fkValues) {
            this.mergeData(updateData);
            Map<String, Object> flattenedData = this.flattenData(this.targetEntity(), updateData);
            flattenedData.putAll(fkValues);
            flattenedData.forEach((key, newValue) -> {
                boolean valuePresent = this.data.containsKey(key);
                Object oldVal = this.data.put((String)key, newValue);
                if (!valuePresent || !Objects.equals(oldVal, newValue)) {
                    Object keyVal;
                    this.updated.add((String)key);
                    if (this.operation == Operation.NOP) {
                        this.operation = Operation.UPDATE;
                    }
                    if ((keyVal = this.targetKeys.get(key)) != null && !keyVal.equals(newValue)) {
                        throw new CdsDataException("Key values cannot be changed");
                    }
                }
            });
            return this;
        }

        private void mergeData(Map<String, Object> data) {
            if (this.updateData == null) {
                Map<String, Object> merged = data;
            } else {
                HashMap<String, Object> merged = new HashMap<String, Object>(this.updateData.data);
                merged.putAll(data);
            }
            this.updateData = EntityData.of(data);
        }

        private Map<String, Object> flattenData(CdsEntity entity, Map<String, Object> updateData) {
            HashMap<String, Object> flatEntry = new HashMap<String, Object>(updateData);
            EntityOperation.associationsInData(entity, updateData).forEach(a -> this.flattenData((CdsElement)a, (Map<String, Object>)flatEntry, updateData));
            return flatEntry;
        }

        private static Stream<CdsElement> associationsInData(CdsEntity e, Map<String, Object> d) {
            return e.associations().filter(a -> d.containsKey(a.getName()));
        }

        private void flattenData(CdsElement association, Map<String, Object> flatEntry, Map<String, Object> original) {
            if (CdsModelUtils.isReverseAssociation((CdsElement)association)) {
                flatEntry.remove(association.getName());
            } else {
                Map fkValues;
                OnConditionAnalyzer onConAnalyzer = new OnConditionAnalyzer(association, false, this.sessionContext);
                Map<String, Object> targetValues = (Map<String, Object>)flatEntry.remove(association.getName());
                if (targetValues == null) {
                    fkValues = onConAnalyzer.getFkValues(Collections.emptyMap());
                    Set<String> entityKeys = this.targetKeys.keys.keySet();
                    fkValues.entrySet().removeIf(entry -> entityKeys.contains(entry.getKey()));
                } else {
                    CdsAssociationType assocType = (CdsAssociationType)association.getType();
                    targetValues = this.flattenData(assocType.getTarget(), targetValues);
                    fkValues = onConAnalyzer.getFkValues(targetValues, false);
                }
                flatEntry.putAll(fkValues);
                fkValues.entrySet().stream().filter(e -> original.containsKey(e.getKey())).forEach(e -> original.put((String)e.getKey(), e.getValue()));
            }
        }

        public EntityKeys targetKeys() {
            return this.targetKeys;
        }

        public Map<String, Object> updateValues() {
            HashMap<String, Object> values = new HashMap<String, Object>(Maps.filterKeys(this.data, this.updated::contains));
            values.putAll((Map<String, Object>)((Object)this.targetKeys));
            return values;
        }

        protected Map<String, Object> delegate() {
            return this.data;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.targetKeys, this.data});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            EntityOperation other = (EntityOperation)((Object)obj);
            if (!this.targetKeys.equals((Object)other.targetKeys)) {
                return false;
            }
            return this.data.equals(other.data);
        }

        public String toString() {
            return this.operation + " " + this.targetKeys + ": " + this.data.toString();
        }

        public static enum Operation {
            NOP,
            INSERT,
            UPDATE,
            UPDATE_OR_INSERT,
            UPSERT,
            DELETE;

        }

        public static enum State {
            UNCHANGED,
            INSERTED,
            UPDATED,
            DELETED;

        }
    }

    public static class EntityData
    extends ForwardingMap<String, Object> {
        private final Map<String, Object> data;
        private final Map<String, Object> fks = new HashMap<String, Object>(3, 1.0f);

        private EntityData(Map<String, Object> data) {
            this.data = data;
        }

        public static EntityData ofFKs(Map<String, Object> fks) {
            return EntityData.of().putFKs(fks);
        }

        public static EntityData of() {
            return EntityData.of(new HashMap<String, Object>(2));
        }

        public static EntityData of(Map<String, Object> data) {
            if (data instanceof EntityData) {
                EntityData ed = (EntityData)((Object)data);
                return ed;
            }
            if (data == null) {
                return null;
            }
            return new EntityData(data);
        }

        public EntityData putFKs(Map<? extends String, ?> map) {
            this.fks.putAll(map);
            return this;
        }

        public Map<String, Object> data() {
            return this.data;
        }

        Map<String, Object> foreignKeys() {
            return this.fks;
        }

        public Map<String, Object> withFKs() {
            HashMap<String, Object> merged = new HashMap<String, Object>(this.data.size() + this.fks.size(), 1.0f);
            merged.putAll(this.data);
            merged.putAll(this.fks);
            return merged;
        }

        protected Map<String, Object> delegate() {
            return this.data;
        }
    }

    public static class EntityOperations {
        private final List<EntityOperation> operations = new ArrayList<EntityOperation>();
        private final List<Map<String, Object>> entries = new ArrayList<Map<String, Object>>();

        public void entries(List<Map<String, Object>> entries) {
            this.entries.addAll(entries);
        }

        public List<Map<String, Object>> entries() {
            return this.entries;
        }

        public boolean add(EntityOperation op) {
            return this.operations.add(op);
        }

        public Stream<EntityOperation> rootOps() {
            return this.operations.stream().filter(EntityOperation::isRootOp);
        }

        public Stream<EntityOperation> filter(EntityOperation.Operation opType) {
            return this.operations.stream().filter((? super T d) -> d.operation() == opType);
        }

        public long[] updateCount() {
            long[] updateCount = this.rootOps().mapToLong(EntityOperation::updateCount).toArray();
            if (updateCount.length == 0) {
                return new long[]{0L};
            }
            return updateCount;
        }
    }
}

