/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic.hierarchies;

import com.sap.cds.CqnTableFunction;
import com.sap.cds.ql.BooleanValue;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.transformation.CqnDescendantsTransformation;
import com.sap.cds.ql.hana.HANA;
import com.sap.cds.ql.hana.Hierarchy;
import com.sap.cds.ql.hana.HierarchySubset;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.util.transformations.HierarchyUtils;
import com.sap.cds.util.transformations.TransformationToSelect;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class GenericHierarchyResolver
extends TransformationToSelect {
    private static final long LEVELS_ALL = -1L;
    public static final String DESCENDANT_COUNT = "DescendantCount";
    public static final String LIMITED_DESCENDANT_COUNT = "LimitedDescendantCount";
    public static final String DISTANCE_FROM_ROOT = "DistanceFromRoot";
    public static final String DRILL_STATE = "DrillState";
    public static final String LIMITED_RANK = "LimitedRank";
    protected static final String HIERARCHY_LEVEL = "hierarchy_level";
    protected static final ElementRef<Number> DESCENDANT_COUNT_REF = CQL.get((String)"DescendantCount");
    protected static final ElementRef<Number> LIMITED_DESCENDANT_COUNT_REF = CQL.get((String)"LimitedDescendantCount");
    protected static final String RANK = "Rank";
    protected static final Set<String> COMPUTED_ELEMENTS = Set.of("DistanceFromRoot", "LimitedDescendantCount", "DescendantCount", "DrillState", "Rank", "LimitedRank");
    protected static final Literal<String> COLLAPSED = CQL.constant((Object)"collapsed");
    protected static final Literal<String> EXPANDED = CQL.constant((Object)"expanded");
    protected static final Literal<String> LEAF = CQL.constant((Object)"leaf");
    protected final CdsModel model;
    protected boolean isHierarchicalSelect;
    protected List<CqnSelectListItem> originalItems;
    protected Hierarchy rootHierarchy;
    protected String nodeId;
    protected String parentId;

    public GenericHierarchyResolver(CdsModel model, Select<?> select) {
        super(select);
        this.model = model;
    }

    protected void before(CqnSelect original) {
        this.originalItems = original.items();
        this.isHierarchicalSelect = original.transformations().stream().anyMatch(HierarchyUtils::isHierarchical);
    }

    protected void copySelectList(List<CqnSelectListItem> slis) {
        if (!this.isHierarchicalSelect) {
            super.copySelectList(slis);
        }
    }

    protected void checkDescendantsInput(CqnDescendantsTransformation transformation) {
        if (transformation.keepStart()) {
            throw new IllegalStateException("keep start must be false for descendants");
        }
        if (transformation.distanceFromStart() != 1) {
            throw new IllegalStateException("distance from start must be 1 for descendants");
        }
    }

    protected CqnPredicate limiter(long levels, Map<Object, Long> expandLevels) {
        BooleanValue limiter = CQL.TRUE;
        if (levels > 0L) {
            limiter = this.select.from().isSelect() ? limiter.and((CqnPredicate)CQL.get((String)DISTANCE_FROM_ROOT).lt((Object)levels), new CqnPredicate[0]) : limiter.and((CqnPredicate)CQL.get((String)HIERARCHY_LEVEL).le((Object)levels), new CqnPredicate[0]);
        }
        return limiter.or((CqnPredicate)this.expandFilter(expandLevels), new CqnPredicate[0]);
    }

    private Predicate expandFilter(Map<Object, Long> ids) {
        List<Object> expandIdsOfLevelZero = this.getExpandIdsOfLevel(ids, 0L);
        List<Object> expandIdsOfLevelOne = this.getExpandIdsOfLevel(ids, 1L);
        List<Object> expandIdsOfLevelAll = this.getExpandIdsOfLevel(ids, -1L);
        List<Object> nodesAndDirectChildrenIds = Stream.concat(expandIdsOfLevelZero.stream(), expandIdsOfLevelOne.stream()).toList();
        Predicate expandNodesFilter = this.filterNodesOf(nodesAndDirectChildrenIds);
        Predicate expandOneLevelFilter = this.filterDirectDescendantsOf(expandIdsOfLevelOne);
        Predicate expandAllLevelsFilter = this.filterDeepDescendantsOf(expandIdsOfLevelAll);
        return CQL.or((CqnPredicate)expandNodesFilter, (CqnPredicate)CQL.or((CqnPredicate)expandOneLevelFilter, (CqnPredicate)expandAllLevelsFilter));
    }

    private List<Object> getExpandIdsOfLevel(Map<Object, Long> ids, long level) {
        return ids.entrySet().stream().filter(id -> (Long)id.getValue() == level).map(Map.Entry::getKey).toList();
    }

    private Predicate filterDeepDescendantsOf(List<Object> ids) {
        if (ids.isEmpty()) {
            return CQL.FALSE;
        }
        HierarchySubset descendants = HANA.descendants((Hierarchy)this.rootHierarchy).startWhere((CqnPredicate)CQL.get((String)this.nodeId).in(ids)).distance(Integer.MAX_VALUE, true);
        return CQL.get((String)this.nodeId).in((CqnSelect)Select.from((CqnTableFunction)descendants).columns(new String[]{this.nodeId}));
    }

    private Predicate filterDirectDescendantsOf(List<Object> expandIds) {
        return CQL.get((String)this.parentId).in(expandIds);
    }

    private Predicate filterNodesOf(List<Object> expandIds) {
        return CQL.get((String)this.nodeId).in(expandIds);
    }
}

