/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.h2;

import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.CqnTableFunction;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.Context;
import com.sap.cds.jdbc.generic.GenericDbContext;
import com.sap.cds.jdbc.h2.H2Binder;
import com.sap.cds.jdbc.h2.H2ExceptionAnalyzer;
import com.sap.cds.jdbc.h2.H2FunctionMapper;
import com.sap.cds.jdbc.h2.H2SessionVariableSetter;
import com.sap.cds.jdbc.h2.H2SqlMapping;
import com.sap.cds.jdbc.h2.H2StatementResolver;
import com.sap.cds.jdbc.h2.hierarchies.H2HierarchyFunctions;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.TableFunctionMapper;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public final class H2DbContext
extends GenericDbContext {
    public H2DbContext(DataStoreConfiguration dataStoreConfiguration) {
        super(dataStoreConfiguration);
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        return new H2FunctionMapper();
    }

    @Override
    public StatementResolver getStatementResolver() {
        return new H2StatementResolver();
    }

    @Override
    public ExceptionAnalyzer getExceptionAnalyzer() {
        return new H2ExceptionAnalyzer();
    }

    @Override
    public CdsDataStoreConnector.Capabilities getCapabilities() {
        return new CdsDataStoreConnector.Capabilities(){};
    }

    @Override
    public SessionVariableSetter getSessionVariableSetter() {
        return new H2SessionVariableSetter();
    }

    @Override
    public SqlMapping getSqlMapping(CdsStructuredType rowType) {
        return new H2SqlMapping(rowType, this.casing());
    }

    @Override
    public ValueBinder getBinder(TimeZone timeZone) {
        return new H2Binder(timeZone);
    }

    public TableFunctionMapper getTableFunctionMapper(Object context, List params, CqnTableFunction tableFunction, Map<String, ?> ctes) {
        if (H2HierarchyFunctions.handles(tableFunction)) {
            return H2HierarchyFunctions.create((Context)context, params, tableFunction, ctes);
        }
        return super.getTableFunctionMapper(context, params, tableFunction, ctes);
    }
}

