/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.h2.hierarchies;

import com.sap.cds.CqnTableFunction;
import com.sap.cds.JSONizable;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.impl.qat.CTE;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.sql.CommonTableExpression;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SelectStatementBuilder;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.TableFunctionMapper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.Source;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.TableFunction;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.hana.CqnHierarchy;
import com.sap.cds.ql.hana.CqnHierarchyGenerator;
import com.sap.cds.ql.hana.CqnHierarchySubset;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsElementBuilder;
import com.sap.cds.reflect.impl.CdsSimpleTypeBuilder;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class H2HierarchyFunctions<T extends CqnHierarchy>
implements TableFunctionMapper {
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    protected final Context context;
    protected final T hierarchyFunction;
    protected final Map<String, CommonTableExpression> ctes;
    protected final List<PreparedCqnStmt.Parameter> params;
    protected final TokenToSQLTransformer toSQL;
    protected final CdsModel model;
    private static final CdsType INT64 = CdsSimpleTypeBuilder.simpleType((CdsBaseType)CdsBaseType.INT64);
    public static final String DEFINE_FILTERED_HIERARCHY = "defineFilteredHierarchy";
    public static final String COMPUTE_DESCENDANTS_COUNT = "computeDescendantCount";
    public static final String COMPUTE_DIRECT_DESCENDANTS = "computeDirectDescendants";
    private static final String REC_ROOT_HIERARCHY = "REC_ROOT_HIERARCHY";
    private static final CqnSelectListValue HIERARCHY_PATH = CQL.plain((String)"hierarchy_path").as("hierarchy_path");
    private static final CqnSelectListValue SORT_PATH = CQL.plain((String)"sort_path").as("sort_path");
    private static final CqnSelectListValue IS_LEAF = CQL.plain((String)"is_leaf").as("is_leaf");

    private H2HierarchyFunctions(Context context, Map<String, CommonTableExpression> ctes, List<PreparedCqnStmt.Parameter> params, T hierarchy) {
        this.context = context;
        this.ctes = ctes;
        this.model = context.getCdsModel();
        this.hierarchyFunction = hierarchy;
        this.params = params;
        this.toSQL = H2HierarchyFunctions.toSQLTransformer(context, params, hierarchy.source());
    }

    private static TokenToSQLTransformer toSQLTransformer(Context context, List<PreparedCqnStmt.Parameter> params, CqnSource source) {
        if (source.isRef()) {
            CqnStructuredTypeRef ref = source.asRef();
            CdsEntity entity = CdsModelUtils.entity((CdsModel)context.getCdsModel(), (CqnStructuredTypeRef)ref);
            SqlMapping sqlMapping = context.getDbContext().getSqlMapping((CdsStructuredType)entity);
            String tableName = sqlMapping.tableName();
            return TokenToSQLTransformer.notCollating(context, (clause, r) -> Stream.of(sqlMapping.columnName(r)), entity, tableName, params);
        }
        if (source.isSelect()) {
            CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)context.getCdsModel(), (CqnSelect)source.asSelect());
            SqlMapping sqlMapping = context.getDbContext().getSqlMapping(rowType);
            return TokenToSQLTransformer.notCollating(context, (clause, r) -> Stream.of(sqlMapping.columnName(r)), source.asSelect(), rowType, params);
        }
        if (source.isTableFunction()) {
            return H2HierarchyFunctions.toSQLTransformer(context, params, source.asTableFunction().source());
        }
        throw new IllegalStateException("Unexpected source " + source);
    }

    public static TableFunctionMapper create(Context context, List<PreparedCqnStmt.Parameter> params, CqnTableFunction tableFunction, Map<String, ?> cteMap) {
        Map<String, CommonTableExpression> ctes = cteMap;
        if (tableFunction instanceof CqnHierarchyGenerator) {
            CqnHierarchyGenerator hg = (CqnHierarchyGenerator)tableFunction;
            return new Generator(context, ctes, params, hg);
        }
        if (tableFunction instanceof CqnHierarchySubset) {
            CqnHierarchySubset s = (CqnHierarchySubset)tableFunction;
            return new HierarchySubset(context, ctes, params, s);
        }
        if (tableFunction instanceof ComputeDescendantCounts) {
            ComputeDescendantCounts cdc = (ComputeDescendantCounts)tableFunction;
            return cdc.renderer(context, ctes);
        }
        if (tableFunction instanceof FilteredHierarchy) {
            FilteredHierarchy fh = (FilteredHierarchy)tableFunction;
            return fh.renderer(context, ctes);
        }
        if (tableFunction instanceof ComputeDirectDescendants) {
            ComputeDirectDescendants cdd = (ComputeDirectDescendants)tableFunction;
            return cdd.renderer(context, ctes, params);
        }
        throw new UnsupportedOperationException("Unsupported table function: " + tableFunction);
    }

    public static boolean handles(CqnTableFunction tableFunction) {
        return true;
    }

    private static void addPathElementsToQuery(SelectBuilder<?> query) {
        if (query.items().stream().noneMatch(i -> i.isValue() && i.asValue().displayName().equals("hierarchy_path"))) {
            query.addItem((Selectable)HIERARCHY_PATH);
            query.addItem((Selectable)SORT_PATH);
            query.addItem((Selectable)IS_LEAF);
        }
    }

    private static final class Generator
    extends H2HierarchyFunctions<CqnHierarchyGenerator> {
        public Generator(Context context, Map<String, CommonTableExpression> ctes, List<PreparedCqnStmt.Parameter> params, CqnHierarchyGenerator hierarchy) {
            super(context, ctes, params, hierarchy);
        }

        public String toSQL() {
            CqnSource source = ((CqnHierarchyGenerator)this.hierarchyFunction).source();
            CqnHierarchyGenerator generator = (CqnHierarchyGenerator)this.hierarchyFunction;
            TokenToSQLTransformer toSQL = H2HierarchyFunctions.toSQLTransformer(this.context, this.params, source);
            CqnSelect subquery = source.asSelect();
            CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)this.model, (CqnSelect)subquery);
            SqlMapping sqlMapping = this.context.getDbContext().getSqlMapping(rowType);
            String elementList = rowType.concreteNonAssociationElements().map(arg_0 -> ((SqlMapping)sqlMapping).columnName(arg_0)).collect(Collectors.joining(", "));
            String cteName = H2HierarchyFunctions.REC_ROOT_HIERARCHY;
            SQLStatementBuilder.SQLStatement stmt = SelectStatementBuilder.forSubquery(this.context, this.params, subquery, new ArrayDeque<QatSelectableNode>(), new HashMap<String, CTE>(), true).build();
            String siblingOrderBy = generator.orderBy().stream().map(toSQL::sortSpec).collect(Collectors.joining(", "));
            String myElementList = rowType.concreteNonAssociationElements().map(e -> "my." + sqlMapping.columnName(e)).collect(Collectors.joining(", "));
            String mySiblingOrderBy = generator.orderBy().stream().map(s -> "my." + toSQL.sortSpec((CqnSortSpecification)s)).collect(Collectors.joining(", "));
            String sql = "(WITH RECURSIVE %s (%s, hierarchy_level, hierarchy_path, sort_path, is_leaf) AS (\n   WITH SOURCE AS (\n     %s)\n   SELECT\n     %s,\n     1 AS hierarchy_level,\n     array [node_id] AS hierarchy_path,\n     array [row_number() over(order by %s)] AS sort_path,\n     NOT EXISTS (SELECT 1 FROM SOURCE sub WHERE sub.parent_id = my.node_id) AS is_leaf\n   FROM SOURCE my\n   WHERE parent_id is NULL\n\n   UNION ALL\n\n   SELECT\n     %s,\n     up.hierarchy_level + 1 as hierarchy_level,\n     up.hierarchy_path || my.node_id hierarchy_path,\n     sort_path || array [row_number() over(order by %s)] as sort_path,\n     NOT EXISTS (SELECT 1 FROM SOURCE sub WHERE sub.parent_id = my.node_id) AS is_leaf\n   FROM SOURCE my JOIN %s up ON my.parent_id = up.node_id)\n SELECT * FROM %s)\n".formatted(cteName, elementList, stmt.sql(), elementList, siblingOrderBy, myElementList, mySiblingOrderBy, H2HierarchyFunctions.REC_ROOT_HIERARCHY, cteName);
            return new SQLStatementBuilder.SQLStatement(sql, this.params).sql();
        }
    }

    static final class HierarchySubset
    extends H2HierarchyFunctions<CqnHierarchySubset> {
        public HierarchySubset(Context context, Map<String, CommonTableExpression> ctes, List<PreparedCqnStmt.Parameter> params, CqnHierarchySubset hierarchyNavigation) {
            super(context, ctes, params, hierarchyNavigation);
        }

        public String toSQL() {
            boolean keepStart;
            StringBuilder sql = new StringBuilder();
            CqnSource source = ((CqnHierarchySubset)this.hierarchyFunction).source();
            CqnHierarchySubset hSubset = (CqnHierarchySubset)this.hierarchyFunction;
            source = source.asTableFunction().source();
            CqnSelect subquery = source.asSelect();
            String elementList = "NODE_ID, PARENT_ID";
            String cteName = ((CqnHierarchySubset)this.hierarchyFunction).name();
            sql.append(H2HierarchyFunctions.LPAREN);
            sql.append("WITH RECURSIVE ");
            sql.append(cteName);
            sql.append(H2HierarchyFunctions.LPAREN);
            sql.append(elementList);
            sql.append(H2HierarchyFunctions.RPAREN);
            sql.append(" AS ");
            sql.append(H2HierarchyFunctions.LPAREN);
            sql.append("WITH SOURCE AS ");
            sql.append(H2HierarchyFunctions.LPAREN);
            CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)this.model, (CqnSelect)subquery);
            this.ctes.putIfAbsent(cteName, new CommonTableExpression(this.context, cteName, (CqnSource)source.asSelect(), rowType));
            SQLStatementBuilder.SQLStatement stmt = SelectStatementBuilder.forSubquery(this.context, this.params, subquery, new ArrayDeque<QatSelectableNode>(), new HashMap<String, CTE>(), true).build();
            sql.append(stmt.sql());
            sql.append(") SELECT ");
            sql.append(elementList);
            hSubset.startWhere().ifPresent(w -> {
                sql.append(" FROM SOURCE WHERE ");
                String startWhere = this.toSQL.toSQL((CqnPredicate)w);
                sql.append(startWhere);
            });
            sql.append(" UNION ALL ");
            String prefixedElementList = "my.\"NODE_ID\", my.\"PARENT_ID\"";
            String mappingDirection = "my.node_id = other.parent_id";
            boolean bl = keepStart = hSubset.to() == 0;
            if (hSubset.isDescendants()) {
                mappingDirection = "my.parent_id = other.node_id";
                keepStart = hSubset.from() == 0;
            }
            sql.append(" SELECT " + prefixedElementList + "FROM SOURCE my JOIN " + cteName + " other ON " + mappingDirection + " )  SELECT " + elementList + " FROM " + cteName + (keepStart ? "" : " OFFSET 1") + H2HierarchyFunctions.RPAREN);
            return new SQLStatementBuilder.SQLStatement(sql.toString(), this.params).sql();
        }
    }

    static final class ComputeDescendantCounts
    extends AbstractTableFunction {
        private final String filteredCte;
        private final String unlimitedElement;
        private final String limitedCte;
        private final String limitedElement;

        public ComputeDescendantCounts(Source<?> source, String filteredCte, String unlimitedElement, String limitedCte, String limitedElement) {
            super(H2HierarchyFunctions.COMPUTE_DESCENDANTS_COUNT, source);
            this.filteredCte = filteredCte;
            this.unlimitedElement = unlimitedElement;
            this.limitedCte = limitedCte;
            this.limitedElement = limitedElement;
        }

        @Override
        public CdsStructuredType rowType(CdsStructuredType sourceRowType) {
            CdsElementDefinition unlimited = CdsElementBuilder.element((String)this.unlimitedElement).type(INT64).isNotNull(true).build();
            CdsElementDefinition limited = CdsElementBuilder.element((String)this.limitedElement).type(INT64).isNotNull(true).build();
            return CqnStatementUtils.addElementsTo((CdsStructuredType)sourceRowType, (CdsElementDefinition[])new CdsElementDefinition[]{unlimited, limited});
        }

        public TableFunction copy(Source<?> newSource) {
            return new ComputeDescendantCounts(newSource, this.filteredCte, this.unlimitedElement, this.limitedCte, this.limitedElement);
        }

        TableFunctionMapper renderer(Context context, Map<String, CommonTableExpression> ctes) {
            return () -> {
                SelectBuilder subquery = (SelectBuilder)this.source.asSelect();
                H2HierarchyFunctions.addPathElementsToQuery(subquery);
                CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)context.getCdsModel(), (CqnSelect)subquery);
                ctes.putIfAbsent(this.limitedCte, new CommonTableExpression(context, this.limitedCte, (CqnSource)this.source.asSelect(), rowType));
                return "(SELECT *,\n         %s,\n         %s\n FROM %s LH)\n".formatted(this.descendantCount(this.filteredCte, this.unlimitedElement), this.descendantCount(this.limitedCte, this.limitedElement), this.limitedCte);
            };
        }

        private String descendantCount(String cteName, String elAlias) {
            return "CASE WHEN is_leaf THEN 0 ELSE (SELECT count(*) - 1 FROM %s sub WHERE array_slice(sub.hierarchy_path, 1, LH.hierarchy_level) = LH.hierarchy_path) END as %s".formatted(cteName, elAlias);
        }

        @Override
        public Optional<String> cteName() {
            return Optional.ofNullable(this.limitedCte);
        }
    }

    static final class FilteredHierarchy
    extends AbstractTableFunction {
        public FilteredHierarchy(Source<?> source, String filteredCte) {
            super(filteredCte, source);
        }

        @Override
        public void accept(CqnVisitor visitor) {
        }

        public TableFunction copy(Source<?> newSource) {
            return new FilteredHierarchy(newSource, this.name);
        }

        TableFunctionMapper renderer(Context context, Map<String, CommonTableExpression> ctes) {
            return () -> {
                SelectBuilder subquery = (SelectBuilder)this.source.asSelect();
                H2HierarchyFunctions.addPathElementsToQuery(subquery);
                CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)context.getCdsModel(), (CqnSelect)subquery);
                ctes.putIfAbsent(this.name, new CommonTableExpression(context, this.name, (CqnSource)this.source.asSelect(), rowType));
                return this.name;
            };
        }
    }

    static final class ComputeDirectDescendants
    extends AbstractTableFunction {
        private static final String DIRECT_DESCENDANTS = "DIRECT_DESCENDANTS";
        private CqnPredicate startWhere;
        private final CdsModel model;

        public ComputeDirectDescendants(CdsModel model, Source<?> source, CqnPredicate start) {
            super(DIRECT_DESCENDANTS, source);
            this.startWhere = start;
            this.model = model;
        }

        @Override
        public CdsStructuredType rowType(CdsStructuredType sourceRowType) {
            CdsElementDefinition element = CdsElementBuilder.element((String)"DescendantCount").type(INT64).isNotNull(true).build();
            return CqnStatementUtils.addElementsTo((CdsStructuredType)sourceRowType, (CdsElementDefinition[])new CdsElementDefinition[]{element});
        }

        public TableFunction copy(Source<?> newSource) {
            return new ComputeDirectDescendants(this.model, newSource, this.startWhere);
        }

        TableFunctionMapper renderer(Context context, Map<String, CommonTableExpression> ctes, List<PreparedCqnStmt.Parameter> params) {
            return () -> {
                CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)this.model, (CqnSelect)this.source.asSelect());
                ctes.putIfAbsent(DIRECT_DESCENDANTS, new CommonTableExpression(context, DIRECT_DESCENDANTS, (CqnSource)this.source.asSelect(), rowType));
                TokenToSQLTransformer token2SQL = H2HierarchyFunctions.toSQLTransformer(context, params, (CqnSource)this.source.asSelect());
                return "(WITH START_NODES AS (\n            SELECT NODE_ID FROM ROOT_HIERARCHY WHERE %s),\n       DIRECT_DESCENDANTS_INNER AS (\n            SELECT * FROM DIRECT_DESCENDANTS WHERE parent_id IN (SELECT NODE_ID FROM START_NODES))\nSELECT *,\n    (SELECT COUNT(*) FROM ROOT_HIERARCHY WHERE PARENT_ID = DD.NODE_ID) AS %s\nFROM DIRECT_DESCENDANTS_INNER DD)\n".formatted(token2SQL.toSQL(this.startWhere), "DescendantCount");
            };
        }
    }

    private static abstract class AbstractTableFunction
    implements TableFunction {
        protected final String name;
        protected final Source<?> source;

        AbstractTableFunction(String name, Source<?> source) {
            this.name = name;
            this.source = source;
        }

        public String name() {
            return this.name;
        }

        public CqnSource source() {
            return this.source;
        }

        public StructuredType<?> getType() {
            return this.source.getType();
        }

        public CdsStructuredType rowType(CdsStructuredType sourceRowType) {
            return sourceRowType;
        }

        public void accept(CqnVisitor visitor) {
        }

        public String toJson() {
            Jsonizer cqn = Jsonizer.object((String)"source", this.source);
            return Jsonizer.object((String)this.name(), (JSONizable)cqn).toJson();
        }

        public Optional<String> cteName() {
            return Optional.of(this.name);
        }
    }
}

