/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.h2.hierarchies;

import com.sap.cds.CqnTableFunction;
import com.sap.cds.impl.builder.model.InSubquery;
import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.jdbc.generic.hierarchies.GenericHierarchyResolver;
import com.sap.cds.jdbc.h2.hierarchies.H2HierarchyFunctions;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.Source;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnEntitySelector;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.transformation.CqnAncestorsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnDescendantsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnFilterTransformation;
import com.sap.cds.ql.cqn.transformation.CqnHierarchySubsetTransformation;
import com.sap.cds.ql.cqn.transformation.CqnSearchTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTopLevelsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTransformationVisitor;
import com.sap.cds.ql.hana.HANA;
import com.sap.cds.ql.hana.Hierarchy;
import com.sap.cds.ql.hana.HierarchySubset;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.transformations.HierarchyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class H2HierarchyResolver
extends GenericHierarchyResolver {
    private static final Literal<Number> ZERO = CQL.constant((Object)0);
    private static final Literal<Number> ONE = CQL.constant((Object)1);
    private static final String PARENT_ID = "parent_id";
    private static final String NODE_ID = "node_id";
    private static final String HIERARCHY_TREE_SIZE = "hierarchy_tree_size";
    private static final String HIERARCHY_RANK = "hierarchy_rank";
    private SiblingOrderBy siblingOrderBy = new SiblingOrderBy();

    public H2HierarchyResolver(CdsModel model, Select<?> select) {
        super(model, select);
    }

    @Override
    protected void before(CqnSelect original) {
        super.before(original);
        if (this.isHierarchicalSelect) {
            CdsStructuredType sourceRowType = CqnStatementUtils.rowType((CdsModel)this.model, (CqnSelect)this.select);
            this.select.excluding((Collection)COMPUTED_ELEMENTS);
            Select hierarchySource = HierarchyUtils.addNodeAndParentElements((CdsModel)this.model, (Select)this.select, (List)original.transformations());
            this.rootHierarchy = HANA.hierarchy((Source)hierarchySource).orderBy((Supplier)this.siblingOrderBy).asCte("ROOT_HIERARCHY");
            this.select = (Select)Select.from((CqnTableFunction)this.rootHierarchy).columns(new Selectable[]{CQL.star(), H2HierarchyResolver.distanceFromRoot()}).excluding(new String[]{HIERARCHY_TREE_SIZE, HIERARCHY_RANK}).hints(original.hints());
            this.nodeId = H2HierarchyResolver.findCaseInsensitive(sourceRowType, NODE_ID);
            this.parentId = H2HierarchyResolver.findCaseInsensitive(sourceRowType, PARENT_ID);
            CdsEntity targetEntity = (CdsEntity)CqnStatementUtils.rowType((CdsModel)this.model, (CqnSource)original.from());
            this.applyDefaultOrder(targetEntity);
        }
    }

    @Override
    protected void copySelectList(List<CqnSelectListItem> slis) {
        if (!this.isHierarchicalSelect) {
            super.copySelectList(slis);
        }
        ArrayList<CqnSelectListItem> all = new ArrayList<CqnSelectListItem>(this.select.items());
        List<CqnSelectListItem> expands = slis.stream().filter(sli -> sli.isExpand()).toList();
        all.addAll(expands);
        this.select.columns(all);
    }

    private void applyDefaultOrder(CdsEntity target) {
        this.siblingOrderBy.orderBy((ElementRef<Object>)CQL.get((String)NODE_ID));
        target.query().map(CqnEntitySelector::orderBy).ifPresent(this.siblingOrderBy::orderBy);
    }

    private static String findCaseInsensitive(CdsStructuredType type, String name) {
        return type.elements().map(CdsElementDefinition::getName).filter(name::equalsIgnoreCase).findFirst().orElse(name);
    }

    protected void applyTopLevels(CqnTopLevelsTransformation topLevels) {
        this.siblingOrderBy.orderBy(this.stashOrderBy());
        this.defineFilteredHierarchy();
        CqnPredicate f = this.limiter(topLevels.levels(), topLevels.expandLevels());
        this.applyFilter(() -> f);
        this.computeDescendantsCountsAndDrillState();
    }

    private void defineFilteredHierarchy() {
        H2HierarchyFunctions.FilteredHierarchy func = new H2HierarchyFunctions.FilteredHierarchy((Source<?>)this.select, "FILTERED_HIERARCHY");
        this.select = Select.from((CqnTableFunction)func);
    }

    private void computeDescendantsCountsAndDrillState() {
        H2HierarchyFunctions.ComputeDescendantCounts func = new H2HierarchyFunctions.ComputeDescendantCounts((Source<?>)this.select, "FILTERED_HIERARCHY", "DescendantCount", "LIMITED_HIERARCHY", "LimitedDescendantCount");
        this.select = Select.from((CqnTableFunction)func);
        this.applyCompute(() -> List.of(this.drillState(), H2HierarchyResolver.limitedRank()));
        this.select.orderBy(new CqnSortSpecification[]{CQL.plain((String)"sort_path").asc()});
    }

    private static CqnSelectListValue distanceFromRoot() {
        return CQL.get((String)"hierarchy_level").minus(ONE).as("DistanceFromRoot");
    }

    private static CqnSelectListValue limitedRank() {
        return CQL.func((String)"row_number", (CqnValue[])new CqnValue[0]).over().orderBy(new CqnSortSpecification[]{CQL.plain((String)"sort_path").asc()}).minus(ONE).type(CdsBaseType.INT64).as("LimitedRank");
    }

    private CqnSelectListValue drillState() {
        Predicate isLeaf = ExpressionBuilder.create((CqnToken[])new CqnToken[]{CQL.plain((String)"is_leaf")}).predicate();
        Predicate noDescUnlimited = DESCENDANT_COUNT_REF.eq(ZERO);
        Predicate noDescLimited = LIMITED_DESCENDANT_COUNT_REF.eq(ZERO);
        Value drillState = CQL.when((CqnPredicate)isLeaf).then((CqnValue)LEAF).when((CqnPredicate)noDescUnlimited).then((CqnValue)LEAF).when((CqnPredicate)noDescLimited).then((CqnValue)COLLAPSED).orElse((CqnValue)EXPANDED);
        return drillState.type(CdsBaseType.STRING).as("DrillState");
    }

    protected void applyAncestors(CqnAncestorsTransformation transformation) {
        this.subSet((CqnHierarchySubsetTransformation)transformation, HANA::ancestors);
    }

    protected void applyDescendants(CqnDescendantsTransformation transformation) {
        this.checkDescendantsInput(transformation);
        CqnPredicate startWhere = this.startWhere((CqnHierarchySubsetTransformation)transformation);
        H2HierarchyFunctions.ComputeDirectDescendants directDescendants = new H2HierarchyFunctions.ComputeDirectDescendants(this.model, (Source<?>)this.select, startWhere);
        this.select = Select.from((CqnTableFunction)directDescendants);
        CqnSelectListValue drillState = CQL.when((CqnPredicate)CQL.get((String)"DescendantCount").gt(ZERO)).then((CqnValue)COLLAPSED).orElse((CqnValue)LEAF).type(CdsBaseType.STRING).as("DrillState");
        this.applyCompute(() -> List.of(drillState));
    }

    private List<CqnSortSpecification> stashOrderBy() {
        List<CqnSortSpecification> sob = List.copyOf(this.select.orderBy());
        this.select.orderBy(List.of());
        return sob;
    }

    private void subSet(CqnHierarchySubsetTransformation subsetTrafo, Function<Hierarchy, HierarchySubset> factory) {
        CqnPredicate startWhere = this.startWhere(subsetTrafo);
        if (subsetTrafo.keepStart() && startWhere == CQL.TRUE) {
            return;
        }
        HierarchySubset subset = factory.apply(this.rootHierarchy);
        subset.distance(subsetTrafo.distanceFromStart(), subsetTrafo.keepStart());
        subset.startWhere(startWhere);
        CqnSelect subquery = (CqnSelect)Select.from((CqnTableFunction)subset).columns(new String[]{this.nodeId}).distinct().hints(this.select.hints());
        List<CqnSortSpecification> sob = this.stashOrderBy();
        this.applyFilter(() -> InSubquery.in((CqnValue)CQL.get((String)this.nodeId), (CqnSelect)subquery));
        if (subset.isDescendants()) {
            this.select.orderBy(sob);
        }
    }

    private CqnPredicate startWhere(CqnHierarchySubsetTransformation subsetTrafo) {
        TrafoPredicatedVisitor v = new TrafoPredicatedVisitor();
        subsetTrafo.transformations().forEach(t -> t.accept((CqnTransformationVisitor)v));
        return v.predicate;
    }

    private static class SiblingOrderBy
    implements Supplier<List<CqnSortSpecification>> {
        LinkedList<CqnSortSpecification> sortSpecs = new LinkedList();

        private SiblingOrderBy() {
        }

        @Override
        public List<CqnSortSpecification> get() {
            return this.sortSpecs;
        }

        public void orderBy(List<CqnSortSpecification> specs) {
            this.sortSpecs.addAll(0, specs);
        }

        public void orderBy(ElementRef<Object> ref) {
            this.orderBy(ref.asc());
        }

        public void orderBy(CqnSortSpecification sortSpec) {
            this.orderBy(List.of(sortSpec));
        }
    }

    private static class TrafoPredicatedVisitor
    implements CqnTransformationVisitor {
        CqnPredicate predicate = CQL.TRUE;

        private TrafoPredicatedVisitor() {
        }

        public void visit(CqnFilterTransformation filter) {
            this.predicate = CQL.and((CqnPredicate)this.predicate, (CqnPredicate)filter.filter());
        }

        public void visit(CqnSearchTransformation search) {
            this.predicate = CQL.and((CqnPredicate)this.predicate, (CqnPredicate)search.search());
        }
    }
}

