/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.hierarchies;

import com.sap.cds.CqnTableFunction;
import com.sap.cds.impl.builder.model.InSubquery;
import com.sap.cds.jdbc.generic.hierarchies.GenericHierarchyResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.Source;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.transformation.CqnAncestorsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnDescendantsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnFilterTransformation;
import com.sap.cds.ql.cqn.transformation.CqnHierarchySubsetTransformation;
import com.sap.cds.ql.cqn.transformation.CqnSearchTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTopLevelsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTransformationVisitor;
import com.sap.cds.ql.hana.HANA;
import com.sap.cds.ql.hana.Hierarchy;
import com.sap.cds.ql.hana.HierarchySubset;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.transformations.HierarchyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;

public class HanaHierarchyResolver
extends GenericHierarchyResolver {
    private static final Literal<Number> ZERO = CQL.constant((Object)0);
    private static final Literal<Number> ONE = CQL.constant((Object)1);
    private static final String PARENT_ID = "parent_id";
    private static final String NODE_ID = "node_id";
    private static final String HIERARCHY_TREE_SIZE = "hierarchy_tree_size";
    private static final String HIERARCHY_LEVEL = "hierarchy_level";
    private static final String HIERARCHY_RANK = "hierarchy_rank";
    private List<CqnTransformation> transformations;
    private boolean filtered;

    public HanaHierarchyResolver(CdsModel model, Select<?> select) {
        super(model, select);
    }

    @Override
    protected void before(CqnSelect original) {
        super.before(original);
        if (this.isHierarchicalSelect) {
            CdsStructuredType sourceRowType = CqnStatementUtils.rowType((CdsModel)this.model, (CqnSelect)this.select);
            this.select.excluding((Collection)COMPUTED_ELEMENTS);
            this.transformations = original.transformations();
            Select hierarchySource = HierarchyUtils.addNodeAndParentElements((CdsModel)this.model, (Select)this.select, this.transformations);
            this.rootHierarchy = HANA.hierarchy((Source)hierarchySource).orderBy(new CqnSortSpecification[]{CQL.get((String)NODE_ID).asc()}).asCte("ROOT_HIERARCHY");
            this.select = (Select)Select.from((CqnTableFunction)this.rootHierarchy).columns(new Selectable[]{CQL.star(), HanaHierarchyResolver.descendantCount(), HanaHierarchyResolver.distanceFromRoot(), HanaHierarchyResolver.rank()}).excluding(new String[]{HIERARCHY_TREE_SIZE, HIERARCHY_LEVEL, HIERARCHY_RANK}).hints(original.hints());
            this.nodeId = HanaHierarchyResolver.findCaseInsensitive(sourceRowType, NODE_ID);
            this.parentId = HanaHierarchyResolver.findCaseInsensitive(sourceRowType, PARENT_ID);
            CdsEntity targetEntity = (CdsEntity)CqnStatementUtils.rowType((CdsModel)this.model, (CqnSource)original.from());
            this.applyDefaultOrder(targetEntity);
        }
    }

    private void applyDefaultOrder(CdsEntity target) {
        this.applyOrderBy(() -> List.of(CQL.get((String)this.nodeId).asc()));
        target.query().ifPresent(q -> this.applyOrderBy(() -> q.orderBy()));
    }

    private static String findCaseInsensitive(CdsStructuredType type, String name) {
        return type.elements().map(CdsElementDefinition::getName).filter(name::equalsIgnoreCase).findFirst().orElse(name);
    }

    protected void after() {
        if (this.isHierarchicalSelect) {
            ListIterator<CqnTransformation> iter = this.transformations.listIterator(this.transformations.size());
            while (iter.hasPrevious()) {
                CqnTransformation cqnTransformation = iter.previous();
                if (!(cqnTransformation instanceof CqnDescendantsTransformation)) continue;
                CqnDescendantsTransformation d = (CqnDescendantsTransformation)cqnTransformation;
                HanaHierarchyResolver.addDescendantsDrillState((SelectBuilder)this.select, d);
                break;
            }
        }
    }

    protected void applyTopLevels(CqnTopLevelsTransformation topLevels) {
        if (this.filtered) {
            List<CqnSortSpecification> sob = this.stashOrderBy();
            Hierarchy hierarchy = HANA.hierarchy((Source)this.select.excluding(new String[]{HIERARCHY_TREE_SIZE, HIERARCHY_LEVEL, HIERARCHY_RANK, "DescendantCount"})).asCte("FILTERED_HIERARCHY");
            hierarchy.orderBy(sob);
            this.select = Select.from((CqnTableFunction)hierarchy).columns(new Selectable[]{CQL.star(), HanaHierarchyResolver.descendantCount()}).excluding(new String[]{HIERARCHY_TREE_SIZE, HIERARCHY_LEVEL, HIERARCHY_RANK});
        }
        CqnPredicate f = this.limiter(topLevels.levels(), topLevels.expandLevels());
        List<CqnSortSpecification> siblingOrderBy = this.stashOrderBy();
        this.applyFilter(() -> f);
        Hierarchy hierarchy = HANA.hierarchy((Source)this.select).orderBy(siblingOrderBy).asCte("LIMITED_HIERARCHY");
        this.select = Select.from((CqnTableFunction)hierarchy).columns(this.computeVirtual(this.originalItems));
    }

    private List<CqnSelectListItem> computeVirtual(List<CqnSelectListItem> slis) {
        if (slis.isEmpty()) {
            ArrayList<CqnSelectListItem> selectList = new ArrayList<CqnSelectListItem>(3);
            selectList.add((CqnSelectListItem)CQL.star());
            selectList.add((CqnSelectListItem)HanaHierarchyResolver.limitedDescendantCount());
            selectList.add(this.drillState());
            return selectList;
        }
        return slis.stream().map(this::computeVirtual).toList();
    }

    private CqnSelectListItem computeVirtual(CqnSelectListItem sli) {
        if (sli.isRef()) {
            String path;
            return switch (path = sli.asRef().path()) {
                case "LimitedDescendantCount" -> HanaHierarchyResolver.limitedDescendantCount();
                case "LimitedRank" -> HanaHierarchyResolver.limitedRank();
                case "DrillState" -> this.drillState();
                default -> sli;
            };
        }
        return sli;
    }

    private static CqnSelectListValue distanceFromRoot() {
        return CQL.get((String)HIERARCHY_LEVEL).minus(ONE).as("DistanceFromRoot");
    }

    private static CqnSelectListValue descendantCount() {
        return CQL.get((String)HIERARCHY_TREE_SIZE).minus(ONE).as("DescendantCount");
    }

    private static CqnSelectListValue limitedDescendantCount() {
        return HanaHierarchyResolver.limitedDescendantCountVal().as("LimitedDescendantCount");
    }

    private static Value<Number> limitedDescendantCountVal() {
        return CQL.get((String)HIERARCHY_TREE_SIZE).minus(ONE);
    }

    private static CqnSelectListValue rank() {
        return CQL.get((String)HIERARCHY_RANK).minus(ONE).as("Rank");
    }

    private static CqnSelectListValue limitedRank() {
        return CQL.get((String)HIERARCHY_RANK).minus(ONE).as("LimitedRank");
    }

    private CqnSelectListItem drillState() {
        Predicate noDescUnlimited = DESCENDANT_COUNT_REF.eq(ZERO);
        Predicate noDescLimited = HanaHierarchyResolver.limitedDescendantCountVal().eq(ZERO);
        Value drillState = CQL.when((CqnPredicate)noDescUnlimited).then((CqnValue)LEAF).when((CqnPredicate)noDescLimited).then((CqnValue)COLLAPSED).orElse((CqnValue)EXPANDED);
        return drillState.type(CdsBaseType.STRING).as("DrillState");
    }

    private static void addDescendantsDrillState(SelectBuilder<?> select, CqnDescendantsTransformation d) {
        int v = d.distanceFromStart();
        if (v > 1 || d.keepStart()) {
            return;
        }
        CqnSelectListValue drillState = CQL.when((CqnPredicate)CQL.get((String)HIERARCHY_TREE_SIZE).gt(ONE)).then((CqnValue)COLLAPSED).orElse((CqnValue)LEAF).type(CdsBaseType.STRING).as("DrillState");
        select.addItem((Selectable)drillState);
    }

    protected void applyAncestors(CqnAncestorsTransformation transformation) {
        this.subSet((CqnHierarchySubsetTransformation)transformation, HANA::ancestors);
    }

    protected void applyDescendants(CqnDescendantsTransformation transformation) {
        this.checkDescendantsInput(transformation);
        this.subSet((CqnHierarchySubsetTransformation)transformation, HANA::descendants);
    }

    private List<CqnSortSpecification> stashOrderBy() {
        List<CqnSortSpecification> sob = List.copyOf(this.select.orderBy());
        this.select.orderBy(List.of());
        return sob;
    }

    private void subSet(CqnHierarchySubsetTransformation subsetTrafo, Function<Hierarchy, HierarchySubset> factory) {
        TrafoPredicatedVisitor v = new TrafoPredicatedVisitor();
        subsetTrafo.transformations().forEach(t -> t.accept((CqnTransformationVisitor)v));
        CqnPredicate startWhere = v.predicate;
        if (subsetTrafo.keepStart() && startWhere == CQL.TRUE) {
            return;
        }
        HierarchySubset subset = factory.apply(this.rootHierarchy);
        subset.distance(subsetTrafo.distanceFromStart(), subsetTrafo.keepStart());
        subset.startWhere(startWhere);
        CqnSelect subquery = (CqnSelect)Select.from((CqnTableFunction)subset).columns(new String[]{this.nodeId}).distinct().hints(this.select.hints());
        List<CqnSortSpecification> sob = this.stashOrderBy();
        this.applyFilter(() -> InSubquery.in((CqnValue)CQL.get((String)this.nodeId), (CqnSelect)subquery));
        if (subset.isAncestors() && startWhere != CQL.TRUE) {
            this.filtered = true;
        }
        if (subset.isDescendants()) {
            this.select.orderBy(sob);
        }
    }

    private static class TrafoPredicatedVisitor
    implements CqnTransformationVisitor {
        CqnPredicate predicate = CQL.TRUE;

        private TrafoPredicatedVisitor() {
        }

        public void visit(CqnFilterTransformation filter) {
            this.predicate = CQL.and((CqnPredicate)this.predicate, (CqnPredicate)filter.filter());
        }

        public void visit(CqnSearchTransformation search) {
            this.predicate = CQL.and((CqnPredicate)this.predicate, (CqnPredicate)search.search());
        }
    }
}

