/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.collect.Sets;
import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.impl.CqnValidator;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.draft.DraftUtils;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CqnValidatorImpl
implements CqnValidator {
    private final DocStoreUtils docStoreUtils;
    private final boolean supportsParamViews;

    public CqnValidatorImpl(CdsModel cdsModel, CdsDataStoreConnector.Capabilities capabilities) {
        this.docStoreUtils = new DocStoreUtils(cdsModel);
        this.supportsParamViews = capabilities.supportsViewsWithParameters();
    }

    @Override
    public void validate(CqnSelect query, CdsEntity entity) {
        if (!this.supportsParamViews && entity != null && query.from().isRef() && entity.isView() && entity.params().count() > 0L) {
            throw new UnsupportedOperationException("Parametrized views are not supported by this data store");
        }
    }

    @Override
    public void validate(CqnInsert insert, CdsEntity entity) {
        if (this.docStoreUtils.targetsDocStore((CqnStatement)insert)) {
            return;
        }
        this.validateElements(entity, insert.elements((CdsStructuredType)entity));
    }

    @Override
    public void validate(CqnUpdate update, CdsEntity entity) {
        if (this.docStoreUtils.targetsDocStore((CqnStatement)update)) {
            this.assertThatAllEntriesHaveSameStructure(update, entity);
            return;
        }
        this.validateElements(entity, update.elements((CdsStructuredType)entity));
        update.where().ifPresent(w -> w.accept((CqnVisitor)new VirtualElementValidator((CdsStructuredType)entity)));
    }

    @Override
    public void validate(CqnUpsert upsert, CdsEntity entity) {
        Sets.SetView missingKeys;
        List<String> paths;
        Set upsertElements;
        Set keyNames = CdsModelUtils.concreteKeyNames((CdsStructuredType)entity);
        if (DraftUtils.isDraftEnabled((CdsStructuredType)entity) && !DraftUtils.isDraftView((CdsStructuredType)entity)) {
            keyNames.remove("IsActiveEntity");
        }
        if (!(upsertElements = upsert.elements((CdsStructuredType)entity).collect(Collectors.toSet())).containsAll(keyNames) && !upsertElements.containsAll(paths = (missingKeys = Sets.difference((Set)keyNames, upsertElements)).stream().map(k -> k.replace('_', '.')).toList())) {
            throw new CdsDataException("Missing key value for " + (Set)missingKeys);
        }
    }

    private void assertThatAllEntriesHaveSameStructure(CqnUpdate update, CdsEntity entity) {
        Set elements = update.data().keySet();
        if (!update.entries().stream().allMatch(e -> e.keySet().equals(elements))) {
            String allElements = update.elements((CdsStructuredType)entity).collect(Collectors.joining(", ", "[", "]"));
            throw new UnsupportedOperationException("Each bulk update entry must contain values for the same elements " + allElements);
        }
    }

    private void validateElements(CdsEntity entity, Stream<String> usedElements) {
        if (entity.findAnnotation("open").isEmpty()) {
            usedElements.forEach(element -> {
                String rootElement;
                int firstDot = element.indexOf(46);
                String string = rootElement = firstDot == -1 ? element : element.substring(0, firstDot);
                if (entity.findElement(element).isEmpty() && entity.findElement(rootElement).isEmpty()) {
                    throw new CqnValidationException("Element '" + element + "' does not exist in entity '" + entity.getQualifiedName() + "'");
                }
            });
        }
    }

    @Override
    public void validate(CqnDelete delete, CdsEntity entity) {
        delete.where().ifPresent(w -> w.accept((CqnVisitor)new VirtualElementValidator((CdsStructuredType)entity)));
    }

    public static RuntimeException virtualElementException(String element) {
        return new CqnValidationException("Virtual element '%s' is not allowed in filter conditions".formatted(element));
    }

    private class VirtualElementValidator
    implements CqnVisitor {
        private CdsStructuredType root;

        public VirtualElementValidator(CdsStructuredType rowType) {
            this.root = rowType;
        }

        public void visit(CqnElementRef ref) {
            if ("$key".equals(ref.lastSegment()) || CdsModelUtils.isEtagPlaceholder((CqnElementRef)ref) || CdsModelUtils.isContextElementRef((CqnElementRef)ref)) {
                return;
            }
            if (CdsModelUtils.element((CdsStructuredType)this.root, (CqnElementRef)ref).isVirtual()) {
                throw CqnValidatorImpl.virtualElementException(ref.displayName());
            }
        }
    }
}

