/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql.collate;

import com.sap.cds.SessionContext;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.sql.collate.Collator;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Locale;
import java.util.Optional;

public class Collating {
    public static final Collator OFF = new Collator(){};
    private final SessionContext sessionContext;
    private final StatementResolver statementResolver;
    private final LocaleUtils localeUtils;
    private final Locale locale;

    public Collating(Context context) {
        this.sessionContext = context.getSessionContext();
        this.statementResolver = context.getDbContext().getStatementResolver();
        this.localeUtils = new LocaleUtils(context.getCdsModel(), context.getDataStoreConfiguration());
        this.locale = this.sessionContext.getLocale();
    }

    public Collator collatorFor(CqnSelect select, CdsStructuredType targetEntity) {
        if (this.locale == null || Collating.hasCollatingOffHint(select)) {
            return OFF;
        }
        return this.statementResolver.supportsStatementWideCollation() && this.localeUtils.requiresCollationClause(select, this.locale) ? new StatementWide(select) : new Collate(targetEntity);
    }

    private static boolean hasCollatingOffHint(CqnSelect select) {
        return "off".equals(select.hints().get("collating"));
    }

    private class StatementWide
    implements Collator {
        private final CqnSelect select;

        private StatementWide(CqnSelect select) {
            this.select = select;
        }

        @Override
        public Optional<String> withCollation() {
            return Collating.this.statementResolver.statementWideCollation(this.select, Collating.this.locale);
        }
    }

    private class Collate
    implements Collator {
        private final CdsStructuredType targetEntity;

        private Collate(CdsStructuredType targetEntity) {
            this.targetEntity = targetEntity;
        }

        @Override
        public Optional<String> collate(CqnSortSpecification o) {
            if (this.requiresCollate(o.value())) {
                return Collating.this.statementResolver.collate(o, Collating.this.sessionContext.getLocale());
            }
            return Optional.empty();
        }

        @Override
        public boolean usesCollate() {
            return true;
        }

        private boolean requiresCollate(CqnValue value) {
            if (this.targetEntity == null) {
                return false;
            }
            if (value.isRef()) {
                return Collating.this.localeUtils.requiresCollate(this.targetEntity, value.asRef());
            }
            return CqnStatementUtils.getCdsType((CdsStructuredType)this.targetEntity, (CqnValue)value).filter(t -> CdsBaseType.STRING == t).isPresent();
        }
    }
}

