/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.generic.UnfoldIsOperatorModifier;
import com.sap.cds.jdbc.spi.ScalarValueResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnBooleanLiteral;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnTemporalLiteral;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.Temporal;

public class GenericScalarValueResolver
implements ScalarValueResolver {
    private static final String SQL_TRUE = "TRUE";
    private static final String SQL_FALSE = "FALSE";

    public String literal(CqnBooleanLiteral bool) {
        return Boolean.TRUE.equals(bool.value()) ? SQL_TRUE : SQL_FALSE;
    }

    public String literal(CqnTemporalLiteral<?> literal) {
        String result;
        if (literal == null) {
            return "NULL";
        }
        Object object = literal.value();
        if (object instanceof Instant) {
            Instant i = (Instant)object;
            result = "TIMESTAMP %s".formatted(SQLHelper.literal(Timestamp.from(i).toString()));
        } else {
            object = literal.value();
            if (object instanceof LocalDate) {
                LocalDate localDate = (LocalDate)object;
                result = "DATE %s".formatted(SQLHelper.literal(localDate.toString()));
            } else {
                object = literal.value();
                if (object instanceof LocalTime) {
                    LocalTime localTime = (LocalTime)object;
                    result = "TIME %s".formatted(SQLHelper.literal(localTime.toString()));
                } else {
                    result = SQLHelper.literal(((Temporal)literal.value()).toString());
                }
            }
        }
        return result;
    }

    public CqnValue selectListValue(CqnValue value) {
        if (!value.isLiteral() && value instanceof CqnPredicate) {
            CqnPredicate p = (CqnPredicate)value;
            value = CQL.copy((CqnPredicate)p, (Modifier)new UnfoldIsOperatorModifier());
        }
        return value;
    }
}

