/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.postgresql;

import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.jdbc.spi.PredicateMapper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;

public class PostgreSqlPredicateMapper
implements PredicateMapper {
    private static final CqnPlain IS_NOT_DISTINCT_FROM = CqnPlainImpl.plain((String)"is not distinct from");
    private static final CqnPlain IS_DISTINCT_FROM = CqnPlainImpl.plain((String)"is distinct from");

    public CqnPredicate apply(CqnPredicate pred) {
        Modifier m = new Modifier(){

            public CqnPredicate comparison(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
                if (!rhs.isNullValue()) {
                    if (op == CqnComparisonPredicate.Operator.IS) {
                        return ExpressionBuilder.create((CqnToken[])new CqnToken[]{lhs, IS_NOT_DISTINCT_FROM, rhs}).predicate();
                    }
                    if (op == CqnComparisonPredicate.Operator.IS_NOT) {
                        return ExpressionBuilder.create((CqnToken[])new CqnToken[]{lhs, IS_DISTINCT_FROM, rhs}).predicate();
                    }
                }
                return CQL.comparison(lhs, (CqnComparisonPredicate.Operator)op, rhs);
            }
        };
        return ExpressionVisitor.copy((CqnPredicate)pred, (Modifier)m);
    }
}

