/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.postgresql;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.util.CdsTypeUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.Map;
import java.util.stream.Collectors;

public class PostgreSqlSessionVariableSetter
implements SessionVariableSetter {
    public void set(Connection conn, Map<String, Object> contextVariables) throws SQLException {
        String sql = contextVariables.entrySet().stream().map(e -> PostgreSqlSessionVariableSetter.sql((String)e.getKey(), e.getValue())).collect(Collectors.joining("; "));
        try (Statement stmt = conn.createStatement();){
            stmt.executeUpdate(sql);
        }
    }

    private static String sql(String key, Object value) {
        StringBuilder builder = new StringBuilder("SET SESSION ");
        String name = switch (key) {
            case "NOW" -> "now";
            case "VALID-FROM" -> "valid_from";
            case "VALID-TO" -> "valid_to";
            case "APPLICATIONUSER" -> "applicationuser";
            case "LOCALE" -> "locale";
            case "TENANT" -> "tenant";
            default -> key;
        };
        builder.append("cap.");
        builder.append(name);
        if (value == null) {
            builder.append(" TO DEFAULT");
        } else {
            String val = switch (key) {
                case "NOW", "VALID-FROM", "VALID-TO" -> PostgreSqlSessionVariableSetter.sqlTimestamp(value);
                default -> value.toString();
            };
            builder.append(" = ");
            builder.append(SQLHelper.literal(val));
        }
        return builder.toString();
    }

    private static String sqlTimestamp(Object value) {
        return CdsTypeUtils.timestamp((Instant)((Instant)value), (int)6).toString();
    }
}

