/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.postgresql;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.generic.GenericStatementResolver;
import com.sap.cds.jdbc.generic.hierarchies.RecursiveCteHierarchyResolver;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.reflect.CdsModel;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PostgreSqlStatementResolver
extends GenericStatementResolver {
    public String upsert(String table, Stream<String> keyColumns, Stream<String> upsertColumns, Stream<String> upsertValues) {
        List col = upsertColumns.collect(Collectors.toList());
        String columns = SQLHelper.commaSeparated(col.stream());
        String insertValues = SQLHelper.commaSeparated(upsertValues);
        String conflictTarget = SQLHelper.commaSeparated(keyColumns);
        String updateValues = SQLHelper.commaSeparated(col.stream().map(c -> "EXCLUDED." + c));
        return Stream.of("INSERT INTO", table, columns, "VALUES", insertValues, "ON CONFLICT", conflictTarget, "DO UPDATE SET", columns, "= ROW", updateValues).collect(Collectors.joining(" "));
    }

    public String lockMode(CqnLock.Mode mode) {
        return mode == CqnLock.Mode.SHARED ? "FOR SHARE" : "FOR UPDATE";
    }

    public Optional<String> timeoutClause(int timeoutSeconds) {
        if (timeoutSeconds == 0) {
            return Optional.of("NOWAIT");
        }
        return Optional.empty();
    }

    public String deleteAll(String tableName) {
        return "TRUNCATE TABLE " + tableName + " CASCADE";
    }

    @Override
    public Select<?> applyTransformations(CdsModel model, Select<?> select) {
        RecursiveCteHierarchyResolver resolver = new RecursiveCteHierarchyResolver(model, select);
        resolver.applyTransformations();
        return resolver.get();
    }
}

