/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.postgresql;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.impl.sql.SqlMappingImpl;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PostgresSqlMapping
extends SqlMappingImpl {
    public PostgresSqlMapping(CdsStructuredType rowType, Function<String, String> casing) {
        super(rowType, casing);
    }

    @Override
    public String jsonQuery(String contextItem, String jsonPath) {
        return contextItem + " #> " + PostgresSqlMapping.path(jsonPath);
    }

    @Override
    public String jsonValue(String contextItem, String jsonPath, CdsBaseType type) {
        String jsonValue = contextItem + " #>> " + PostgresSqlMapping.path(jsonPath);
        if (type != null) {
            jsonValue = "(" + jsonValue + ")::" + this.sqlType(type);
        }
        return jsonValue;
    }

    private static String path(String jsonPath) {
        String path = Arrays.stream(jsonPath.split("\\.")).skip(1L).collect(Collectors.joining(","));
        return SQLHelper.literal("{" + path + "}");
    }

    private String sqlType(CdsBaseType type) {
        return switch (type) {
            case CdsBaseType.STRING, CdsBaseType.UUID -> "varchar";
            case CdsBaseType.BOOLEAN -> "boolean";
            case CdsBaseType.INTEGER, CdsBaseType.INT32 -> "integer";
            case CdsBaseType.INT16 -> "smallint";
            case CdsBaseType.INTEGER64, CdsBaseType.INT64 -> "bigint";
            case CdsBaseType.DECIMAL -> "decimal";
            case CdsBaseType.TIMESTAMP -> "timestamp(6) at time zone 'UTC'";
            case CdsBaseType.DATETIME -> "timestamp(0) at time zone 'UTC'";
            case CdsBaseType.DATE -> "date";
            case CdsBaseType.TIME -> "time";
            case CdsBaseType.DOUBLE -> "float8";
            case CdsBaseType.LARGE_STRING -> "text";
            case CdsBaseType.BINARY -> "bytea";
            default -> "varchar";
        };
    }
}

