/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sap.cds.CdsData;
import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsList;
import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.Cascader;
import com.sap.cds.impl.EntityCascader;
import com.sap.cds.impl.RowImpl;
import com.sap.cds.impl.builder.model.ExpressionImpl;
import com.sap.cds.impl.builder.model.StructuredTypeRefBuilder;
import com.sap.cds.impl.parser.token.RefSegmentBuilder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.RefBuilder;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.OccUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepUpdateSplitter {
    private static final Logger logger = LoggerFactory.getLogger(DeepUpdateSplitter.class);
    private final CdsDataStore dataStore;
    private final SessionContext session;
    private CdsEntity entity;
    private EntityCascader.EntityOperations operations;
    private boolean deepUpsert;

    public DeepUpdateSplitter(CdsDataStore dataStore) {
        this.dataStore = dataStore;
        this.session = dataStore.getSessionContext();
    }

    public EntityCascader.EntityOperations computeOperations(CdsEntity targetEntity, CqnUpdate update, Map<String, Object> targetKeys) {
        StructuredType<?> path = DeepUpdateSplitter.targetRef(update);
        return this.computeOps(EntityCascader.EntityOperation.Operation.UPDATE, path, targetEntity, targetKeys, update.entries());
    }

    public EntityCascader.EntityOperations computeOperations(CdsEntity targetEntity, CqnUpsert upsert, Map<String, Object> targetKeys) {
        this.deepUpsert = true;
        StructuredType path = CQL.to((List)RefSegmentBuilder.copy((List)upsert.ref().segments()));
        return this.computeOps(EntityCascader.EntityOperation.Operation.UPSERT, path, targetEntity, targetKeys, upsert.entries());
    }

    private EntityCascader.EntityOperations computeOps(EntityCascader.EntityOperation.Operation op, StructuredType<?> path, CdsEntity targetEntity, Map<String, Object> targetKeys, List<Map<String, Object>> entries) {
        this.entity = targetEntity;
        this.operations = new EntityCascader.EntityOperations();
        this.operations.entries(entries);
        List<EntityCascader.EntityData> updateEntries = this.determineEntries(targetKeys, path);
        if (!updateEntries.isEmpty()) {
            this.moveETagToEntries(updateEntries, path);
        }
        EntityCascader.EntityKeys.Factory keysFactory = EntityCascader.EntityKeys.of(this.entity);
        for (EntityCascader.EntityData entry : updateEntries) {
            EntityCascader.EntityKeys entityId = keysFactory.keys(entry);
            this.operations.add(EntityCascader.EntityOperation.root(entityId, op, this.session).update(entry));
        }
        if (!updateEntries.isEmpty()) {
            this.entity.associations().forEach(assoc -> this.cascade(path, (CdsElement)assoc, updateEntries));
        }
        return this.operations;
    }

    private void moveETagToEntries(List<EntityCascader.EntityData> updateEntries, StructuredType<?> path) {
        OccUtils.getVersionElement((CdsStructuredType)this.entity).ifPresent(el -> {
            Optional filter = path.asRef().targetSegment().filter();
            Optional<List> eTagPredicate = filter.flatMap(OccUtils::eTagPredicate);
            boolean oldVersionParam = filter.map(p -> OccUtils.containsVersionParam((CqnPredicate)p, (CdsElement)el)).orElse(false);
            if (eTagPredicate.isPresent() || !oldVersionParam) {
                List values = eTagPredicate.map(OccUtils::concreteEtagValues).orElse(List.of());
                if (values.size() == 1) {
                    Object versionValue = values.get(0);
                    updateEntries.forEach(e -> e.put(el.getName(), versionValue));
                } else {
                    updateEntries.forEach(e -> e.remove(el.getName()));
                }
            }
        });
    }

    private List<EntityCascader.EntityData> determineEntries(Map<String, Object> targetKeys, StructuredType<?> path) {
        Set<String> targetKeyElements;
        Set missingKeys;
        Set keyElements = CdsModelUtils.concreteKeyNames((CdsStructuredType)this.entity);
        if (!CqnStatementUtils.hasInfixFilter((CqnReference)path.asRef())) {
            this.operations.entries().forEach(e -> DeepUpdateSplitter.addKeyValues(this.entity, targetKeys, e));
            if (this.entriesContainValuesFor(keyElements)) {
                return this.operations.entries().stream().map(EntityCascader.EntityData::of).toList();
            }
        }
        if (!this.entriesContainValuesFor(missingKeys = Sets.filter((Set)keyElements, arg_0 -> DeepUpdateSplitter.lambda$determineEntries$6(targetKeyElements = targetKeys.keySet(), arg_0)))) {
            return this.selectKeyValues(path, missingKeys);
        }
        return this.evaluateFilter(path, targetKeys, keyElements);
    }

    private boolean entriesContainValuesFor(Set<String> elements) {
        return this.operations.entries().stream().allMatch(e -> e.keySet().containsAll(elements));
    }

    private List<EntityCascader.EntityData> selectKeyValues(StructuredType<?> path, Set<String> missingKeys) {
        if (this.operations.entries().size() == 1) {
            logger.warn("Update data is missing key values of entity {}. Executing query to determine key values.", (Object)this.entity.getQualifiedName());
            Select select = Select.from(path).columns(missingKeys.stream().map(CQL::get));
            Result result = this.dataStore.execute((CqnSelect)select, new Object[0]);
            Map<String, Object> singleEntry = this.operations.entries().get(0);
            ArrayList<EntityCascader.EntityData> updateEntries = new ArrayList<EntityCascader.EntityData>();
            if (result.rowCount() == 1L) {
                Row keyValues = (Row)result.single();
                singleEntry.putAll((Map<String, Object>)keyValues);
                updateEntries.add(EntityCascader.EntityData.of(singleEntry));
            } else if (result.rowCount() > 1L) {
                result.forEach(row -> row.putAll((Map)DataUtils.copyMap((Map)singleEntry)));
                result.stream().map(EntityCascader.EntityData::of).forEach(updateEntries::add);
            }
            return updateEntries;
        }
        throw new CdsDataException("Update data is missing key values " + missingKeys + " of entity " + this.entity);
    }

    private List<EntityCascader.EntityData> evaluateFilter(StructuredType<?> path, Map<String, Object> targetKeys, Set<String> keyElements) {
        logger.debug("Executing query to evaluate update filter condition {}", path);
        if (!targetKeys.isEmpty()) {
            this.operations.entries().forEach(e -> DeepUpdateSplitter.addKeyValues(this.entity, targetKeys, e));
        }
        ArrayList<EntityCascader.EntityData> updateEntries = new ArrayList<EntityCascader.EntityData>();
        Map<String, Row> entityKeys = this.selectKeysMatchingPathFilter(path, keyElements, this.operations.entries());
        Map<String, EntityCascader.EntityData> updateData = this.operations.entries().stream().collect(Collectors.toMap(row -> DeepUpdateSplitter.index(row, keyElements), EntityCascader.EntityData::of));
        entityKeys.forEach((hash, key) -> updateEntries.add((EntityCascader.EntityData)((Object)((Object)updateData.get(hash)))));
        logger.debug("Update filter condition fulfilled by {} entities", (Object)entityKeys.size());
        return updateEntries;
    }

    private static void addKeyValues(CdsEntity entity, Map<String, Object> keyValues, Map<String, Object> target) {
        keyValues.forEach((key, valInRef) -> {
            Object valInData = target.put((String)key, valInRef);
            if (valInData != null && !valInData.equals(valInRef)) {
                throw new CdsDataException("Values for key element '" + key + "' in update data do not match values in update ref or where clause");
            }
        });
        target.putAll(Maps.filterValues((Map)DataUtils.keyValues((CdsEntity)entity, target), v -> !Objects.isNull(v)));
    }

    private static StructuredType<?> targetRef(CqnUpdate update) {
        if (!CqnStatementUtils.containsPathExpression((Optional)update.where())) {
            return CqnStatementUtils.targetRef((CqnUpdate)update);
        }
        throw new UnsupportedOperationException("Deep updates with path in where clause are not supported");
    }

    private Map<String, Row> selectKeysMatchingPathFilter(StructuredType<?> path, Set<String> keys, List<Map<String, Object>> keyValueSets) {
        Select select = Select.from((CqnStructuredTypeRef)this.filteredPath(path, keys)).columns(keys.stream().map(CQL::get));
        List params = OccUtils.addOldVersionParam((CdsEntity)this.entity, keyValueSets);
        Result entries = this.dataStore.execute((CqnSelect)select, (Iterable)params);
        return entries.stream().collect(Collectors.toMap(row -> DeepUpdateSplitter.index((Map<String, Object>)row, keys), Function.identity()));
    }

    private CqnStructuredTypeRef filteredPath(StructuredType<?> path, Set<String> filterParams) {
        RefBuilder refBuilder = StructuredTypeRefBuilder.copy((CqnStructuredTypeRef)path.asRef());
        RefBuilder.RefSegment targetSegment = refBuilder.targetSegment();
        targetSegment.filter((CqnPredicate)ExpressionImpl.byParams(filterParams).and((CqnPredicate)targetSegment.filter().orElse(null), new CqnPredicate[0]));
        return (CqnStructuredTypeRef)refBuilder.build();
    }

    private void cascade(StructuredType<?> path, CdsElement assoc, List<EntityCascader.EntityData> entries) {
        List<EntityCascader.EntityData> updateEntries = entries.stream().filter(e -> e.containsKey(assoc.getName())).toList();
        if (!updateEntries.isEmpty()) {
            CdsEntity targetEntity = ((CdsAssociationType)assoc.getType().as(CdsAssociationType.class)).getTarget();
            if (CdsModelUtils.isSingleValued((CdsType)assoc.getType())) {
                this.toOne(path, assoc, targetEntity, updateEntries);
            } else {
                this.toMany(path, assoc, targetEntity, updateEntries);
            }
        }
    }

    private void toOne(StructuredType<?> path, CdsElement assoc, CdsEntity child, List<EntityCascader.EntityData> parentEntries) {
        CdsEntity parent = (CdsEntity)assoc.getDeclaringType();
        boolean forward = !CdsModelUtils.isReverseAssociation((CdsElement)assoc);
        boolean composition = ((CdsAssociationType)assoc.getType().as(CdsAssociationType.class)).isComposition();
        Set parentKeys = CdsModelUtils.concreteKeyNames((CdsStructuredType)parent);
        Map<String, Row> expandedParentEntries = this.deepUpsert ? Collections.emptyMap() : this.selectPathExpandToOneTargetKeys(path, assoc, forward, parentKeys, parentEntries);
        ArrayList<EntityCascader.EntityData> childEntries = new ArrayList<EntityCascader.EntityData>(parentEntries.size());
        for (EntityCascader.EntityData parentEntry : parentEntries) {
            EntityCascader.EntityData childEntry = EntityCascader.EntityData.of((Map)DeepUpdateSplitter.getDataFor(assoc, (Map<String, Object>)((Object)parentEntry)));
            if (this.deepUpsert) {
                this.upsertToOne(parent, child, assoc, forward, composition, parentEntry, childEntry, childEntries);
                continue;
            }
            this.updateToOne(parent, child, assoc, forward, composition, parentKeys, expandedParentEntries, parentEntry, childEntry, childEntries);
        }
        child.associations().forEach(a -> this.cascade((StructuredType<?>)path.to(assoc.getName()), (CdsElement)a, (List<EntityCascader.EntityData>)childEntries));
    }

    private void upsertToOne(CdsEntity parent, CdsEntity child, CdsElement assoc, boolean forward, boolean composition, EntityCascader.EntityData parentEntry, EntityCascader.EntityData childEntry, List<EntityCascader.EntityData> childEntries) {
        if (childEntry == null) {
            this.remove(assoc, forward, parent, Collections.singletonList(parentEntry), assoc.getName());
        } else if (CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)assoc) || CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)assoc)) {
            childEntries.add(childEntry);
            this.operations.add(this.xsert(parentEntry, assoc, forward, child, childEntry, false));
        } else if (forward && !composition) {
            DeepUpdateSplitter.removeNonFkValues(assoc, (Map<String, Object>)((Object)childEntry));
        }
    }

    private void updateToOne(CdsEntity parentEntity, CdsEntity targetEntity, CdsElement assoc, boolean forward, boolean composition, Set<String> parentKeys, Map<String, Row> expandedParentEntries, EntityCascader.EntityData parentUpdateEntry, EntityCascader.EntityData targetUpdateEntry, List<EntityCascader.EntityData> targetUpdateEntries) {
        Row parentEntry = expandedParentEntries.getOrDefault(DeepUpdateSplitter.index((Map<String, Object>)((Object)parentUpdateEntry), parentKeys), RowImpl.row(Collections.emptyMap()));
        Map targetEntry = (Map)DeepUpdateSplitter.getDataFor(assoc, (Map<String, Object>)parentEntry);
        if (targetEntry != null && !targetEntry.isEmpty()) {
            if (targetUpdateEntry == null) {
                this.remove(assoc, forward, targetEntity, Collections.singletonList(targetEntry), null);
            } else if (DeepUpdateSplitter.targetChange(assoc, forward && !composition, targetEntity, targetEntry, (Map<String, Object>)((Object)targetUpdateEntry))) {
                if (CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)assoc) || CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)assoc)) {
                    this.operations.add(this.xsert(parentUpdateEntry, assoc, forward, targetEntity, targetUpdateEntry, composition));
                    targetUpdateEntries.add(targetUpdateEntry);
                } else {
                    DeepUpdateSplitter.removeNonFkValues(assoc, (Map<String, Object>)((Object)targetUpdateEntry));
                }
                if (composition) {
                    this.delete(targetEntity, targetEntry, null);
                }
            } else if (CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)assoc)) {
                this.operations.add(this.update(targetEntity, targetEntry, targetUpdateEntry));
                targetUpdateEntries.add(targetUpdateEntry);
            }
        } else if (targetUpdateEntry != null) {
            if (forward && !composition && !CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)assoc)) {
                DeepUpdateSplitter.removeNonFkValues(assoc, (Map<String, Object>)((Object)targetUpdateEntry));
            } else {
                boolean generatedKey = DataUtils.generateUuidKeys((CdsStructuredType)targetEntity, targetUpdateEntry.data());
                if (forward && generatedKey) {
                    EntityCascader.EntityKeys parentKeyValues = EntityCascader.EntityKeys.of(parentEntity).keys(parentUpdateEntry);
                    Map<String, Object> targetRefValues = this.fkValues(assoc, false, targetUpdateEntry);
                    this.operations.add(this.update(parentEntity, (Map<String, Object>)((Object)parentKeyValues), EntityCascader.EntityData.ofFKs(targetRefValues)));
                }
                boolean insertOnly = composition || generatedKey;
                this.operations.add(this.xsert(parentUpdateEntry, assoc, forward, targetEntity, targetUpdateEntry, insertOnly));
                targetUpdateEntries.add(targetUpdateEntry);
            }
        }
    }

    private static boolean targetChange(CdsElement assoc, boolean forward, CdsEntity targetEntity, Map<String, Object> oldEntry, Map<String, Object> newEntry) {
        Set<String> refElements = forward ? DeepUpdateSplitter.refElements(assoc, forward) : CdsModelUtils.concreteKeyNames((CdsStructuredType)targetEntity);
        return refElements.stream().anyMatch(k -> {
            Object newVal = newEntry.get(k);
            return newVal != null && !newVal.equals(oldEntry.get(k));
        });
    }

    private static void removeNonFkValues(CdsElement assoc, Map<String, Object> data) {
        Set<String> assocKeys = DeepUpdateSplitter.refElements(assoc, true);
        data.keySet().retainAll(assocKeys);
    }

    private Map<String, Row> selectPathExpandToOneTargetKeys(StructuredType<?> path, CdsElement assoc, boolean forwardMapped, Set<String> parentKeys, List<EntityCascader.EntityData> keyValueSets) {
        logger.debug("Executing query to determine target entity of {}", (Object)assoc.getQualifiedName());
        List slis = parentKeys.stream().map(CQL::get).collect(Collectors.toList());
        Set<String> refElements = DeepUpdateSplitter.refElements(assoc, forwardMapped);
        refElements.addAll(CdsModelUtils.targetKeys((CdsElement)assoc));
        slis.add(CQL.to((String)assoc.getName()).expand(refElements.toArray(new String[refElements.size()])));
        Select select = Select.from((CqnStructuredTypeRef)this.filteredPath(path, parentKeys)).columns(slis);
        List<Map> list = keyValueSets.stream().map(EntityCascader.EntityData::withFKs).toList();
        List params = OccUtils.addOldVersionParam((CdsEntity)this.entity, list);
        Result targetEntries = this.dataStore.execute((CqnSelect)select, (Iterable)params);
        return targetEntries.stream().collect(Collectors.toMap(row -> DeepUpdateSplitter.index((Map<String, Object>)row, parentKeys), Function.identity()));
    }

    private Map<String, Object> fkValues(CdsElement assoc, boolean reverseMapped, EntityCascader.EntityData data) {
        return new OnConditionAnalyzer(assoc, reverseMapped, this.session).getFkValues(data.withFKs());
    }

    private void toMany(StructuredType<?> path, CdsElement assoc, CdsEntity targetEntity, List<EntityCascader.EntityData> parentEntries) {
        boolean composition = ((CdsAssociationType)assoc.getType().as(CdsAssociationType.class)).isComposition();
        Set parentKeys = CdsModelUtils.concreteKeyNames((CdsStructuredType)((CdsStructuredType)assoc.getDeclaringType()));
        Set targetKeys = CdsModelUtils.targetKeys((CdsElement)assoc);
        Map<String, Row> fullSetTargetEntries = this.selectTargetEntries(assoc, parentKeys, targetKeys, parentEntries);
        ArrayList<EntityCascader.EntityData> updateEntries = new ArrayList<EntityCascader.EntityData>(parentEntries.size());
        for (EntityCascader.EntityData parentEntry : parentEntries) {
            List targetUpdateEntries = (List)DeepUpdateSplitter.getDataFor(assoc, (Map<String, Object>)((Object)parentEntry));
            if (targetUpdateEntries == null) {
                throw new CdsDataException("Value for to-many association '" + assoc.getDeclaringType() + "." + assoc + "' must not be null.");
            }
            Map<String, Object> parentRefValues = this.fkValues(assoc, true, parentEntry);
            if (parentRefValues.containsValue(null)) {
                throw new CdsDataException("Values of ref elements " + parentRefValues.keySet() + " for mapping " + targetEntity + " to " + assoc.getDeclaringType() + " cannot be determined from update data.");
            }
            boolean delta = DeepUpdateSplitter.isDelta(targetUpdateEntries);
            EntityCascader.EntityKeys.Factory keysFactory = EntityCascader.EntityKeys.of(targetEntity);
            for (Map entry : targetUpdateEntries) {
                EntityCascader.EntityOperation operation;
                EntityCascader.EntityData updateEntry = EntityCascader.EntityData.of(entry);
                updateEntry.putFKs(parentRefValues);
                if (delta) {
                    if (DeepUpdateSplitter.isRemove(updateEntry)) {
                        this.remove(assoc, false, targetEntity, Collections.singletonList(updateEntry.withFKs()), null);
                        continue;
                    }
                    operation = this.xsert(assoc, targetEntity, updateEntry, false);
                } else {
                    boolean targetPresent;
                    boolean bl = targetPresent = fullSetTargetEntries.remove(DeepUpdateSplitter.index(updateEntry.withFKs(), targetKeys)) != null;
                    if (this.deepUpsert) {
                        operation = this.xsert(assoc, targetEntity, updateEntry, false);
                    } else {
                        boolean generatedKey = !targetPresent && DataUtils.generateUuidKeys((CdsStructuredType)targetEntity, updateEntry.data());
                        EntityCascader.EntityKeys targetId = keysFactory.keys(updateEntry);
                        operation = generatedKey ? EntityCascader.EntityOperation.insert(targetId, updateEntry, this.session) : (targetPresent ? EntityCascader.EntityOperation.nop(targetId, null, this.session).update((Map<String, Object>)((Object)updateEntry), Collections.emptyMap()) : this.xsert(assoc, targetEntity, updateEntry, composition));
                    }
                }
                DeepUpdateSplitter.assertCascading(operation, assoc);
                this.operations.add(operation);
                updateEntries.add(updateEntry);
            }
        }
        this.remove(assoc, false, targetEntity, fullSetTargetEntries.values(), null);
        targetEntity.associations().forEach(a -> this.cascade((StructuredType<?>)path.to(assoc.getName()), (CdsElement)a, (List<EntityCascader.EntityData>)updateEntries));
    }

    private static boolean isDelta(List<Map<String, Object>> entries) {
        if (entries instanceof CdsList) {
            CdsList list = (CdsList)entries;
            return list.isDelta();
        }
        return false;
    }

    private static boolean isRemove(EntityCascader.EntityData entry) {
        Map<String, Object> map = entry.data();
        if (map instanceof CdsData) {
            CdsData data = (CdsData)map;
            return data.isForRemoval();
        }
        return false;
    }

    private Map<String, Row> selectTargetEntries(CdsElement assoc, Set<String> parentKeys, Set<String> targetKeys, List<EntityCascader.EntityData> keyValueSets) {
        logger.debug("Executing query to determine target entity of {}", (Object)assoc.getQualifiedName());
        StructuredType path = CQL.entity((String)assoc.getDeclaringType().getQualifiedName()).filterByParams(parentKeys).to(assoc.getName());
        Select select = Select.from((StructuredType)path).columns(targetKeys.stream().map(CQL::get));
        Result targetEntries = this.dataStore.execute((CqnSelect)select, keyValueSets.stream().filter(entry -> !DeepUpdateSplitter.isDelta((List)DeepUpdateSplitter.getDataFor(assoc, (Map<String, Object>)((Object)entry)))).map(EntityCascader.EntityData::withFKs).toList());
        return targetEntries.stream().collect(Collectors.toMap(row -> DeepUpdateSplitter.index((Map<String, Object>)row, targetKeys), Function.identity()));
    }

    private EntityCascader.EntityOperation update(CdsEntity target, Map<String, Object> entry, EntityCascader.EntityData updateData) {
        EntityCascader.EntityOperation op = EntityCascader.EntityOperation.nop(EntityCascader.EntityKeys.keys(target, entry), null, entry, this.session).update(updateData);
        updateData.putAll((Map)((Object)op.targetKeys()));
        return op;
    }

    private void remove(CdsElement association, boolean forwardMapped, CdsEntity targetEntity, Collection<? extends Map<String, Object>> keyValues, String path) {
        if (CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.DELETE, (CdsElement)association)) {
            keyValues.forEach(k -> this.delete(targetEntity, (Map<String, Object>)k, path));
        } else if (!forwardMapped) {
            DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.UPDATE, association);
            Set<String> parentRefElements = DeepUpdateSplitter.refElements(association, forwardMapped);
            EntityCascader.EntityKeys.Factory keysFactory = EntityCascader.EntityKeys.of(targetEntity);
            keyValues.forEach(k -> this.operations.add(EntityCascader.EntityOperation.nop(keysFactory.keys((Map<String, Object>)k), path, this.session).updateToNull(parentRefElements)));
        }
    }

    private void delete(CdsEntity entity, Map<String, Object> data, String path) {
        boolean cascaded;
        EntityCascader.EntityKeys rootKey = EntityCascader.EntityKeys.keys(entity, data);
        CdsEntity target = entity;
        if (path != null) {
            target = (CdsEntity)entity.getTargetOf(path);
        }
        if (!(cascaded = Cascader.create(CdsModelUtils.CascadeType.DELETE, target).from(path).cascade(p -> this.operations.add(EntityCascader.EntityOperation.delete(rootKey, p.asRef().path(), this.session))))) {
            EntityCascader.cascadeDelete(this.dataStore, rootKey, path).forEach(this.operations::add);
        }
        this.operations.add(EntityCascader.EntityOperation.delete(rootKey, path, this.session));
    }

    private EntityCascader.EntityOperation xsert(EntityCascader.EntityData parentData, CdsElement association, boolean forwardMapped, CdsEntity entity, EntityCascader.EntityData entityData, boolean insertOnly) {
        if (!forwardMapped) {
            entityData.putFKs(this.fkValues(association, true, parentData));
        }
        return this.xsert(association, entity, entityData, insertOnly);
    }

    private EntityCascader.EntityOperation xsert(CdsElement association, CdsEntity entity, EntityCascader.EntityData entityData, boolean insertOnly) {
        boolean update;
        EntityCascader.EntityKeys targetEntity = EntityCascader.EntityKeys.keys(entity, entityData);
        boolean insert = CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)association);
        boolean bl = update = !insertOnly && CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)association);
        if (!this.deepUpsert && insert && update && DeepUpdateSplitter.containsStream((Map<String, Object>)((Object)entityData))) {
            Select select = Select.from((CdsEntity)entity).columns(new Selectable[]{CQL.plain((String)"1").as("1")}).matching((Map)((Object)targetEntity));
            update = this.dataStore.execute((CqnSelect)select, new Object[0]).rowCount() > 0L;
            boolean bl2 = insert = !update;
        }
        if (insert && update) {
            if (this.deepUpsert || !DeepUpdateSplitter.hasDefaultValues(entity, (Map<String, Object>)((Object)entityData))) {
                return EntityCascader.EntityOperation.upsert(targetEntity, entityData, this.session);
            }
            return EntityCascader.EntityOperation.updateOrInsert(targetEntity, entityData, this.session);
        }
        if (insert) {
            return EntityCascader.EntityOperation.insert(targetEntity, entityData, this.session);
        }
        if (update) {
            return EntityCascader.EntityOperation.nop(targetEntity, null, this.session).update(entityData);
        }
        if (CdsModelUtils.managedToOne((CdsType)association.getType()) && DataUtils.isFkUpdate((CdsElement)association, (Map)((Object)entityData), (SessionContext)this.session)) {
            return EntityCascader.EntityOperation.nop(targetEntity, null, this.session);
        }
        CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
        throw new CdsDataException("UPSERT entity '%s' via association '%s.%s' is not allowed. The association does not cascade insert or update.".formatted(target, association.getDeclaringType(), association));
    }

    private static boolean containsStream(Map<String, Object> entityData) {
        return entityData.values().stream().anyMatch(v -> {
            Map m;
            return v instanceof InputStream || v instanceof Map && DeepUpdateSplitter.containsStream(m = (Map)v);
        });
    }

    private static boolean hasDefaultValues(CdsEntity entity, Map<String, Object> entityData) {
        boolean defaultValue = entity.concreteNonAssociationElements().filter(e -> e.defaultValue().isPresent()).anyMatch(e -> !entityData.containsKey(e.getName()));
        return defaultValue || entity.concreteNonAssociationElements().filter(CdsAnnotatable.byAnnotation((String)"cds.on.insert")).anyMatch(e -> !entityData.containsKey(e.getName()));
    }

    private static void assertCascading(EntityCascader.EntityOperation op, CdsElement association) {
        switch (op.operation()) {
            case INSERT: {
                DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.INSERT, association);
                break;
            }
            case UPDATE: {
                DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.UPDATE, association);
                break;
            }
            case DELETE: {
                DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.DELETE, association);
                break;
            }
            case UPDATE_OR_INSERT: 
            case UPSERT: {
                DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.UPDATE, association);
                DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.INSERT, association);
            }
        }
    }

    private static void assertCascading(CdsModelUtils.CascadeType cascadeType, CdsElement association) {
        if (!CdsModelUtils.isCascading((CdsModelUtils.CascadeType)cascadeType, (CdsElement)association)) {
            CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
            throw new CdsDataException("%s entity '%s' via association '%s.%s' is not allowed. The association does not cascade %s.".formatted(cascadeType.name(), target, association.getDeclaringType(), association, cascadeType));
        }
    }

    private static Set<String> refElements(CdsElement assoc, boolean forwardMapped) {
        HashMap mapping = new HashMap();
        new OnConditionAnalyzer(assoc, !forwardMapped).getFkMapping().forEach((fk, val) -> {
            if (val.isRef() && !val.asRef().firstSegment().startsWith("$")) {
                mapping.put(fk, val.asRef().lastSegment());
            }
        });
        if (forwardMapped) {
            return new HashSet<String>(mapping.values());
        }
        return new HashSet<String>(mapping.keySet());
    }

    public static <T> T getDataFor(CdsElement assoc, Map<String, Object> data) {
        return (T)DataUtils.getOrDefault(data, (String)assoc.getName(), null);
    }

    public static String index(Map<String, Object> values, Set<String> keys) {
        return values.entrySet().stream().filter(e -> keys.contains(e.getKey())).map(e -> (String)e.getKey() + ":" + e.getValue()).sorted().collect(Collectors.joining("-"));
    }

    private static /* synthetic */ boolean lambda$determineEntries$6(Set targetKeyElements, String k) {
        return !targetKeyElements.contains(k);
    }
}

