/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.CqnTableFunction;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.docstore.DocStoreCTE;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.qat.CTE;
import com.sap.cds.impl.qat.QatAssociationNode;
import com.sap.cds.impl.qat.QatBuilder;
import com.sap.cds.impl.qat.QatElementNode;
import com.sap.cds.impl.qat.QatEntityNode;
import com.sap.cds.impl.qat.QatEntityRootNode;
import com.sap.cds.impl.qat.QatNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.qat.QatTableFunctionRootNode;
import com.sap.cds.impl.qat.QatTraverser;
import com.sap.cds.impl.qat.QatVisitor;
import com.sap.cds.impl.sql.SelectStatementBuilder;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.SelectListValueBuilder;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnCalculatedElementsSubstitutor;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.ElementSelector;
import com.sap.cds.util.NestedStructsResolver;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CommonTableExpression
implements CTE {
    private final List<PreparedCqnStmt.Parameter> parameters = new ArrayList<PreparedCqnStmt.Parameter>();
    private final Map<String, CTE> subCTEs = new LinkedHashMap<String, CTE>();
    private final String name;
    private final CqnSource source;
    private final CdsStructuredType sourceType;
    private final Context context;
    private String sql;

    public CommonTableExpression(Context context, CdsEntity entity, CqnSelect statement, CdsStructuredType sourceType) {
        this(context, context.getDbContext().getSqlMapping((CdsStructuredType)entity).cteName(), (CqnSource)statement, sourceType);
    }

    public CommonTableExpression(Context context, String name, CqnSource source, CdsStructuredType sourceType) {
        this.context = context;
        this.name = name;
        this.source = source;
        this.sourceType = sourceType;
    }

    public static Stream<String> with(Context context, Deque<QatSelectableNode> outer, List<PreparedCqnStmt.Parameter> params, Map<String, CTE> ctes) {
        CommonTableExpression.collect(ctes, context, outer);
        if (ctes.isEmpty()) {
            return Stream.empty();
        }
        return CommonTableExpression.with(ctes, params);
    }

    private static Stream<String> with(Map<String, CTE> ctes, List<PreparedCqnStmt.Parameter> params) {
        LinkedHashMap<String, String> cteSqlMap = new LinkedHashMap<String, String>();
        CommonTableExpression.cte2sql(ctes, cteSqlMap, params);
        if (cteSqlMap.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of("WITH " + String.join((CharSequence)", ", cteSqlMap.values()));
    }

    private static void cte2sql(Map<String, CTE> ctes, LinkedHashMap<String, String> cteSqlMap, List<PreparedCqnStmt.Parameter> params) {
        ctes.forEach((e, cte) -> {
            if (!cteSqlMap.containsKey(e)) {
                CommonTableExpression.cte2sql(cte.subCTEs(), cteSqlMap, params);
                cteSqlMap.computeIfAbsent((String)e, k -> {
                    params.addAll(cte.params());
                    return cte.toSQL();
                });
            }
        });
    }

    public static void collect(final Map<String, CTE> ctes, final Context context, Deque<QatSelectableNode> outer) {
        final CdsModel model = context.getCdsModel();
        QatVisitor cteVisitor = new QatVisitor(){

            @Override
            public void visit(QatEntityRootNode root) {
                if (ctes.containsKey(root.rowType().getQualifiedName())) {
                    return;
                }
                if (CdsModelUtils.isRuntimeView((CdsModel)model, (CdsEntity)root.rowType())) {
                    ctes.putAll(CommonTableExpression.resolveRuntimeViewsToCTEs(context, root.rowType()));
                } else if (this.hasCalculatedElements(root)) {
                    String name = root.rowType().getQualifiedName();
                    ctes.put(name, CommonTableExpression.buildForCalculatedElements(context, root));
                }
            }

            @Override
            public void visit(QatAssociationNode assoc) {
                CdsEntity targetEntity = assoc.association().targetEntity();
                if (assoc.skipJoin() || ctes.containsKey(targetEntity.getQualifiedName())) {
                    return;
                }
                if (CdsModelUtils.isRuntimeView((CdsModel)model, (CdsEntity)targetEntity)) {
                    ctes.putAll(CommonTableExpression.resolveRuntimeViewsToCTEs(context, targetEntity));
                } else if (DocStoreUtils.targetsDocStore((CdsStructuredType)targetEntity)) {
                    HashSet<String> elements = new HashSet<String>();
                    assoc.children().stream().map(QatNode::name).forEach(elements::add);
                    targetEntity.keyElements().map(CdsElementDefinition::getName).forEach(elements::add);
                    String tableName = targetEntity.getQualifiedName().replace(".", "_");
                    ctes.put(assoc.alias(), new DocStoreCTE(context, tableName, assoc.alias(), elements));
                } else if (!ctes.containsKey(assoc.rowType().getQualifiedName()) && this.hasCalculatedElements(assoc)) {
                    ctes.put(targetEntity.getQualifiedName(), CommonTableExpression.buildForCalculatedElements(context, assoc));
                }
            }

            @Override
            public void visit(QatTableFunctionRootNode tableFunction) {
                CqnTableFunction tf = tableFunction.tableFunction();
                tf.cteName().ifPresent(cteName -> ctes.put(cteName, new CommonTableExpression(context, (String)cteName, (CqnSource)tf, tableFunction.rowType())));
            }

            private boolean hasCalculatedElements(QatEntityNode node) {
                CdsEntity target = node.rowType();
                return !target.isView() && !target.isAnonymous() && node.children().stream().anyMatch(c -> {
                    QatElementNode en;
                    return c instanceof QatElementNode && (en = (QatElementNode)c).element().isCalculated();
                });
            }
        };
        QatTraverser.take(cteVisitor).traverse(outer.getLast());
    }

    private static Map<String, CTE> resolveRuntimeViewsToCTEs(Context context, CdsEntity view) {
        HashMap<String, CTE> ctes = new HashMap<String, CTE>();
        CommonTableExpression.resolveRuntimeViews(ctes, context.getCdsModel(), view, context);
        return ctes;
    }

    private static void resolveRuntimeViews(Map<String, CTE> ctes, CdsModel model, CdsEntity view, Context context) {
        if (ctes.containsKey(view.getQualifiedName())) {
            return;
        }
        CqnSelect projection = (CqnSelect)view.query().orElseThrow(() -> new IllegalStateException("Entity " + view.getQualifiedName() + " does not have a projection"));
        projection = new ElementSelector((CdsStructuredType)view, (Predicate)ElementSelector.NON_VIRTUAL_NON_DRAFT, false).resolveStar(projection);
        CdsEntity projectionTarget = CdsModelUtils.entity((CdsModel)model, (CqnStructuredTypeRef)projection.ref());
        CqnSelect resolvedProjection = CommonTableExpression.resolveNestedProjections(model, projection, projectionTarget, ElementSelector.TO_ONE_MANAGED);
        CommonTableExpression cte = new CommonTableExpression(context, view, resolvedProjection, (CdsStructuredType)projectionTarget);
        ctes.put(view.getQualifiedName(), cte);
        if (CdsModelUtils.isRuntimeView((CdsModel)model, (CdsEntity)projectionTarget)) {
            CommonTableExpression.resolveRuntimeViews(ctes, model, projectionTarget, context);
        }
    }

    private static CqnSelect resolveNestedProjections(CdsModel model, CqnSelect projection, CdsEntity projectionTarget, ElementSelector.Filter filter) {
        Select query = (Select)CQL.copy((CqnStatement)((Select)projection));
        NestedStructsResolver.resolveNestedStructs((Select)query, (CdsStructuredType)projectionTarget, (ElementSelector.Filter)filter);
        query = CqnStatementUtils.resolveExpands((CdsModel)model, (Select)query, (CdsStructuredType)projectionTarget, (ElementSelector.Filter)filter);
        CqnStatementUtils.unfoldInline((Select)query, (CdsStructuredType)projectionTarget);
        return query;
    }

    private static CommonTableExpression buildForCalculatedElements(Context context, QatEntityNode node) {
        CdsEntity target = node.rowType();
        SqlMapping sqlMapping = context.getDbContext().getSqlMapping((CdsStructuredType)target);
        List items = target.elements().filter(CdsElementDefinition::isCalculated).map(e -> CQL.get((String)e.getName()).as(sqlMapping.columnLikeAlias(e))).collect(Collectors.toList());
        items.add(SelectListValueBuilder.select((CqnValue)CQL.plain((String)(QatBuilder.ROOT_ALIAS + ".*"))).build());
        CqnSelect statement = (CqnSelect)CQL.copy((CqnStatement)Select.from((CdsEntity)target).columns(items), (Modifier)new CqnCalculatedElementsSubstitutor((CdsStructuredType)target));
        return new CommonTableExpression(context, target, statement, (CdsStructuredType)target);
    }

    @Override
    public String toSQL() {
        this.render();
        return this.sql;
    }

    @Override
    public Map<String, CTE> subCTEs() {
        this.render();
        return this.subCTEs;
    }

    private void render() {
        if (this.sql == null) {
            if (this.source.isSelect()) {
                this.sql = SelectStatementBuilder.forCTE(this.context, this.parameters, this.source.asSelect(), this.subCTEs).build().sql();
            } else if (this.source.isTableFunction()) {
                this.sql = "SELECT * FROM " + this.context.getDbContext().getTableFunctionMapper((Object)this.context, this.parameters, this.source.asTableFunction(), this.subCTEs).toSQL();
            } else {
                throw new UnsupportedOperationException("Unsupported CTE source type: " + String.valueOf(this.source));
            }
            this.sql = this.name + " AS (" + this.sql + ")";
        }
    }

    @Override
    public List<PreparedCqnStmt.Parameter> params() {
        return this.parameters;
    }

    @Override
    public String name() {
        return this.name;
    }
}

