/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.sqlite;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.sap.cds.CdsException;
import com.sap.cds.jdbc.generic.AbstractValueBinder;
import com.sap.cds.util.CdsTypeUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Function;

class SqliteBinder
extends AbstractValueBinder {
    SqliteBinder(TimeZone timeZone) {
        super(7, timeZone);
    }

    @Override
    protected Instant getInstant(ResultSet result, int i) throws SQLException {
        String txt = result.getString(i);
        if (txt == null) {
            return null;
        }
        return CdsTypeUtils.parseInstant((String)txt);
    }

    @Override
    protected void setInstant(PreparedStatement pstmt, int i, Instant instant) throws SQLException {
        pstmt.setString(i, Objects.toString(instant, null));
    }

    @Override
    protected LocalDate getLocalDate(ResultSet result, int i) throws SQLException {
        return this.getAndParse(result, i, LocalDate::parse);
    }

    @Override
    protected void setLocalDate(PreparedStatement pstmt, int i, LocalDate localDate) throws SQLException {
        pstmt.setString(i, Objects.toString(localDate, null));
    }

    @Override
    protected LocalTime getLocalTime(ResultSet result, int i) throws SQLException {
        return this.getAndParse(result, i, LocalTime::parse);
    }

    private <T> T getAndParse(ResultSet result, int i, Function<String, T> parser) throws SQLException {
        String txt = result.getString(i);
        return txt == null ? null : (T)parser.apply(txt);
    }

    @Override
    protected void setLocalTime(PreparedStatement pstmt, int i, LocalTime localTime) throws SQLException {
        pstmt.setString(i, Objects.toString(localTime, null));
    }

    @Override
    protected Reader getLargeString(ResultSet result, int i) throws SQLException {
        String string = result.getString(i);
        return null == string ? null : new StringReader(string);
    }

    @Override
    protected void setLargeString(PreparedStatement pstmt, int i, Reader reader) throws SQLException {
        try {
            pstmt.setString(i, CharStreams.toString((Readable)reader));
        }
        catch (IOException e) {
            throw new CdsException("Unable to convert Readable to a String", (Throwable)e);
        }
    }

    @Override
    protected InputStream getLargeBinary(ResultSet result, int i) throws SQLException {
        byte[] bytes = result.getBytes(i);
        return null == bytes ? null : new ByteArrayInputStream(bytes);
    }

    @Override
    protected void setLargeBinary(PreparedStatement pstmt, int i, InputStream stream) throws SQLException {
        try {
            pstmt.setBytes(i, ByteStreams.toByteArray((InputStream)stream));
        }
        catch (IOException e) {
            throw new CdsException("Unable to convert InputStream to a byte array", (Throwable)e);
        }
    }
}

