/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.qat;

import com.sap.cds.CqnTableFunction;
import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.impl.builder.model.Subquery;
import com.sap.cds.impl.qat.QatAssociation;
import com.sap.cds.impl.qat.QatAssociationNode;
import com.sap.cds.impl.qat.QatElementNode;
import com.sap.cds.impl.qat.QatEntityNode;
import com.sap.cds.impl.qat.QatEntityRootNode;
import com.sap.cds.impl.qat.QatNode;
import com.sap.cds.impl.qat.QatSelectRootNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.qat.QatStructuredElementNode;
import com.sap.cds.impl.qat.QatStructuredNode;
import com.sap.cds.impl.qat.QatTableFunctionRootNode;
import com.sap.cds.impl.qat.QatTraverser;
import com.sap.cds.impl.qat.QatVisitor;
import com.sap.cds.impl.util.Stack;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnScalarSubquery;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import java.util.Deque;
import java.util.List;
import java.util.Optional;

public class QatBuilder {
    private static final int T = 84;
    public static final String ROOT_ALIAS = QatBuilder.alias(0, 0);
    private final CqnSelect select;
    private final int queryDepth;
    private final QatSelectableNode root;
    private final QatSelectableNode main;

    public QatBuilder(Deque<QatSelectableNode> outer, CqnSelect select, CdsStructuredType sourceType) {
        this.select = select;
        this.queryDepth = outer.size();
        CqnSource source = select.from();
        if (source.isRef()) {
            CqnReference.Segment rootSegment = source.asRef().rootSegment();
            if (rootSegment.id().equals("$outer")) {
                CqnReference.Segment inner = (CqnReference.Segment)source.asRef().segments().get(1);
                QatSelectableNode o = outer.getLast();
                QatSelectableNode innerNode = (QatSelectableNode)o.child(inner.id(), inner.filter());
                this.root = new QatEntityRootNode((CdsEntity)innerNode.rowType(), inner.filter());
                this.root.setAlias(innerNode.alias());
            } else {
                this.root = new QatEntityRootNode((CdsEntity)sourceType, rootSegment.filter());
            }
        } else if (source.isSelect()) {
            CqnSelect subquery = source.asSelect();
            this.root = new QatSelectRootNode(subquery, sourceType);
        } else if (source.isTableFunction()) {
            CqnTableFunction tableFunction = source.asTableFunction();
            this.root = new QatTableFunctionRootNode(tableFunction, sourceType);
        } else {
            throw new UnsupportedOperationException("Joins are not supported");
        }
        this.main = outer.isEmpty() ? null : QatBuilder.findSourceNode(outer.getFirst());
    }

    public QatSelectableNode create() {
        this.collectRefs();
        this.assignTableAliases();
        return this.root;
    }

    private void assignTableAliases() {
        QatVisitor assignAlias = new QatVisitor(){
            int i = 0;

            @Override
            public void visit(QatSelectableNode root) {
                this.assignAlias(root);
            }

            @Override
            public void visit(QatAssociationNode association) {
                this.assignAlias(association);
            }

            private void assignAlias(QatSelectableNode node) {
                node.setAlias(QatBuilder.alias(QatBuilder.this.queryDepth, this.i++));
            }
        };
        QatTraverser.take(assignAlias).traverse(this.root);
    }

    private static String alias(int i, int j) {
        return String.valueOf((char)(84 + i)) + j;
    }

    private void collectRefs() {
        CollectRefsVisitor visitor = new CollectRefsVisitor(this.root);
        this.select.accept((CqnVisitor)visitor);
    }

    private static List<? extends CqnReference.Segment> skip(int skip, CqnReference ref) {
        List segments = ref.segments();
        if (skip == 0) {
            return segments;
        }
        return segments.subList(skip, segments.size());
    }

    public static QatSelectableNode findSourceNode(QatNode node) {
        QatNode sourceNode = node;
        while (!sourceNode.inSource()) {
            sourceNode = sourceNode.parent();
        }
        return (QatSelectableNode)sourceNode;
    }

    static QatSelectableNode qatRoot(QatNode root) {
        Optional<QatNode> next;
        while ((next = QatBuilder.childInSource(root)).isPresent()) {
            root = next.get();
        }
        return (QatSelectableNode)root;
    }

    private static Optional<QatNode> childInSource(QatNode root) {
        return root.children().stream().filter(QatNode::inSource).findFirst();
    }

    class CollectRefsVisitor
    implements CqnVisitor {
        private final AssociationAnalyzer associationAnalyzer = new AssociationAnalyzer();
        private final String rootEntity;
        private final Stack<QatNode> base = new Stack();
        private boolean inSource = false;
        private boolean inInfixFilter = false;

        private CollectRefsVisitor(QatSelectableNode root) {
            this.base.push((Object)root);
            this.rootEntity = root.rowType().getQualifiedName();
        }

        public void visit(CqnStructuredTypeRef ref) {
            this.inSource = true;
            this.inInfixFilter = true;
            int startIndex = "$outer".equals(ref.firstSegment()) ? 1 : 0;
            ((CqnReference.Segment)ref.segments().get(startIndex)).filter().ifPresent(f -> f.accept((CqnVisitor)this));
            this.inInfixFilter = false;
            this.base.push((Object)this.followRef((QatNode)this.base.pop(), QatBuilder.skip(startIndex + 1, (CqnReference)ref), this.inSource, this.inInfixFilter));
            this.inSource = false;
        }

        public void visit(CqnElementRef ref) {
            if (CdsModelUtils.isContextElementRef((CqnElementRef)ref)) {
                return;
            }
            switch (ref.firstSegment()) {
                case "$outer": {
                    return;
                }
                case "$main": {
                    QatEntityNode en;
                    QatSelectableNode mainNode;
                    if (this.inSource && QatBuilder.this.main == null) {
                        throw new CqnValidationException("Cannot resolve " + String.valueOf(ref) + ". $main in FROM is only supported in subqueries.");
                    }
                    QatSelectableNode qatSelectableNode = mainNode = QatBuilder.this.main != null ? QatBuilder.this.main : QatBuilder.qatRoot(QatBuilder.this.root);
                    if (mainNode instanceof QatEntityNode && (en = (QatEntityNode)mainNode).filter().isPresent()) {
                        throw new UnsupportedOperationException("Cannot resolve " + String.valueOf(ref) + ". $main is not supported for paths with an infix filter on the last segment.");
                    }
                    this.followRef(mainNode, QatBuilder.skip(1, (CqnReference)ref), this.inSource, false);
                    return;
                }
            }
            List<? extends CqnReference.Segment> segments = ref.segments();
            if (segments.size() > 1 && ref.firstSegment().equals(this.rootEntity)) {
                segments = QatBuilder.skip(1, (CqnReference)ref);
            }
            this.followRef((QatNode)this.base.peek(), segments, this.inSource, this.inInfixFilter);
        }

        public void visit(CqnScalarSubquery subquery) {
            QatNode outer = (QatNode)this.base.peek();
            ((Subquery)subquery).setOuter((Object)outer);
            this.handleSubquery(outer, subquery.query());
        }

        private void handleSubquery(final QatNode outer, CqnSelect subquery) {
            CqnVisitor v = new CqnVisitor(){

                public void visit(CqnElementRef ref) {
                    this.handleOuter((CqnReference)ref);
                }

                public void visit(CqnStructuredTypeRef ref) {
                    this.handleOuter((CqnReference)ref);
                }

                private void handleOuter(CqnReference ref) {
                    switch (ref.firstSegment()) {
                        case "$main": {
                            QatSelectableNode mainNode = QatBuilder.this.main != null ? QatBuilder.this.main : QatBuilder.findSourceNode(outer);
                            CollectRefsVisitor.this.followRef(mainNode, QatBuilder.skip(1, ref), false, false);
                            return;
                        }
                        case "$outer": {
                            CollectRefsVisitor.this.followRef(outer, QatBuilder.skip(1, ref), false, false);
                            return;
                        }
                    }
                }
            };
            subquery.accept(v);
        }

        public void visit(CqnContainmentTest test) {
            test.args().forEach(a -> a.accept((CqnVisitor)this));
        }

        private QatNode followRef(QatNode current, List<? extends CqnReference.Segment> segments, boolean inSource, boolean rejectPaths) {
            if (rejectPaths && segments.size() > 1) {
                throw new UnsupportedOperationException("Paths expressions are not supported in this context: " + String.valueOf(segments));
            }
            int lastSegment = segments.size() - 1;
            for (int i = 0; i < segments.size(); ++i) {
                QatElementNode en;
                CqnReference.Segment seg = segments.get(i);
                if (seg.id().equals("$self") || seg.id().equals("$projection")) {
                    throw new UnsupportedOperationException("Cannot resolve element reference " + String.valueOf(segments) + ". " + seg.id() + " is not supported.");
                }
                current = this.addChild(current, seg, inSource, i == lastSegment);
                this.traverseFilter(current, seg);
                if (current instanceof QatElementNode && (en = (QatElementNode)current).isJson()) break;
            }
            return current;
        }

        private QatNode addChild(QatNode node, CqnReference.Segment seg, boolean inSource, boolean lastSegment) {
            QatNode child;
            String id = seg.id();
            Optional filter = seg.filter();
            CdsStructuredType rowType = ((QatStructuredNode)node).rowType();
            CdsElement element = rowType.getElement(id);
            CdsType type = element.getType();
            boolean joinRequired = false;
            if (type.isAssociation()) {
                joinRequired = inSource || !lastSegment;
                QatAssociation assoc = this.handleAssociation(element);
                child = new QatAssociationNode(node, assoc, (Optional<CqnPredicate>)filter, inSource);
            } else {
                child = type.isStructured() ? new QatStructuredElementNode(node, element) : new QatElementNode(node, element);
            }
            return node.addChild(child, filter, joinRequired);
        }

        private void traverseFilter(QatNode node, CqnReference.Segment seg) {
            this.inInfixFilter = true;
            seg.filter().ifPresent(f -> {
                this.base.push((Object)node);
                f.accept((CqnVisitor)this);
                this.base.pop();
            });
            this.inInfixFilter = false;
        }

        private QatAssociation handleAssociation(CdsElement association) {
            CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
            CqnPredicate on = this.associationAnalyzer.getOnCondition(association);
            return new QatAssociation(target, association.getName(), on);
        }
    }
}

