/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.qat;

import com.sap.cds.impl.qat.QatAssociationNode;
import com.sap.cds.impl.qat.QatEntityNode;
import com.sap.cds.impl.qat.QatVisitor;
import com.sap.cds.ql.cqn.CqnExpression;
import com.sap.cds.ql.cqn.CqnPredicate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class QatNode {
    private final QatNode parent;
    private final Map<Key, QatNode> children = new LinkedHashMap<Key, QatNode>();
    private final Set<Key> joinRequired = new HashSet<Key>();

    public QatNode(QatNode parent) {
        this.parent = parent;
    }

    public abstract String name();

    public abstract boolean inSource();

    public abstract void accept(QatVisitor var1);

    public QatNode parent() {
        return this.parent;
    }

    public Collection<QatNode> children() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    public boolean hasChildren() {
        return !this.children().isEmpty();
    }

    public QatNode child(String name, Optional<CqnPredicate> filter) {
        return this.children.get(new Key(name, filter));
    }

    public <T extends QatNode> T addChild(T child, Optional<CqnPredicate> filter, boolean join) {
        Key key = new Key(child.name(), filter);
        this.children.putIfAbsent(key, child);
        QatNode node = this.children.get(key);
        QatNode.propagateInSource(child, node);
        if (join) {
            this.joinRequired.add(key);
        }
        try {
            return (T)node;
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException("Query association tree contains element " + child.name() + " with unexpected type " + node.getClass().getName(), ex);
        }
    }

    private static void propagateInSource(QatNode newNode, QatNode existingNode) {
        if (newNode != existingNode && newNode instanceof QatEntityNode) {
            QatEntityNode newEntityNode = (QatEntityNode)newNode;
            if (existingNode instanceof QatEntityNode) {
                QatEntityNode existingEntityNode = (QatEntityNode)existingNode;
                if (newEntityNode.inSource() && !existingEntityNode.inSource()) {
                    existingEntityNode.setInSource();
                }
            }
        }
    }

    public <T extends QatNode> T addChild(T child) {
        return this.addChild(child, Optional.empty(), true);
    }

    boolean skipJoin(QatAssociationNode node) {
        Key key = new Key(node.name(), node.filter());
        return !this.joinRequired.contains(key);
    }

    public String toString() {
        return this.name();
    }

    public static class Key {
        final String name;
        final String filterAsJson;
        final int hashCode;

        public Key(String name, Optional<CqnPredicate> filter) {
            this.name = name;
            this.filterAsJson = filter.map(CqnExpression::toJson).orElse("[]");
            this.hashCode = Key.calculateHash(name, this.filterAsJson);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.hashCode != other.hashCode) {
                return false;
            }
            if (!this.name.equals(other.name)) {
                return false;
            }
            return this.filterAsJson.equals(other.filterAsJson);
        }

        private static int calculateHash(String name, String filterAsJson) {
            int prime = 31;
            int result = 1;
            result = 31 * result + filterAsJson.hashCode();
            result = 31 * result + name.hashCode();
            return result;
        }
    }
}

