/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContainsToLike {
    private static Pattern asteriskPattern = Pattern.compile("(?<!\\\\)((\\\\{2})*)\\*");
    private static Pattern questionmarkPattern = Pattern.compile("(?<!\\\\)((\\\\{2})*)\\?");
    private static final char ESCAPE_CHAR = '\\';

    public static CqnPredicate transform(final CdsStructuredType rowType, final FunctionMapper functionMapper, CqnPredicate pred) {
        return CQL.copy((CqnPredicate)pred, (Modifier)new Modifier(){

            public Predicate containment(CqnContainmentTest.Position position, CqnValue value, CqnValue term, boolean caseInsensitive) {
                CqnValue pattern = ContainsToLike.toLikeTerm(position, term);
                return functionMapper.like(rowType, value, pattern, "\\", caseInsensitive);
            }
        });
    }

    static CqnValue toLikeTerm(final CqnContainmentTest.Position position, CqnValue term) {
        return ExpressionVisitor.copy((CqnValue)term, (Modifier)new Modifier(){

            public CqnValue literal(CqnLiteral<?> literal) {
                if (literal.isString()) {
                    String term = SQLHelper.escapeLikePattern('\\', (String)literal.asString().value());
                    return CQL.val((Object)(switch (position) {
                        default -> throw new IncompatibleClassChangeError();
                        case CqnContainmentTest.Position.ANY -> "%" + term + "%";
                        case CqnContainmentTest.Position.START -> term + "%";
                        case CqnContainmentTest.Position.END -> "%" + term;
                        case CqnContainmentTest.Position.SEARCH -> ContainsToLike.toLikeTerm(term, true);
                        case CqnContainmentTest.Position.MATCH -> ContainsToLike.toLikeTerm(term, false);
                    }));
                }
                return literal;
            }
        });
    }

    private static String toLikeTerm(String term, boolean fallbackToContains) {
        Matcher questionmarkMatcher;
        boolean wildcard = false;
        Matcher asteriskMatcher = asteriskPattern.matcher((CharSequence)term);
        if (asteriskMatcher.find()) {
            term = asteriskMatcher.replaceAll("$1%");
            wildcard = true;
        }
        if ((questionmarkMatcher = questionmarkPattern.matcher((CharSequence)term)).find()) {
            term = questionmarkMatcher.replaceAll("$1_");
            wildcard = true;
        }
        if (!wildcard && fallbackToContains) {
            term = "%" + (String)term + "%";
        }
        return term;
    }
}

